## -*-Tcl-*-
 # ###################################################################
 # 
 #  FILE: "clickUtils.tcl"
 #                                    created: 11/2/96 {9:17:08 am} 
 #                                last update: 05/26/1999 {23:40:52 PM} 
 ##

#  Option click in titlebar  #

# Now doesn't add anything extra for windows which are not saved to disk. 
# To deal with shells and other similar windows.  More general than only
# doing this for shell mode.
proc optClickTB_List {} {
    global minItemsInTitlePopup
    set lines [mode::proc OptionTitlebar]
    if {[llength $lines] < $minItemsInTitlePopup} {
	return [::OptionTitlebar $lines]
    } else {
	return $lines
    }
}

proc ::OptionTitlebar {{lines ""}} {
    if {[file exists [stripNameCount [win::Current]]]} {
	pushd [file dirname [win::Current]]
	if {[llength $lines]} {
	    eval lappend lines "-" [glob -nocomplain *]
	} else {
	    set lines [glob -nocomplain *]
	}
	popd
    }
    return $lines
}

## 
 # -------------------------------------------------------------------------
 #	 
 # "optClickTB_Pick" --
 #	
 #  Called when you select an item from the option-click pop-up.  Call a
 #  mode-specific procedure if possible, else assume it's a file in the
 #  same directory as the current window, and open it.  If the mode
 #  specific procedure ends in an error, we use the default version. 
 # -------------------------------------------------------------------------
 ##
proc optClickTB_Pick {item} {
    if {[catch {mode::proc OptionTitlebarSelect $item}]} {
	::OptionTitlebarSelect $item
    }
}

proc ::OptionTitlebarSelect {item} {
    if {[file isdirectory [file join [file dirname [win::Current]] $item]]} {
	file::showInFinder [file join [file dirname [win::Current]] $item]
    } else {
	file::tryToOpen $item
    }
}

#  Command click on window title  #

# Called from Alpha when titlebar "title" menu selected (command-mouse).
proc getTitleBarPath {} {
    global fetched
    
    set f [win::Current]
    if {[info exists fetched($f)]} {
	set nm "[lindex $fetched($f) 0]/[lindex $fetched($f) 1]/[file tail $f]"
	regsub -all {//} $nm {/} nm
	regsub -all {/} $nm {:} nm
	return $nm
    } else {
	return $f
    }
}

proc titlebar {name} {
    global fetched
    
    if {[info exists fetched([win::Current])]} {
	set specs $fetched([win::Current])
	# add type of link to end of specs for backwards compatibility
	if {[lindex $specs 4] == ""} {
	    lappend specs "ftp"
	    set fetched([win::Current]) $specs
	}
	if {$name == [getTitleBarPath]} {
	    set user ""
	    if {[key::shiftPressed]} {
		set user [lindex $specs 2]
		if {[key::controlPressed]} {
		    append user ":" [lindex $specs 3]
		} 
		append user "@"
	    }
	    putScrap "<[lindex $specs 4]://${user}[lindex $specs 0]/[lindex $specs 1]/[file tail $name]>"
	    message "Copied URL of '[file tail $name]' to the Clipboard."	    
	} else {
	    regexp {[^:]*:(.*)} $name dummy dir
	    if {[regexp {:} $dir]} {
		regexp {(.*):([^:]*)} $dir dummy dir fname
	    } else {
		set fname ""
	    }
	    regsub -all {:} $dir {/} dir
	    eval ftpBrowse [list [lindex $specs 0] $dir] [lrange $specs 2 4] [list $fname]
	}
    } else {
	if {$name == [win::Current]} {
	    if {[key::shiftPressed]} {
		file::showInFinder
	    } else {
		putScrap $name
		message "Copied full path of '[file tail $name]' to the Clipboard."
	    }
	} else {
	    if {[key::shiftPressed]} {
		openFolder $name
	    } else {
		findFile $name
	    }
	}
    }
}

#  Command Double Click  #

proc cmdDoubleClick {{from -1} {to -1} {shift 0} {option 0} {control 0}} {
    global mode
    
    if {[expandURL] != ""} {
	sendUrl [getSelect]
    } else {
	if {$from < 0} {
	    set from [getPos]
	    set to [selEnd]
	    if {[pos::compare $from == $to]} {
		hiliteWord
		set from [getPos]
		set to [selEnd]
	    }
	}
	if {[set proc [mode::getProc DblClick]] != ""} {
	    if {[llength [info args $proc]] == 2} {
		$proc $from $to
	    } else {
		$proc $from $to $shift $option $control
	    }
	} else {
	    message "No docs"
	}
    }	
}

proc commandClick {from to url} {
    select $from
    for {set i 0} {$i < 200} {incr i} {}
    select $from $to
    for {set i 0} {$i < 200} {incr i} {}
    select $from
    for {set i 0} {$i < 200} {incr i} {}
    select $from $to
    icURL $url
}	

#  URL handling  #

# (WTP 7/30/95) Slightly improved 'sendUrl'.
# By accepting a text arg, this can now be used to make sendUrl 
# hypertext links (useful for "mailto" links in documentation, f'rinstance) 
#===============================================================================

proc sendUrl {{text {}}} {
    if {$text == {}} { catch {set text [getSelect]} }
    if {$text == {}} { set text [prompt {URL?} {}] }
    if {[string length $text] == 0} { return }
    icURL $text
}

proc expandURL {} {
    set pos [getPos]
    set beg [lineStart $pos]
    if {[string length [set whe [search -s -n -f 1 -r 1 -i 1 -m 0 -l [nextLineStart $pos] {[a-zA-Z0-9]+://[a-zA-Z/._0-9~-]+} $beg]]]} {
	if {([pos::compare $pos >= [lindex $whe 0]]) \
	  && ([pos::compare $pos < [lindex $whe 1]])} {
	    eval select $whe
	    return $whe
	}
    }
}



#  Printing helpers  #

proc printLeftHeader {pg {f ""}} {
    global printHeader printHeaderTime printHeaderFullPath
    
    if {!$printHeader} return
    
    if {$f == ""} {set f [win::Current]}
    if {$printHeaderFullPath} {
	set text $f
    } else {
	set text [file tail $f]
    }
    
    if {$printHeaderTime} {
	append text "      [join [mtime [now] short]]"
    }
    return $text
}

proc printRightHeader {pg {f ""}} {
    global printHeader
    if {!$printHeader} return
    return "Page $pg"
}

proc printAll {} {
    foreach f [winNames -f] {
	print $f
    }
}

#  Spellcheck helpers  #

#================================================================================
# Excalibur is the only Mac spell-checker that I know of which will handle 
# LaTeX as well as ordinary text.


proc spellcheckWindow {} {
    global resumeRevert

    set name [app::launchFore XCLB]
    
    if {[winDirty]} {
	if {[dialog::yesno "Save '[win::CurrentTail]'?"]} {
	    save
	}
    }
    sendOpenEvent noReply [file tail $name] [stripNameCount [win::Current]]
    set resumeRevert 1
}

proc spellcheckSelection {} {
    if {[pos::compare [getPos] == [selEnd]]} {
	beep
	message "No selection"
	return;
    }
    set name [app::launchBack XCLB]
    copy
    switchTo $name
}









