#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>

int main (int argc, char **argv, char **env)
{
    int ph[2],org[2];
    int ret, c;

    if (argc <= 1) {
        printf("usage: pipe_wr <program that uses stdout>");
        return (1);
    }

    if (pipe (ph) != 0) {
	perror ("pipe");
	return (2);
    }

    /* redirect stdout */
    org[1] = dup( fileno( stdout ) );
    dup2( ph[1], fileno( stdout ) );

    fcntl (ph[0], F_SETFD, FD_CLOEXEC);  /* don't inherit pipe handles */
    fcntl (ph[1], F_SETFD, FD_CLOEXEC);

    ret = spawnvpe(P_NOWAIT, argv[1], argv + 1, env);

    dup2( org[1], fileno( stdout ) );
    close(org[1]);

    if (ret < 0) {
	printf("swapn program error\n");
	return (1);
    } else
	printf("-----------------------------------------\n");

    close (ph[1]);  /* to stop reading */

    /* read pipe */
    while (1) {
	int rc = read(ph[0], &c, 1);
	if (rc <= 0) {
	    printf("-----------------------------------------\n");
	    return (0);
	}
	write(2, &c, 1);
    }

    close (ph[0]);
    return (0);
}
