/*
 * SOURCE:  edit.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef EDIT_H
#define EDIT_H

#define EDIT_WIDTH 250
#define EDITW_TOP 1
#define EDITW_LEFT 0
#define EDITW_WIDTH 80

#define SCROLLINES (ed.EditHeight-3)
#define SCROLLCOLS 8


#define SHORTFILENAMELEN 27

struct Clipboard {
    unsigned flags;
    unsigned size;
    unsigned lines;
    unsigned char _far *buffer;
};
#define CLIP_EMPTY  (1<<0)  /* clipboard is empty */
#define CLIP_EXTERN (1<<1)  /* clipboard is saved in file */
#define CLIP_STREAM (1<<3)  /* stream clipboard */
#define MAXCBSIZE 16      /* maximum size for clipboard in memory */


        // Flags for Editor.Flags
#define MODIFIED     (1L<<0)     // Buffer has been modified
#define LINECHANGED  (1L<<1)     // Line has been modified
#define PSEUDOFILE   (1L<<2)     // Buffer is Pseudofile
#define INDENT       (1L<<3)     // Indent is on
#define AUTOSAVE     (1L<<4)     // Autosave is on
#define OVERTYPE     (1L<<5)     // Overtype Mode
#define READONLY     (1L<<6)     // Readonly Mode
#define TEMPFILE     (1L<<7)     // Buffer is temporary
#define MARKED       (1L<<8)     // Something is marked
#define BACKUP       (1L<<9)     // Backup Mode
#define SHIFTMARKED  (1L<<10)    // marking using Shift+...
#define EXPANDTABS   (1L<<12)    // expand tabs to spaces
#define TRACKFILES   (1L<<13)    // track files while searching errors
#define TRACKLINES   (1L<<14)    // track line numbers while searching errors
#define DISPLAY_MEM  (1L<<15)    // Display Free Mem, not time

#define UNTITLEDNAME  "<untitled>"

struct Editor {
    unsigned char EditHeight;
    unsigned int CursorX, CursorY;
    unsigned int WindowX, WindowY;
    unsigned int MarkX, MarkY;
    unsigned int WordWrap;
    unsigned int TabStops;
    unsigned int CurrFile;
    unsigned int LastFile;
    unsigned long Flags;
    unsigned int SearchFlags;
    char ShortFileName[SCREEN_WIDTH];
    char *DiskFileName;
};

#define MR_MARKED    (1<<0)
#define MR_MULTILINE (1<<1)
#define MR_FORWARDS  (1<<2)
#define MR_INITVAL   (1<<3) /* this flag can be used to initialize
                               static variables to check if the
                               structure has ever been initialized */

struct MarkRegion {
    unsigned int UpperX, UpperY, LowerX, LowerY;
    char buffer[EDIT_WIDTH];
    unsigned int flags;
};

struct Mark {
    unsigned int CursorX, CursorY;
    unsigned int WindowX, WindowY;
};

struct KeyTable {
    unsigned int Code;
    char *Name;
    int (*Macro)( int, int );
};

        // flags for e_search()
#define SEARCH_PLUS    (1<<0)
#define SEARCH_MINUS   (1<<1)
#define SEARCH_CASE    (1<<2)
#define SEARCH_REGULAR (1<<3)   // not implemented yet
#define SEARCH_QUERY   (1<<4)   // search includes current pos
#define SEARCH_FILES   (1<<5)   /* serach across files */

        // reason for e_putmsg()
#define MSG_NULL   0x00
#define MSG_STNDRD 0x01
#define MSG_BADKEY 0x02
#define MSG_ERROR  MSG_BADKEY
#define MSG_TEXERR 0x04
#define MSG_SEARCH 0x08

        // flags for m_save()
#define SAVE_NORMAL 0
#define SAVE_QUERY  1
#define SAVE_ALWAYS 2

#define NO_ALTERNATE_BUF 0
#define LINE_TOO_LONG    1

        // global variables
extern int verbose, status;

int edit( struct InputEvent *ie );

int (*e_getkey( unsigned int ))();
void e_getkeyname( unsigned int, char * );
int e_cancel( int, int );
int e_drawflags( void );

int e_status( int );

int e_charins( int, int );
int e_strins( unsigned char _huge * );
int e_strnins( unsigned char _huge *, unsigned int );
int e_markword( int, int );
int e_tab( int, int );
int e_backtab( int, int );
int e_return( int, int );
int e_chardel( int, int );
int e_linedel( int, int );
int e_lineins( int, int );
int e_backsp( int, int );

void e_redraw( void );
void e_refresh( void );

void e_deletemr( void );
void e_drawmr( void );

int e_close( unsigned int );
int e_load( char * );
int e_setfile( unsigned );
int e_getfile( unsigned );
int e_new( void );

int e_savekoords( void );
int e_getkoords( void );

int e_next( void );
int e_prev( void );
int e_last( void );

int e_up( int, int );
int e_down( int, int );
int e_left( int, int );
int e_right( int, int );
int e_pgup( int, int );
int e_pgdown( int, int );
int e_begfile( int, int );
int e_endfile( int, int );
int e_home( int, int );
int e_end( int, int );
int e_homewin( int, int );
int e_endwin( int, int );
int e_nextword( int key, int c );
int e_prevword( int key, int c );

int e_goto( int, int, int, int );
int e_search( unsigned char *, unsigned int, struct MarkRegion * );
int e_replace( int, unsigned char *, unsigned int );
void e_getclipboardstruct( struct Clipboard * );
int e_savecboard( void );
int e_loadcboard( void );
int e_copy( int, int );
int e_cut( int, int );
int e_jpaste( int, int );
int e_paste( int, int );

int e_merge( char * );

int e_insmode( int, int );
int e_setmark( int, int );
int e_remark( int, int );
int e_gomark( int, int );
int e_swapdm( int, int );
int e_markline( int, int );
int e_delend( int, int );
int e_delbeg( int, int );
int e_format( int, int );
int e_learn( int, int );
int e_launch( int, int );
int e_balance( int, int );

int et_lastitem( int, int );
int et_begin( int, int );
int et_end( int, int );
int et_index( int, int );

void e_invalidarg( int topic );

#endif
