/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.base.BoolPar;
import nts.command.ContextDisplay;
import nts.command.Token;
import nts.command.Tokenizer;
import nts.io.CharCode;
import nts.io.InputLine;
import nts.io.Name;

public class InputLineTokenizer
extends Tokenizer {
    public static final InputLineTokenizer NULL;
    private static final byte NEW_LINE = 0;
    private static final byte MID_LINE = 1;
    private static final byte SKIP_BLANKS = 2;
    public static final byte ESCAPE = 0;
    public static final byte LETTER = 1;
    public static final byte SPACER = 2;
    public static final byte ENDLINE = 3;
    public static final byte COMMENT = 4;
    public static final byte IGNORE = 5;
    public static final byte OTHER = 6;
    private InputLine line;
    private TokenMaker maker;
    private String desc;
    private byte state = 0;

    public void setMidLine() {
        this.state = 1;
    }

    public Token nextToken(BoolPar canExpand) {
        canExpand.set(true);
        return this.nextToken();
    }

    public Token nextToken() {
        CharCode code;
        block7: while ((code = this.line.getNext()) != null) {
            switch (this.maker.scanCat(code)) {
                case 0: {
                    code = this.line.getNext();
                    if (code == null) {
                        return this.maker.make(new Name());
                    }
                    byte cat = this.maker.scanCat(code);
                    if (cat != 1) {
                        this.state = (byte)(cat == 2 ? 2 : 1);
                        return this.maker.make(new Name(code));
                    }
                    Name.Buffer buf = new Name.Buffer();
                    buf.append(code);
                    while ((code = this.line.peekNext()) != null && this.maker.scanCat(code) == 1) {
                        buf.append(code);
                        this.line.getNext();
                    }
                    this.state = (byte)2;
                    return this.maker.make(buf.toName());
                }
                case 3: {
                    this.line.skipAll();
                    if (this.state == 1) {
                        return this.maker.makeSpace();
                    }
                    if (this.state != 0) continue block7;
                    return this.maker.makePar();
                }
                case 2: {
                    if (this.state != 1) continue block7;
                    this.state = (byte)2;
                    return this.maker.makeSpace();
                }
                case 4: {
                    this.line.skipAll();
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    this.state = 1;
                    return this.maker.make(code);
                }
            }
        }
        return null;
    }

    public boolean finished() {
        return this.line.empty();
    }

    public boolean finishedInsert() {
        return this.line.empty();
    }

    public int show(ContextDisplay disp, boolean force, int lines) {
        disp.normal().startLine().add(this.desc);
        this.line.addContext(disp.left(), disp.right(), true);
        disp.show();
        return 1;
    }

    public InputLineTokenizer(InputLine line, TokenMaker maker, String desc) {
        this.line = line;
        this.maker = maker;
        this.desc = desc;
    }

    public static interface TokenMaker {
        public byte scanCat(CharCode var1);

        public Token make(Name var1);

        public Token make(CharCode var1);

        public Token makeSpace();

        public Token makePar();
    }
}

