/**************************************************************************
  This is pmCSTeX for EPM, version 16. 4. 2000

  This macro file pmCSTeX.e (together with pm4epm.e) implements
  the CSTeX menu for various (La)TeX related commands.

  This package was intended to be the (final?) replacement for the packages
  CSTeX for DOS, EPMTeX, TeXshell and pmgraf (and emacs perhaps?) under OS/2.
  *Must have* for {em}(La)TeXing under OS/2 :-)

  This file belongs to the "pmCSTeX for EPM" package, see 
     http://www.sci.muni.cz/~mikulik/os2/pmCSTeX.html
  or pmcstex.zip on hobbes, leo and CTAN archives.

  Copyright  1996  Petr Mikulik
  -----------------------------
  License: free-latex     distributed under the same terms as LaTeX
  This program can be redistributed and/or modified under the terms
  of the LaTeX Project Public License Distributed from CTAN
  archives in directory macros/latex/base/lppl.txt; either
  version 1 of the License, or any later version.
 
  License meaning in short: use and distribution permitted, like any 
  freeware. Package must be distributed together with the source code. 
  Reuse of the source code or any part of it is allowed. Any changes or
  enhancement to this package must involve a change of name unless these
  changes are accepted by the author. You are welcome to submit your 
  bugfixes, updates or new features.
    Because the program is licensed free of charge, there is no warranty 
  for any of its component. You are responsible for any software, hardware, 
  human or nature disaster resulting from installing and using of this 
  package.


  Author's address:
  -----------------
  Petr Mikulk
  Department of Solid State Physics 
    and Laboratory of Thin Films and Nanostructures
  Faculty of Science
  Kotlarska 2 (Kotl\'a\v rsk\'a 2)
  Masaryk University
  Brno
  Czech Republic

  mikulik@physics.muni.cz
  http://www.sci.muni.cz/~mikulik/


  Installation:
  -------------
 0. *** Please read manual pmCSTeX.INF, and ignore the following: ***
 1. Copy this file and pm4epm.e to any directory on your EPMPATH
    (create directory E:\APPS\EPM\CSTeX, copy all files into it, modify
     EPMPATH=...;E:\APPS\EPM\CSTeX;... in your CONFIG.SYS)
 2. Write these lines into your Profile.erx:
	'link pm4epm'
	'link pmcstex'
	'link czech'  -- this is for Czech users: Czech keyboard implementation by Z. Wagner 	
	'link sampactn' -- there is syntax highlighting there
	'link MyCNF'  -- there are your actions there 
 3. Add these two lines into  actions.lst  file:
	CSTeX
	pm4epm
 4. Maybe something more, thus:
 5. *** Please do the installation according to the pmCSTeX.INF ***

 Compilation (of *.e to *.ex files):
 -----------------------------------
 You must have received file  stdconst.e  from EPMMAC.ZIP  (it can be found
 on hobbes.nmsu.edu:os2/editors, on leo, on IBM EWS...). Then type
	etpm pm4epm
	etpm cstex

  If you find bugs, or you find something missing, or you want to send
  me your improvements or new features to put it in, then you are welcome.

***************************************************************************/

/*
My comments on the history (the details for the ordinary users are written in the
enclosed .INF documentation):

o 16.4.2000
	vlnka2.exe removed, replaced by vlna.exe; changes in menu
o 6.3.1999
	enhancement for hotkeys Ctrl/3,4 for the inclusion of (AMS-)LaTeX environments:
	  if a line-marked block (Alt-L) exists, then the choosen environment surrounds it; 
	  otherwise environment inserted at the cursor position (as before)
o 14.12.1998
	improvement: skipping text between "Overfull/Underfull" and "[]" (sometimes produced 
	  a warning about wrong number of corrupted .log file because of parenthesis)
	improvement: skipping text from "LaTeX Warning:" until blank line
o 18.1.1998
	bugfix: the greek keyboard was switching off the Spell checking. 
	next_error: enhanced for "Show me this Warning from this .log file"
o 5.1.1998
	paragraph TeXing enhanced for line blocks
o 29.12.1997
	new action and menu item: TeX->PS
o 26.11.1997
	view documentation enhanced to browse pmCSTeX and LaTeX2e .INFs
o 11.11.1997
	TeXing a paragraph: now going via $cstex$.cmd script in order to avoid the 
	  the EPM string length limitation
	'View documentation' menu item added.
	already_in_ring replaced by its explicit expansion.
o 24.9.1997
	TeXing a paragraph on another partition: (cd %d) changed to (%h&cd %d)
o 16.7.1997
	Include command (Alt-1) now accepts absolute pathnames, even in unix format
o 13.4.1997
	Spain dictionary added
	warning if the selected dictionary does not exist
	ksi->xi fixed. psview.cmd. makeindex options
o 5.2.1997
	bugfix for a typo in the previously updated version of the protection against
	  damaged .log files
o 3.2.1997
	collisions with hotkeys taken away
o 30.1.1997+1.2.1997
	playing with circleit
o 23.1.1997
	*.bak cleaned too + highlit_all is now OK
o 4.1.1997
	update for master file to be firstly searched in the directory of the working file,
	  and some other things
o 30.11.1996
	dvi-out2, vlnka2
o 28.10.1996
	dictionaries FR.dic, UK.dic, US.dic, etc. are taken from the
	  directory written in the EPM_DICTIONARIES environmental variable. If this
	  variable is not set, then from \APPS\EPM
o 22.10.1996
	for the CS version: separate BibTeX, MakeIndex and csBibTeX, csMakeIndex
o 9.10.1996
	in DEFC cstex_highlight_all added nextfile after the loop
o 22.7.1996
	typo smalle->small corrected; Ctrl/1, Ctrl/6, Ctrl/7 added
o 11.6.1996
	added dictionary (language) menu. The corresponding compile option is PM_DICTIONARIES
o 8.6.1996
	the first international release of pmCSTeX for EPM: 
o since January 1996
	creation and the early releases
*/

include 'stdconst.e'	-- from EPMMAC.ZIP
-- include 'pm4epm.e'  -- Routines are used, but include not needed


/*** define CSTeX hotkeys ***/
def C_F11 = 'cstex_texit_and_dvips S'
def S_F11 = 'cstex_texit_background S'
def S_F12 = 'cstex_next_error S'

DEFINIT
  universal	pm4epm_MasterNotFound,
		cstex_error_array_id, cstex_error_index, cstex_errorarray_name,
		cstex_no_more_errors,
		cstex_true_tex_background, cstex_background_beep,
		cstex_prev_keyset
cstex_error_index=-1
cstex_no_more_errors=0
cstex_true_tex_background=1  -- background compilation is: 0=window 1=icon
cstex_background_beep=0      -- 0/1 nobeep/beep after background the texing
'PostMe BuildCSTeXMenu'


/*
DEFLOAD 
  -- 'a_togl_hilit S'
  -- 'toggle_parse 1 epmkwds.tex'
Syntax highlighting is now discussed in the manual pmCSTeX.INF. 
Toggling the syntax on has been moved to your local config file, i.e. MyCNF.e
*/


const
CSTEX_CSTEX = 1 -- allow Czech (CSTeX distribution) related features
-- CSTEX_CSTEX = 0 -- disable Czech (CSTeX distribution) related features
  -- enables/disables CSTOCS, CSTeX spell checker, dvi-out etc. 

  CSTEX_CS2CS = 1 -- use cs2cs program for Czech to Czech conversion
  -- CSTEX_CS2CS = 0 -- use old DOS program

  PM_DICTIONARIES = 1 -- menu item to change the dictionary file (11.6.1996)
  -- PM_DICTIONARIES = 0 -- do not have that item in the CSTeX menu

  CSTEX_USEMASTERDIR = 1
	-- master file is firstly searched in the directory of the working file
  --  CSTEX_USEMASTERDIR = 0
	-- master file is searched in the current directory (the directory
	-- from which the EPM was started from)
	-- Obsolete because of unpredictable results, DON'T USE THE CHOICE 0

const
  cstex_texit_inf = 'Compile document by (La)TeX  (pm_command_cmd %format.cmd %N)'
  cstex_preview_inf = 'Preview document by dvipm (using dvipm.cnf)'
  cstex_paragraph_inf = 'Run LaTeX over current paragraph or line block'
  cstex_texit_and_dvips_inf = 'TeX->PS: compile the document and run dvips afterwards'
  cstex_dvips_inf = 'Run dvi-out and dvips'
  cstex_master_inf = 'Load Master file'
  cstex_include_inf = 'Load the file under the cursor'
  cstex_refresh_inf = 'Refresh current file (reload from disk)'
  cstex_save_all_inf = 'Save all files in the ring'
  cstex_highlight_all_inf = 'Toggle syntax highlighting for the whole ring'
  cstex_texit_background_inf = '(La)TeX the document on background'
  cstex_next_error_inf = 'Locate next error in .log file (and open .log if necessary)'
  cstex_gvpm_inf = 'run dvips and then preview by ghostview'

DEFC cstex_actionlist
universal ActionsList_FileID

 insertline 'cstex_texit'cstex_texit_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_preview'cstex_preview_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_paragraph'cstex_paragraph_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_texit_and_dvips'cstex_texit_and_dvips_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_dvips'cstex_dvips_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_master'cstex_master_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_include'cstex_include_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_refresh'cstex_refresh_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_save_all'cstex_save_all_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_texit_background'cstex_texit_background_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_next_error'cstex_next_error_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_highlight_all'cstex_highlight_all_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'cstex_gvpm'cstex_gvpm_inf'CSTeX',ActionsList_FileID.last+1,ActionsList_FileID

const
  worldindex='makeindx'
  worldbibtex='BibTeX'
COMPILE IF CSTEX_CSTEX=1
  csindex='csIndex'
  csbibtex='csBibTeX'
COMPILE ELSE
  csindex='makeindx'
  csbibtex='BibTeX'
COMPILE ENDIF

--------------------- KEYS DEFINITION ---------------------------------

-- CTRL/1 Titles, contributed by M.H., 22.7.96/15.6.96
def C_1 =
s=',subparagraph,paragraph,subsubsection,subsection,section,chapter,mychapter,foilhead'
s=listbox('sectioning commands',s,,20,22,8,25)  -- pos1,pos2,height,width
if s='' then return; endif
getline x; replaceline( insertstr('\'s'{}',x,.col-1) )
.col=.col+1+length(s)+1


-- CTRL/3 \begin{} \end{} LaTeX environment
def C_3 =
--x=winmessagebox('Choose environment','i=itemize' ,65535)
  /* -- This comes from my Turbo Vision pmgraf program
  s=',flush~left,~center,flush~right,eqnarray,~equation,array,~tabular,tabular*,table,tabbing,'
  s=s'e~numerate,~itemize,~description,displaymath,~picture,~figure,~verbatim,verbatim*,document'
  */
s=',array,center,description,displaymath,document,enumerate,eqnarray,equation,figure,flushleft,flushright,itemize,picture,tabbing,table,tabular,verbatim'
s=listbox('environment',s,,20,22,17,25)  -- pos1,pos2,height,width
-- s=entry_box('environment',s,'equation',30,30)
if s='' then return; endif 
s=word(s,1)
if marktype()='LINE' then -- 6.3.1999: surround line-marked text by the choosen environment
  getmark lfrom,lto
  insertline '\begin{'s'}',lfrom
  insertline '\end{'s'}',lto+2
  return
  endif
-- insert the environment and a blank line in between
if .col>1 then .line=.line+1; endif
insertline '\begin{'s'}'
insertline ''
insertline '\end{'s'}'
.line=.line-2
.col=1


-- CTRL/4 AMSLaTeX environments
def C_4 =
s=',align,align*,aligned,alignat,alignat*,bmatrix,cases,flalign,flalign*,gather,gather*,gathered,matrix,multline,multline*,pmatrix,smallmatrix,split,subarray,subequations,Sb,Sp,vmatrix,Vmatrix,xalignat,xlignat*,xxalignat,xxlignat*'
s=listbox('AMSLaTeX env.',s,,26,22,23,25)  -- pos1,pos2,height,width
-- s=entry_box('environment',s,'equation',30,30)
if s='' then return; endif 
s=word(s,1)
if marktype()='LINE' then -- 6.3.1999: surround line-marked text by the choosen environment
  getmark lfrom,lto
  insertline '\begin{'s'}',lfrom
  insertline '\end{'s'}',lto+2
  return
  endif
-- insert the environment and a blank line in between
if .col>1 then .line=.line+1; endif
insertline '\begin{'s'}'
insertline ''
insertline '\end{'s'}'
.line=.line-2
.col=1


-- CTRL/5 LATeX font sizes
def C_5 =
s=',tiny,scriptsize,footnotesize,small,normalsize,large,Large,LARGE,huge,Huge'
s=s',mathbf,mathcal,mathnormal,mathrm,mathsf,mathit,mathtt,mathfrak,boldsymbol,pmb,mathbb,mathrsfs'
--s=listbox('font size',s,,20,22,10,25)  -- pos1,pos2,height,width
s=listbox('font size',s,,20,24,20,25)  -- pos1,pos2,height,width
if s='' then return; endif
getline x; replaceline( insertstr('\'s,x,.col-1) )
.col=.col+1+length(s)


-- CTRL/6 text fonts
def C_6 =
s=',textrm,textsf,texttt,textmd,textbf,textup,textit,textsl,textsc,emph,textnormal'
s=listbox('text font',s,,20,22,11,25)  -- pos1,pos2,height,width
if s='' then return; endif
getline x; replaceline( insertstr('\'s'{}',x,.col-1) )
.col=.col+1+length(s)+1

-- CTRL/7 text fonts
def C_7 =
s=',rmfamily,sffamily,ttfamily,mdseries,bfseries,upshape,itshape,slshape,scshape,em,normalfont'
s=listbox('text font',s,,20,22,11,25)  -- pos1,pos2,height,width
if s='' then return; endif
getline x; replaceline( insertstr('{\'s' }',x,.col-1) )
.col=.col+1+length(s)+1




-- Alt-G defines Greek keyboard. Keyboard layout according to Chi-writer
def A_G =
  universal cstex_prev_keyset,czech_is
-- sayerror 'current keyset='.keyset'   czech_is='czech_is
cstex_prev_keyset=.keyset
keys pm_GreekKeys

-- DEFKEYS pm_OrigKeys overlay

DEFKEYS pm_GreekKeys overlay
def 'a'-'z','G','D','S','L','X','P','Y','F','O','Q','J' = pm_TypeGreek()

DEFPROC pm_TypeGreek()
  universal czech_is, cstex_prev_keyset, cstex_prev_keyset
a=lastkey(0)
GreekAlphabet='\alpha\beta\chi\delta\epsilon\phi\gamma\eta\iota\psi\kappa\lambda\mu\nu\omega\pi\theta\rho\sigma\tau\varepsilon\varphi\vartheta\xi\upsilon\zeta\'
a=asc(a);
if a>90 then i=a-96; else i=a-64; endif
p=1; j=2
while j<=i do p=pos('\',GreekAlphabet,p+1); j=j+1; endwhile
i=pos('\',GreekAlphabet,p+1); 
if a>90 
  then s=substr(GreekAlphabet,p,i-p)
  else s=upcase(substr(GreekAlphabet,p+1,1)); s='\'s''substr(GreekAlphabet,p+2,i-p-2)
  endif
getline x; replaceline( insertstr(s,x,.col-1) )
.col=.col+length(s)
-- load the keyset as before. If Czech.E is used, then czech_is holds the state
-- New keys switching implemented on 18.1.1998 (Greek switched off spell checking):
-- Unfortunately, neither or these 2 work:   keys 'edit_keys'    .keyset=cstex_prev_keyset
-- and thus doing it explicitly:
-- InfoBox('cstex_prev_keyset',cstex_prev_keyset)
-- sayerror 'cstex_prev_keyset='cstex_prev_keyset
-- if cstex_prev_keyset='EDIT_KEYS' then keys edit_keys
if cstex_prev_keyset='EDIT_KEYS' then 
	if 	czech_is=1 then keys czech_keys
	elseif	czech_is=2 then keys czech_switch
	else keys edit_keys
	endif
elseif cstex_prev_keyset='SPELL_KEYS' then keys spell_keys
elseif cstex_prev_keyset='CZECH_KEYS' then keys czech_keys
elseif cstex_prev_keyset='CZECH_SWITCH' then keys czech_switch
elseif cstex_prev_keyset='PM_GREEKKEYS' then keys edit_keys -- this should not happen!
else ErrorBox('Sorry, the previous keyset is uknown','Please, modify the end of the routine pm_TypeGreek() in CSTeX.e (part ... elseif cstex_prev_keyset= ...) for the keyset 'cstex_prev_keyset)
endif
-- This was the old (until 18.1.1998) keys switching:
/*
if 	czech_is=1 then keys czech_keys
elseif	czech_is=2 then keys czech_switch
else 	keys pm_OrigKeys
endif
*/



------------------------ PROCEDURES -----------------------------



/*
Wait a little bit. I don't know how to put a DOS prog into window
without STARTing it.
Note: this routine is no more use; it was in use when calling some DOS
programs in the Czech version.
*/
COMPILE IF CSTEX_CSTEX=1
DEFPROC PleaseRelax ()
InfoBox('Please relax...','Wait till the program finishes. I do not know how to run DOS windowed program and wait till it finishes. Please send me the solution if you know it.')
return
COMPILE ENDIF


DEFC cstex_texit
  universal pm4epm_MasterNotFound, cstex_reLaTeXed
parse arg action x
if action='S' then 
  i=length(.filename)
  if (i>4) and (upcase(substr(.filename,i-3,4))='.LOG')  -- update 28.5.1996
	then	e='% MASTER: 'substr(.filename,1,i-4)'.tex'
		insertline e,1
 		N=pm_expansion('%format.cmd %N') -- you edit .log file, thus name only
 	else	N=pm_expansion('%format.cmd %.N') -- full name
	endif
  if pm4epm_MasterNotFound=1 then return ''; endif
  save_the_ring()
  e=get_env('EMTEXOPT');	-- now cool tricks to set up EMTEXOPT environmental variable
  if (words(e)>0) then e=e' ' endif
  e=e''pm_expansion('%optsemtex')
  if (words(e)=0) then e=N; else e='(set EMTEXOPT='e') & 'N; endif
  COMPILE IF CSTEX_USEMASTERDIR=1
  e=pm_expansion('%h & (cd %d) &')''e  -- 4.1.1997
  COMPILE ENDIF
  'start /c /win /f cmd.exe /c "'e'"'
  cstex_reLaTeXed=1  -- information for cstex_next_error
elseif action='I' then sayerror cstex_texit_inf
endif


DEFC cstex_texit_background
  universal pm4epm_MasterNotFound, cstex_reLaTeXed,cstex_true_tex_background, cstex_background_beep
parse arg action param
if action='S' then 
  /* before 28.5.1996:
  i=lastpos('.',.filename)
  if (i>0) and (upcase(substr(.filename,i,length(.filename)-i))='LOG') 
	then	N=pm_expansion('%format.cmd %.N') -- full name
		if pm4epm_MasterNotFound=1 then return ''; endif
	else	N=pm_expansion('%format.cmd %N') -- you edit .log file, thus name only
	endif
  */
  i=length(.filename)
  if (i>4) and (upcase(substr(.filename,i-3,4))='.LOG')  -- update 28.5.1996
	then	e='% MASTER: 'substr(.filename,1,i-4)'.tex'
		insertline e,1
 		N=pm_expansion('%format.cmd %N') -- you edit .log file, thus name only
 	else	N=pm_expansion('%format.cmd %.N') -- full name
	endif
  if pm4epm_MasterNotFound=1 then return ''; endif
  save_the_ring()
  e=get_env('EMTEXOPT')		-- again cool tricks to set up EMTEXOPT environment variable
  if (words(e)>0) then e=e' ' endif
  e=e''pm_expansion('%optsemtex')
  if (words(e)=0) then e='/b'; else e=e' /b'; endif   -- "je to spicovy", it works!
  c='start /c /win /b '
  if (cstex_true_tex_background<>0) then c=c'/min '; endif
  COMPILE IF CSTEX_USEMASTERDIR
  if (param<>'') then N=N' &'param endif -- parameter of dvips after texing: 29.12.1997
  N=pm_expansion('%h&(cd %d)&')''N  -- 4.1.1997
  -- InfoBox('texit: N=',N)
  COMPILE ENDIF
  c=c'cmd.exe /c "(set EMTEXOPT='e')&'N
  -- why that below does not work?
  -- if (cstex_background_beep<>0 || param<>'') then c=c'&echo '; endif
  if (cstex_background_beep<>0 || length(param)<>0) then c=c'&echo '; endif
  -- InfoBox('texit: c=',c) -- for debugging
  c'"' -- add the ending quote and run the command
  -- previously: 'start /c /win /b cmd.exe /c 'N
  cstex_reLaTeXed=1 -- information for cstex_next_error
elseif action='I' then sayerror cstex_texit_background_inf
endif


DEFC cstex_preview
  universal pm4epm_MasterNotFound
parse arg action
if action='S' then 
  COMPILE IF CSTEX_USEMASTERDIR=1  -- 4.1.1997
  M=pm_expansion('%M')
  COMPILE ELSE
  M=pm_expansion('%m')
  -- it was: '%M'  and pointed out by Kroni: TeX always outputs in the current directory
  -- 4.1.1997: this is now overcome by CSTEX_USEMASTERDIR
  COMPILE ENDIF
  -- if pm4epm_MasterNotFound=1 then return ''; endif -- you can have only .dvi file
  if EXIST(M'.dvi')=0 then ErrorBox('Error','.dvi file not found. Please run (La)TeX first.'); return; endif
  COMPILE IF CSTEX_USEMASTERDIR=1  -- 4.1.1997
  'cmd.exe /c "'pm_expansion('%h & (cd %d)')' & start dvipm.exe @dvipm.cnf 'M'"'
  COMPILE ELSE
  'start dvipm.exe @dvipm.cnf ' M
  COMPILE ENDIF
elseif action='I' then sayerror cstex_preview_inf
endif


/*
-- This version is now OBSOLETE. See the remark in the routine below.
DEFPROC cstex_dvips (opts)
  universal pm4epm_MasterNotFound
Master=pm_expansion('%m')  -- changed from '%M'
dvipsopts=pm_expansion('%optsdvips')
-- if pm4epm_MasterNotFound=1 then return ''; endif
if EXIST(Master'.dvi')=0 then ErrorBox('Error','.dvi file not found. Please run (La)TeX first.'); return; endif
COMPILE IF CSTEX_CSTEX=1
'start /win /c /dos dvi-out -m 'Master
PleaseRelax()
COMPILE ENDIF
-- 'cmd /c dvips 'opts' 'Master
x='dvips 'dvipsopts' 'opts' 'Master
sayerror x
'cmd /c 'x
return Master
*/


-- This version is NOW used since the program dvi-out has been compiled for OS/2
DEFPROC cstex_dvips (opts,pause)
  universal pm4epm_MasterNotFound
Master=pm_expansion('%M')
dvipsopts=pm_expansion('%optsdvips')
-- if pm4epm_MasterNotFound=1 then return ''; endif
if EXIST(Master'.dvi')=0 then ErrorBox('Error','.dvi file not found. Please run (La)TeX first.'); return; endif
COMPILE IF CSTEX_CSTEX=1
  -- 8.1.1998: Master is passed first to csdvips, and order reversed in it
  WhichDvips='csdvips 'Master'.dvi 'dvipsopts' 'opts
COMPILE ELSE
  WhichDvips='dvips 'dvipsopts' 'opts' 'Master
COMPILE ENDIF
COMPILE IF CSTEX_USEMASTERDIR=1  -- 4.1.1997
  if (pause=0) then -- 13.4.1997
--  'cmd /c "'pm_expansion('%h & (cd %d)')' & 'WhichDvips' 'dvipsopts' 'opts' 'Master'"'
  'cmd /c "'pm_expansion('%h & (cd %d)')' & 'WhichDvips'"'
  else
--  'start /C /WIN cmd /c "'pm_expansion('%h & (cd %d)')' & ('WhichDvips' 'dvipsopts' 'opts' 'Master') & pause"'
  'start /C /WIN cmd /c "'pm_expansion('%h & (cd %d)')' & ('WhichDvips') & pause"'
  endif
COMPILE ELSE
--  'cmd /c 'WhichDvips' 'dvipsopts' 'opts' 'Master
  'cmd /c 'WhichDvips
COMPILE ENDIF
return Master


DEFC cstex_texit_and_dvips
parse arg action opts
if action='S' then 
COMPILE IF CSTEX_CSTEX=1
  WhichDvips='csdvips 'pm_expansion('%m.dvi %optsdvips')
COMPILE ELSE
  WhichDvips='dvips 'pm_expansion('%optsdvips %m')
COMPILE ENDIF
'cstex_texit_background S 'WhichDvips
elseif action='I' then
	sayerror cstex_texit_and_dvips_inf
endif


DEFC cstex_dvips
parse arg action opts
if action='S' then call cstex_dvips(opts,0); beep(440,1)
elseif action='I' then sayerror cstex_dvips_inf
endif


DEFC cstex_dvips_pause
parse arg action opts
if action='S' then call cstex_dvips(opts,1); -- beep(440,1)
elseif action='I' then sayerror cstex_dvips_inf
endif


DEFC cstex_gvpm
parse arg action x
if action='S' then 
   Master=cstex_dvips('',0)
   if Master<>'' then 'start gvpm 'Master'.ps' endif
endif


DEFC cstex_psview
parse arg action x
if action='S' then Master=cstex_dvips('',0); 
   if Master<>'' then 'pm_command_cmd S psview.cmd %M.ps' endif
   endif


DEFC cstex_about
InfoBox('This is pmCSTeX for EPM','Version 16. 4. 2000'\13\13'Developed by Petr Mikulk'\13\13'  Dept. of Solid State Physics, and'\13'  Lab. Thin Films & Nanostructures'\13'  Masaryk University'\13'  Brno, Czech Republic'\13\13'pmCSTeX for EPM resides at http://www.sci.muni.cz/~mikulik/os2/')


DEFC cstex_view_pmCSTeXINF
-- Note: this routine works if the EPM has been compiled with WANT_SEARCH_PATH
s=search_path(get_env('EPMPATH'),'pmCSTeX.INF')
'start view 's'pmCSTeX.INF'


DEFC cstex_viewINF
-- if "view LaTeX2e.INF" works from the command line, then this one works too:
parse arg action x
if action='S' then 'start view 'x
endif


DEFC cstex_bugs
WinMessageBox('This is pmCSTeX for EPM','Please address your bug reports, suggestions, comments, congratulations, improvements and solutions by e-mail to the author: mikulik@physics.muni.cz',MB_OK + MB_MOVEABLE +MB_ERROR)


DEFC cstex_next_error
  universal cstex_error_array_id, cstex_error_index, cstex_errorarray_name,
	    cstex_last_error_pos, cstex_no_more_errors, cstex_reLaTeXed
parse arg action x
if action='S' then
-- 17.1.1998: enhanced for this Warning search
if cstex_on_log_warning() then return; endif
getfileid W
COMPILE IF CSTEX_USEMASTERDIR=1  -- 4.1.1997
LogName=pm_expansion('%M.log')
COMPILE ELSE
LogName=pm_expansion('%m.log')
COMPILE ENDIF
getfileid Lid, LogName
if ((cstex_reLaTeXed<>0) or (cstex_no_more_errors=1)) and (Lid<>'') then 
i='Y'; /* 15.5.1996: taking this annoying question away
    if (cstex_reLaTeXed<>0)
	then line='I think your document has been reLaTeXed. Reload .log from disk?'
	else line='There are no more errors in the current .log file. Refresh it from disk?'
	endif
    i=AskYesNo(line);
*/
    if i='Y' then 
	activatefile Lid; .modify=0; 'xcom quit'; Lid=''; endif
    endif
cstex_reLaTeXed = 0
if Lid='' -- .log is not in ring
  then if EXIST(LogName)=0 then ErrorBox('Error',LogName' does not exist'); return; endif
	'xcom edit 'LogName; top
	-- delete error list if it exists
	if cstex_error_index>0 
	  then while (cstex_error_index>1) do
		  do_array 4, cstex_error_array_id, cstex_error_index
		  cstex_error_index=cstex_error_index-1
		  endwhile
	  else if cstex_error_index<0 then -- create error list
		  do_array 1, cstex_error_array_id, cstex_errorarray_name
		  cstex_error_index=0
		  endif
	  endif
  else	activatefile Lid 
	if (cstex_last_error_pos<>'') then 
	  prestore_pos(cstex_last_error_pos)
	  line='x'
	  -- debugbox('start line='line' lasterrorpos='cstex_last_error_pos)
	  while (.line<.last) and (words(line)>0) do
		.line=.line+1
		getline line
		endwhile
	  endif

	-- .line=.line+1
  /* --This code would look whether the .log file has changed:
      --  but it would require disk access... choose as you want
    psave_pos(p); bot; getline lastline; top; getline firstline
    .modify=0; quitfile(); activatefile W
    'xcom edit 'LogName
    top; getline line;	-- look at first and last line whether the file hasn't been changed
    if line=firstline then
      bot; getline line; top
      if line=lastline then prestore_pos(p); endif  -- restore position of the last error
      endif
  */
  endif

linenumber=.line
while (linenumber<.last) do
   getline line,linenumber
   -- skip "Underfull " and "Overfull " lines until "[]"  (14.12.1998)
   if leftstr(line,10)='Underfull ' or leftstr(line,9)='Overfull ' then
	do forever
	  -- InfoBox('ignoring line',line)
	  if rightstr(line,2)='[]' then -- ending string [] found
		linenumber=linenumber+1
		leave; endif
	  linenumber=linenumber+1; getline line,linenumber
	  if linenumber>=.last-1 then
		.line=.last
		ErrorBox('Error','Very bad things detected in .log file... missing ending []')
		return; endif
	enddo
	iterate
	endif
   -- skip block beginning "LaTeX Warning:" until a blank line  (14.12.1998)
   if leftstr(line,14)='LaTeX Warning:' then
	do forever
	  linenumber=linenumber+1; getline line,linenumber
	  if words(line)=0 then leave; endif
	enddo
	iterate
	endif
   -- line starting with '!' means brief description of the error
   if leftstr(line,1)='!' then
     cstex_no_more_errors=0
     parse value line with '!' error
     do forever 
       -- begin of new after ?
       linenumber=linenumber+1; getline line,linenumber
       if leftstr(line,2)='l.' then leave; endif
       if linenumber>=.last-1 then
	 .line=.last
	 ErrorBox('Error','Very bad things detected in .log file... (do {} match in your .tex?)')
	 return
	 endif
       -- end of new after ?
       /*
       -- begin of the first year version
       linenumber=linenumber+1; getline line,linenumber;
       if leftstr(line,2)='l.' then leave; endif
       -- end of the first year version
       */
     enddo
     .line=linenumber
     parse value line with 'l.'wrongline what
     if words(what)>0 then what=': 'what; endif
     if cstex_error_index<1 then ErrorBox('Fatal error',LogName' seems to be corrupted [or my algorithm is wrong]: () do not match'); return; endif
     psave_pos(cstex_last_error_pos)
     -- debugbox('SAVE lasterrorpos='cstex_last_error_pos)
     do_array 3, cstex_error_array_id, cstex_error_index, line
     line=translate(line,'\','/') -- convert from unix format
     if pos('\',line)=0 then 
	/* The line below up to 11.11.1997:
	if already_in_ring(line,n) then -- Kroni: EPM always finds files which are already loaded
	Now writing that explicitly; users recompiling whole EPM without E3EMUL support
	switched on had problems.
	*/
	getfileid n, line
	if n<>'' then
	  line=n.filename
	else  -- EPM requires full spec.
	  COMPILE IF CSTEX_USEMASTERDIR=1  -- 4.1.1997
	  line=pm_expansion('%d\'line)
	  COMPILE ELSE
	  line=directory()'\'line
	  COMPILE ENDIF
	  endif
	endif
     getfileid Wid,line
     -- DebugBox('File with errors seems to be *'line'* with Wid='Wid' on wrongline='wrongline) 
     if Wid='' 
	then 'xcom edit 'line; getfileid Wid --; refresh; activatefile Wid; InfoBox('wait','not edited yet!') 
	else activatefile Wid
	endif
     top
     activatefile Wid
     sayerror 'TeX error: 'error
     if wrongline>.last 
	then ErrorBox('Fatal error','Log file out of date: cannot find file 'line' or a specified line searched in it.')
	else
	.line=wrongline; .col=1 -- place cursor on the error
	i=words(what)
	if i>0 then
	  /* before 28.5.1996
	    i=wordindex(what,i); j=length(what)
	    .col=j
	    circleit 2,wrongline,i,length(what),1
	  */
	what=substr(what,3,length(what)-2) -- delete ': '
	if (substr(what,1,3)='...') 
	  then	what=substr(what,4,length(what)-3))
		getline line
		i=pos(what,line); j=i+length(what)
	  else	i=1; j=length(what)
	  endif
	.col=i
	circleit 4,wrongline,i,j,13,13  -- 30.1.1997+1.2.1997
	-- circleit 2,wrongline,i,j,1
	  -- the same problem as in EPMTEX: ovals are not resistant for the first time
     -- WHY DOES IT SOMETIMES GO BACK TO .LOG FILE INSTEAD OF STAYING HERE ????!!!!
     -- 'xcom edit '.filename
     -- debugbox('I AM HERE'.filename)
     -- activatefile Wid
	return
	endif
     return
     endif -- line with !
   -- count parentheses and change the list accordingly
   lz=pos('(',line); pz=pos(')',line); l=length(line)
   while (lz<>0) or (pz<>0) do
     if (lz=0) or ((pz<lz) and (pz>0))
      then -- remove the last word from the list
	if cstex_error_index<1 then ErrorBox('Fatal error','Log file corrupted: () do not match, index='cstex_error_index); return; endif
	do_array 3, cstex_error_array_id, cstex_error_index, x
	do_array 4, cstex_error_array_id, cstex_error_index
	cstex_error_index=cstex_error_index-1
	pz=pos(')',line,pz+1)
      else
	i=verify(line,' )'\9'','M',lz+1)
	if (i=pz) and (i>0)
	  then lz=pos('(',line,pz+1); pz=pos(')',line,pz+1)
	  else
	    nextlz=pos('(',line,lz+1)
	    if ((pz<nextlz) and (pz>0)) or ((pz>0) and (nextlz=0)) then pz=pos(')',line,pz+1); lz=nextlz  --(
	    else
	    if i=0 then i=l; else i=i-1; endif -- last position
	    cstex_error_index=cstex_error_index+1 -- add this word to the list
	    theword=substr(line,lz+1,i-lz)
	    do_array 2, cstex_error_array_id, cstex_error_index, theword
	    lz=nextlz
	    endif
	  endif
      endif
   endwhile
   linenumber=linenumber+1
   endwhile
-- calculate Warning:
.line=1; i=0;
while .line<.last do
  getline line; if pos('Warning:',line)>0 then i=i+1; endif; .line=.line+1; endwhile
-- get last line
getline line;
if i>0 then line='Warnings: 'i\13\13''line; endif
activatefile W
sayerror ' ' -- sometimes it gives `invalid fileid', strange
InfoBox('Congratulation!','No (more) errors.'\13''line) -- \13'Refresh from disk?'
cstex_no_more_errors=1
elseif action='I' then sayerror cstex_next_error_inf
endif
return


-- written 17. 1. 1998
defproc cstex_on_log_warning
if (not wordpos(filetype(), 'LOG') ) then
	return false  -- leave without the result
	endif
getline line,.line
-- to parse:
-- 	% Overfull \hbox (19.0473pt too wide) detected at line 5
--	Underfull \hbox (badness 10000) in paragraph at lines 356--373
--	LaTeX ...whatever.... line 138.
if pos('Overfull \hbox',line)<>1 and pos('Underfull \hbox',line)<>1 and
	word(line,1)<>'LaTeX' then
	return false -- leave without the result
	endif
-- what cannot be parsed:
--   XXXXfull \vbox ...
if word(line,2)='\vbox' then
	InfoBox('Sorry','\vbox-es cannot be localized (no line number info)')
	return true
	endif
k=1 -- warning can be split into several lines
if word(line,1)='LaTeX' 
  then -- LaTeX warning is ended by '.'
	line2=line
	while substr(line2,length(line2),1)<>'.' do
	  getline line2,.line+k
	  line=line''line2; k=k+1
	endwhile
  else -- other warnings are ended by an empty line
	loop 
	  getline line2,.line+k
	  if words(line2)=0 then leave; endif
	  line=line''line2; k=k+1
	endloop
  endif
sayerror line
-- get line numbers as the last word of the current line
line=word(line,words(line))
parse value line with atline1 '--' atline2	-- line number is  5  or  356--373
if substr(atline1,length(atline1))='.' then	-- line number is  138.
	atline1=substr(atline1,1,length(atline1)-1) endif
if not isnum(atline1) or atline1<=0 then -- cannot get the line number
	ErrorBox('Sorry','I cannot get the line numbers. Either wrong .log file or unknown line structure.')
	return true
	endif
if not isnum(atline2) or atline2<atline1
  then atline2=atline1; endif
-- InfoBox("lines to be circled",'line1='atline1'   line2='atline2)
getline errorline,.line -- remember the warning text
-- Now search the file where that warning occured. It's there as  (work.tex 
-- Thus find the first unbalanced (
nlz=1 -- counter of left parenthneses (. We found the file when this is zero
linenumber=.line-1
while (linenumber>0) do
  getline line,linenumber
  lz=lastpos('(',line); pz=lastpos(')',line)
  while (lz>0) or (pz>0) do
    -- iterate over all parenthesis ( and ) on the given line---from right-hand side
    if (pz>lz) then l=pz-1; nlz=nlz+1 -- found )
	else	nlz=nlz-1
		if nlz=0 then leave endif -- found it => leave this loop now!
		l=lz-1
	endif
    if l<=0 then leave endif
    -- search continues
    lz=lastpos('(',line,l); pz=lastpos(')',line,l)
    endwhile -- iteration over ()
  if nlz=0 then leave endif -- found it => leave this loop now!
  linenumber=linenumber-1
  endwhile -- iteration over the upper lines of the log file
if nlz<>0 then -- sth. wrong happened, top file reached, no result
	sayerror('Mistake location was not found, sorry')
	return true
	endif
sayerror errorline -- display the text of the problem
line=word(substr(line,lz+1),1) -- that's the file with full path
line=translate(line,'\','/') -- convert from unix format
-- InfoBox('Result---file to be opened:',line) -- write the result
getfileid Wid,line
if Wid='' 
  then 'xcom edit 'line; getfileid Wid,line
  endif
activatefile Wid
Wid.line=atline1
getline line,atline1
-- we circle only the upper line even though we have remember the lower one too
circleit 4,atline1,1,length(line),13,13
return true




DEFC cstex_paragraph
  universal pm4epm_MasterNotFound
/* Algorithn: Open master file. Copy everything till \begin{document}. Close it.
Localize the paragraph in the current file. Copy it. Append \end{document}.
Run LaTeX over this temporary file. Copy its .dvi to master.dvi. Copy its .log to
master.log */
parse arg action x
if action='S' then 
-- are we Master or Working file?
s=pm_expansion('%.M')
if pm4epm_MasterNotFound=1 then return; endif
if translate(s)=translate(.filename) then WeAreMaster=1; else WeAreMaster=0; endif
localdir=pm_expansion('%d')
psave_pos(Wpos)
getfileid W
CloseMaster=0
l4=.line -- line with cursor, it determines the paragraph
if WeAreMaster=0
  then
     getfileid Mid, s
     if Mid='' then CloseMaster=1; 'edit 's; getfileid Mid
	else activatefile Mid; endif
  else Mid=W
  endif
top; 'xcom L \begin{document}' -- search string
-- people without \begin{document} will have troubles. Their problem, sorry
l2=.line -- line with \begin{document}
-- now get the first (l3) and the last (l4) line of the paragraph
if marktype()='LINE' -- get the 'paragraph' from the line mark
then getmark l3,l4
	if WeAreMaster<>0 then
	  if (l2>=l3) then l3=l2+1; endif
	  if (l2>=l4) then l4=l2+1; endif
	  endif
else -- get the paragraph as the 'true paragraph' separated by blank lines
if WeAreMaster=1 -- first line of the current paragraph
   then if (l4<=l2) then l4=l2+1 endif; stopit=l2+1;
   else stopit=1;
   endif
l3=l4
getline s, l4, W
while (l3>stopit) and (words(s)>0) do l3=l3-1; getline s,l3,W; endwhile
getline s,W.line,W -- last line of the current paragraph
while (l4<W.last) and (words(s)>0) do l4=l4+1; getline s,l4,W; endwhile
endif -- of getting the paragraph
'EDIT 'localdir'\$$cstex$.tex' -- avoid existence of $cstex$.tex file
'NAME 'localdir'\$cstex$.tex'  -- rename it. Note: we process it in the Master's directory
getfileid P
for i=1 to l2
  getline s,i,Mid
  insertline s,.last
  endfor
if CloseMaster=1 then activatefile Mid; quitfile(); activatefile P; endif
for i=l3 to l4
  getline s,i,W
  insertline s,.last
  endfor
insertline '\end{document}',.last
'FILE'  -- save and quit
sayerror 'TeXing paragraph...'
activatefile W
prestore_pos(Wpos)
e=get_env('EMTEXOPT')
if (words(e)>0) then e=e' ' endif -- cool tricks, hot stuff, 17.5.1996
e=e''pm_expansion('%optsemtex')
if (words(e)<>0) then e=e' /b'; else e='/b'; endif -- /batchmode
/* Up to 11.11.1997: single very long command. This was causing EPM crashes when
  invoked from very deep directory (EPM string length limitation).
e='(set EMTEXOPT='e') & '
'pm_command_pm S /c/b/min cmd.exe /c "'e'(%h&cd %d)&(%format.cmd $cstex$.tex)&(if exist %m.dvi del %m.dvi)&(ren $cstex$.dvi %m.dvi)&(if exist %m.log del %m.log)&(ren $cstex$.log %m.log)&(del $cstex$.*>nul)"'
*/
-- New version: making $cstex$.cmd in the Master's directory. Thus cmd.exe is invoked only once.
theh=pm_expansion('%h')
them=pm_expansion('%m'); thed=pm_expansion('%d')
thef=pm_expansion('%format')
'EDIT 'localdir'\$$cstex$.cmd' -- avoid existence of $cstex$.cmd file
'NAME 'localdir'\$cstex$.cmd'  -- rename it
insertline '@echo off'
insertline 'rem Produced by pmCSTeX for EPM. Allows (La)TeXing a paragraph.'
insertline 'set EMTEXOPT='e
insertline theh
insertline 'cd 'thed
insertline 'call 'thef'.cmd $cstex$.tex'
insertline 'if exist 'them'.dvi del 'them'.dvi'
insertline 'ren $cstex$.dvi 'them'.dvi'
insertline 'if exist 'them'.log del 'them'.log'
insertline 'ren $cstex$.log 'them'.log'
insertline 'del $cstex$.*>nul'
sayerror 0
'FILE'  -- save and quit
sayerror 'TeXing paragraph...'
activatefile W
prestore_pos(Wpos)
'start /c/b/min cmd.exe /c 'localdir'\$cstex$.cmd'
sayerror 0
return
elseif action='I' then sayerror cstex_paragraph_inf
endif


DEFC cstex_master
  universal pm4epm_MasterNotFound
parse arg action
if action='S' then
Master=pm_expansion('%.M')
if pm4epm_MasterNotFound=1 then return; endif
'xcom edit ' Master
sayerror 'This is master'
elseif action='I' then sayerror cstex_master_inf
endif



DEFPROC cstex_WhereExists ( Name )
s=pm_expansion('%d\'Name); -- look at Master's directory
if EXIST(s)<>0 then return s; endif
if EXIST(Name)<>0 then return Name; endif  -- look at current directory
updir=pm_expansion('%d'); -- look at Master's directory
i=lastpos('\',updir); updir=substr(updir,1,i-1);
s=updir'\units\'Name  -- there could be my .h files
if EXIST(s)<>0 then return s; endif
updir=directory(); /* current directory */ i=lastpos('\',updir); updir=substr(updir,1,i-1); 
s=updir'\units\'Name  -- there could be my .h files
if EXIST(s)<>0 then return s; endif
s='\emtex\texinput\'Name  -- there could be my .tex or .sty files
if EXIST(s)<>0 then return s; endif
s='\emx\include\'Name  -- look for GNU C/C++ files
if EXIST(s)<>0 then return s; endif
s='\emx\include\cpp\'Name  -- look for GNU C/C++ files
if EXIST(s)<>0 then return s; endif
s='\emx\include\sys\'Name  -- look for GNU C/C++ files
if EXIST(s)<>0 then return s; endif
s='\emx\include\cpp\gen\'Name  -- look for GNU C/C++ files
if EXIST(s)<>0 then return s; endif
return '' -- not found


-- the following routine withdraws the file name under cursor and (re)loads it
DEFC cstex_include
parse arg action line
if action='S' then
getline line
k=words(line)
if (k=0) or (.col>wordindex(line,k)+length(word(line,k))-1) then Beep(440,222); return; endif
i=2 -- find the word the char is in
while (i<=k) and (.col>=wordindex(line,i)) do i=i+1; endwhile --first word above cursor
i=i-1; if (i<k) and (.col>wordindex(line,i)+length(word(line,i))-1) then Beep(440,222); return; endif
--i=i-1; if i>k then i=k; elseif i<1 then i=1; endif
c=.col-wordindex(line,i)+1; line=word(line,i)
l=length(line);
-- chars that can appear in file name (English)
-- CharsInName='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@._$-\\:/'
-- chars that can appear in file name (codepage 852):
CharsInName='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@._$-젡֐\\:/'
Name=''
if c>1 then -- from cursor-1 to left
    Name=reverse(substr(line,1,c-1))
    k=verify(Name,CharsInName)
    if k=0 then Name=substr(line,1,c-1)
	    else Name=substr(line,c-k+1,k-1)
	    endif
  endif
k=verify(line,CharsInName,'N',c)  -- from cursor to right
if k=0 then Name=Name''substr(line,c,l-c+1)
  else Name=Name''substr(line,c,k-c)
  endif
-- the following routine tries to load Name to editor
Name=translate(Name,'\','/') -- convert from unix format
if words(Name)=0 then Beep(440,220); return; endif
getfileid Lid, Name -- is that file in ring?
if Lid<>'' then activatefile(Lid); return; endif
if EXIST(Name)<>0 then 'edit 'Name; return; endif
-- so look at some directories. List your favourite ones here:
if substr(Name,1,1)='\\' then Name=substr(Name,2,length(Name)-1); endif
s=pm_expansion('%d\'Name);
--TODO!		InfoBox('Helo s=','**'s'**') --PM1906
s=directory()'\'Name; 
--TODO!		InfoBox('Helo name=','**'Name'**') --PM1906
s=cstex_WhereExists(Name)
if s='' then s=cstex_WhereExists(Name'.h') 
  if s='' then s=cstex_WhereExists(Name'.cpp') 
  if s='' then s=cstex_WhereExists(Name'.cxx') 
  if s='' then s=cstex_WhereExists(Name'.sty') 
  if s='' then s=cstex_WhereExists(Name'.tex') 
  if s='' then s=cstex_WhereExists(Name'.dtx') 
  if s='' then s=cstex_WhereExists(Name'.pas') 
  if s='' then s=cstex_WhereExists(Name'.txt') 
  if s='' then s=cstex_WhereExists(Name'.doc') 
endif endif endif endif endif endif endif endif endif
/*  -- this is old, explicit version
if EXIST(s)=0 then s=pm_expansion('%d\'Name); -- look at Master's directory
if EXIST(s)=0 then
updir=directory(); i=lastpos('\',updir); updir=substr(updir,1,i-1);
s=updir'\units\'Name  -- there could be my .h files
if EXIST(s)=0 then s='\emtex\texinput\'Name  -- there could be my .tex or .sty files
if EXIST(s)=0 then s='\emx\include\'Name  -- look for GNU C/C++ files
if EXIST(s)=0 then s='\emx\include\cpp\'Name  -- look for GNU C/C++ files
if EXIST(s)=0 then s='\emx\include\sys\'Name  -- look for GNU C/C++ files
if EXIST(s)=0 then s='\emx\include\cpp\gen\'Name  -- look for GNU C/C++ files
endif endif endif endif endif endif endif
*/
-- now open it if exists
getfileid Lid, s -- is that file in ring?
if Lid<>'' then activatefile(Lid); return; endif
if EXIST(s)<>0
  then 'edit 's; 
  else ErrorBox('Sorry','File 'Name' not found.'\13\13'You can try to edit CSTeX.e, routines cstex_WhereExists and cstex_include, to supply your favourite paths and extensions.')
  endif
elseif action='I' then sayerror cstex_include_inf
endif


/* Cykl is obsolete now
DEFC cstex_cykl
  universal pm4epm_MasterNotFound
parse arg action
if action='S' then
-- 'pm_command_cmd S cykl! %.W call %format.cmd %.N'
x=pm_expansion('%.W call %format.cmd %.N')
if pm4epm_MasterNotFound=1 then return; endif
'pm_command_cmd S cykl! 'x
endif
*/


DEFPROC RefreshCurrentFile ()
--ct = windowmessage(1,  getpminfo(EPMINFO_EDITFRAME),
--	 5505,		-- EPM_EDIT_KW_QUERYPARSE
--	 0,0)  -- returns 0 / 1 if syntax highl. off/on
-- InfoBox('myinfo','Keyword parsing is' ct)
psave_pos(x); .modify=0
'xcom edit /d '.filename
getfileid fid
prevfile; 'xcom quit'
activatefile fid; prestore_pos(x)
return


DEFC cstex_refresh
parse arg action
if action='S' then
x=AskYesNo( 'Refresh current file' .filename' ?')
if x<>'Y' then return; endif
RefreshCurrentFile()
elseif action='I' then sayerror cstex_refresh_inf
endif


DEFC cstex_highlight_all
parse arg action
if action='S' then
n=filesinring()
for i=1 to n
  nextfile	    -- 23.1.1997: nextfile + toggle is works, otherwise badly.
  'a_togl_hilit S'  -- It seems that 'a_togl_hilit S' is multi-threaded, so up
  endfor	    -- to now the last nextfile was not executed.
sayerror ' '
elseif action='I' then sayerror cstex_highlight_all_inf
endif


DEFC cstex_save_all
parse arg action x
if action = 'S' then
  sayerror ''
  call save_the_ring()
elseif action='I' then sayerror cstex_save_all_inf
endif


COMPILE IF CSTEX_CSTEX=1

COMPILE IF CSTEX_CS2CS=1
DEFC CStoCS
-- CS2CS using OS/2 program
w=.filename -- pm_expansion('%.W') -- 4.1.1997
'save 'w  -- save
CP='*CP852        (PC Latin II - CP 852)*KEYBCS2     (podle Kamenickych)*CP850        (PC Latin I - CP 850)*IBM852      (Latin II - IBM 852)*ISO-8859-1  (ISO-8859-1 Latin 1)*ISO-8859-2  (ISO-8859-2 Latin 2)*TEX1         (TeX, \v{C})*TEX2         (TeX, \v C)*CORKY        (podle Corky)*CP1250       (MS-Windows - CP 1250)*KOI8-CS      (KOI8-CS)*MAC          (Macintosh)*'
iCP='*autodetect'CP
iCP=listbox('Input encoding',iCP,,20,22,13,45)  -- pos1,pos2,height,width
if iCP='' then return; endif
iCP=word(iCP,1)
CP=CP'ASCII        (bez diakritiky)'
CP=listbox('Output encoding',CP,,20,22,13,45)  -- pos1,pos2,height,width
if CP='' then return; endif
CP=word(CP,1)
if (iCP='autodetect') 
  then 'cs2cs -s 'w' -o'CP' -w';
  else 'cs2cs -s 'w' -i'iCP' -o'CP' -w'; endif
RefreshCurrentFile()
return

COMPILE ELSE

DEFPROC CS1toCS2 ( From, ToTo )
-- CStoCS using DOS program
w=.filename -- pm_expansion('%.W') -- 4.1.1997
'save 'w  -- save
-- 'start /win /c /dos cstocs -'From' 'w' -'ToTo' 'w
-- or: 'pm_command_dos S cstocs -'From' 'w' -'ToTo' 'w
getfileid fid
'edit $.Untitled$'
.filename='$cstex$.bat'
s=get_env('EMTEXDIR')'\cstocs.exe'
if EXIST(s) <> 0
  then insertline s' -'From' 'w' -'ToTo' 'w
  else insertline 'cstocs -'From' 'w' -'ToTo' 'w
  endif
insertline 'pause'
'FILE'
sayerror ''
'start /c /win /dos /f $cstex$.bat'
activatefile fid
PleaseRelax()
'start /c /b cmd /c del $cstex$.bat'
RefreshCurrentFile()
return
DEFC CStoCS
parse arg action From ToTo
if action='S' then
  CS1toCS2(From,ToTo)
  endif

COMPILE ENDIF


/* obsolete: using the DOS version vlnka.exe:
DEFC Vlnkax
parse arg action
if action='S' then
w=.filename -- pm_expansion('%.W') -- 4.1.1997
'save 'w
s=get_env('EMTEXDIR')'\vlnka.exe'
if EXIST(s) <> 0
  then 'start /win /c /dos 's' 'w' KkOoUuVvSsZzAI'
  else 'start /win /c /dos vlnka 'w' KkOoUuVvSsZzAI'
  endif
-- or: 'pm_command_dos S vlnka 'w' KkOoUuVvSsZzAI'
--'os2 (cmd /c vlnka 'w' KkOoUuVvSsZzAI) & exit'
PleaseRelax()
RefreshCurrentFile()
endif
*/


/*
-- Obsolete: now using the OS/2 version vlnka2.exe:
DEFC Vlnkax
parse arg action
if action='S' then
w=.filename -- pm_expansion('%.W') -- 4.1.1997
'save 'w
s=get_env('EMTEXDIR')'\vlnka2.exe'
if EXIST(s) <> 0
  then s' 'w' KkOoUuVvSsZzAI'
  else 'vlnka2 'w' KkOoUuVvSsZzAI'
  endif
RefreshCurrentFile()
endif
*/


-- now using the OS/2 version of vlna.exe (2. 4. 2000):
DEFC Vlnkax
parse arg action
if action='S' then
w=.filename -- pm_expansion('%.W') -- 4.1.1997
'save 'w
s=get_env('EMTEXDIR')'\vlna.exe'
if EXIST(s) <> 0
  then s' -l 'w
  else 'vlna -l 'w
  endif
RefreshCurrentFile()
endif


DEFC csTeXspell
parse arg action dict
if action='S' then
w=.filename -- pm_expansion('%.W') -- 4.1.1997
'save 'w
s=get_env('EMTEXDIR')'\cstug\texspell.exe'
if EXIST(s) = 0 then ErrorBox('Error','Program 's' not found.'); return; endif
'start /win /c /dos 's' 'w' @L ='dict
PleaseRelax()
RefreshCurrentFile()
endif
COMPILE ENDIF


DEFC cstex_dviout2
parse arg action param
if action='S' then
if (param<>'') then param=param' ' endif
'pm_command_os2 S cmd /c "%h & (cd %d) & (dvi-out2 'param'%M.dvi) & pause"'
endif


DEFC worldBibTeXx
parse arg action
if action='S' then
'pm_command_os2 S cmd /c "%h & (cd %d) & 'worldbibtex' %M & pause"'
endif


DEFC csBibTeXx
parse arg action
if action='S' then
--'pm_command_os2 S 'csbibtex' /p /and %M'
--'pm_command_os2fs S cmd /c "'csbibtex' /p /and %M & pause"'
--'pm_command_os2 S 'csbibtex' /f=$(EMTEXDIR)\data\csbibtex\pclatin2.alp /and %M'
COMPILE IF CSTEX_USEMASTERDIR=1  -- 4.1.1997
'pm_command_os2 S cmd /c "%h & (cd %d) & 'csbibtex' /p /and %M & pause"'
COMPILE ELSE
'pm_command_os2 S cmd /c "'csbibtex' /p /and %M & pause"'
COMPILE ENDIF
endif


DEFC DoMakeindex
parse arg action
if action='S' then
'pm_command_cmd S "%h & (cd %d) & 'worldindex' %optsmakeindex %M & pause"'
endif

DEFC DoCsMakeindex
parse arg action
if action='S' then
-- Sorry, but DOS does not support:
-- 'pm_command_dos S "%h & (cd %d) & 'csindex' -z latin2 %optsmakeindex %M & pause"'
'pm_command_dos S 'csindex' -z latin2 %optsmakeindex %M'
endif


DEFC cstex_texclean
COMPILE IF CSTEX_USEMASTERDIR -- 4.1.1997
'start /c /win cmd /c "'pm_expansion('%h & (cd %d)')' & for %i in (*.aux *.log *.dlg *.dvi *.toc *.lot *.lof *.blg *.idx *.ind *.glo *.gls *.hp *.mfj *.pri *.bak *~ *.lj *.dj *.fx *.ljh *.djh) do del %i >nul 2>nul"'
COMPILE ELSE
'start /c /win cmd /c "for %i in (*.aux *.log *.dlg *.dvi *.toc *.lot *.lof *.blg *.idx *.ind *.glo *.gls *.hp *.mfj *.pri *.bak *~ *.lj *.dj *.fx *.ljh *.djh) do del %i >nul 2>nul"'
COMPILE ENDIF


DEFC cstex_printmy
parse arg action myprt outfile
COMPILE IF CSTEX_USEMASTERDIR -- 4.1.1997
if action='S' then 'pm_command_cmd S "%h & (cd %d) & 'myprt' // %viewopts %M 'outfile'"'
COMPILE ELSE
if action='S' then 'pm_command_cmd S 'myprt' // %viewopts %M 'outfile
COMPILE ENDIF
endif


DEFC cstex_printpm
parse arg action cnf
COMPILE IF CSTEX_USEMASTERDIR -- 4.1.1997
if action='S' then 'pm_command_cmd S "%h & (cd %d) & dvipm.exe @'cnf'.cnf // %viewopts %M"'
COMPILE ELSE
if action='S' then 'pm_command_pm S dvipm.exe @'cnf'.cnf // %viewopts %M'
COMPILE ENDIF
endif


DEFC cstex_printfs
parse arg action cnf
COMPILE IF CSTEX_USEMASTERDIR -- 4.1.1997
if action='S' then 'pm_command_os2fs S "cmd /c ""%h & (cd %d) & dviscr7.exe @'cnf'.cnf // %viewopts %M"""'
COMPILE ELSE
if action='S' then 'pm_command_os2fs S dviscr7.exe @'cnf'.cnf // %viewopts %M'
COMPILE ENDIF
endif


DEFPROC cstex_print ( hpljcnf, outfile )
COMPILE IF CSTEX_USEMASTERDIR -- 4.1.1997
'pm_command_cmd S "%h & (cd %d) & dvi'hpljcnf'.cnf // %viewopts %M 'outfile'"'
COMPILE ELSE
'pm_command_os2 S dvi'hpljcnf'.cnf // %viewopts %M 'outfile
COMPILE ENDIF
DEFC cstex_print
parse arg action args
if action='S' then cstex_print(args,'prn')
endif
DEFC cstex_printfile
parse arg action args
if action='S' then cstex_print(args,'%M.pri')
endif


COMPILE IF PM_DICTIONARIES=1

DEFC pm_change_dictionary
   universal  ADDENDA_FILENAME
   universal  DICTIONARY_FILENAME
parse arg action which
if action='S' then
e=get_env('EPM_DICTIONARIES')
if (e='') then e='\apps\epm\';
	 else if (substr(e,length(e),1)<>'\') then e=e'\' endif
	 endif
dic=e''which'.dic'
if not(EXIST(dic)) then 
  ErrorBox('Sorry---Error','Cannot find file 'dic'. Please copy the dictionary 'which'.dic into the directory specified by EPM_DICTIONARIES.'); return; endif
DICTIONARY_FILENAME=dic
dic=e''which'.adl'
if not(EXIST(dic)) then 
  InfoBox('Warning','Cannot find file 'dic'. This is your personal dictionary, thus maybe this does not exist yet ('which'.adl should be in the directory specified by EPM_DICTIONARIES).'); endif
ADDENDA_FILENAME=dic
endif
COMPILE ENDIF


/*************************** BUILD CSTEX MENU *********************/

DEFC BuildCSTeXMenu
   universal  defaultmenu,
	      app_hini
		,DICTIONARY_FILENAME

defaultmenu = 'default'

-- Note for accelkeys: 'cstex_texit'1\'Preview Document'\9'Sh+F11'


idcount = 6940 -- start value of counter of ids
cstexid = 1969 -- registration id of the CSTeX menu

/*
Cykl is obsolete now
cstex_cykl_inf = '(La)TeX forever on the master file when working file changed'
*/

id=idcount  --	Note: center hotkeys right: 'Texujx'\9'Sh+F12'
buildsubmenu defaultmenu, cstexid, 'CS~TeX', \1'Menu for (La)TeXing', 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, '(La)TeX document', 'cstex_texit S'\1''cstex_texit_inf, 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, '(La)TeX paragraph',  'cstex_paragraph S'\1''cstex_paragraph_inf, 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, '(La)TeX + dvips'\9'Ctrl+F11', 'cstex_texit_and_dvips S'\1''cstex_texit_and_dvips_inf, 0,0
/* Cykl is obsolete now
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Cykl! (La)TeX document', 'cstex_cykl S'\1''cstex_cykl_inf, 0,0
*/
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
id=id+1; buildmenuitem defaultmenu, cstexid, id, '(La)TeX document /b'\9'Shift+F11', 'cstex_texit_background S'\1''cstex_texit_background_inf, 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Locate ~Next Error'\9'Shift+F12', 'cstex_next_error S'\1''cstex_next_error_inf, 0,0
-- id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Reload .~log file',  'pm_expand S edit /d %M.log'\1'pm_expand S edit /d %M.log', 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~View document', 'cstex_preview S'\1''cstex_preview_inf, 0,0  
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Post~Script',  ' '\1'PostScript actions', 64+17,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~dvips-it',  'cstex_dvips S'\1'Run dvips', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'dvips + GhostV~iew',  'cstex_gvpm S'\1'Run dvips and then gvpm (GhostView for OS/2 PM)', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'dvips + psview',  'cstex_psview S'\1'Run dvips and then psview.cmd (ANSI "GhostView" for OS/2)', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'print from dvips',  'cstex_dvips S -o prn'\1'Run dvips, output to prn', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'dvips-it + pause',  'cstex_dvips_pause S'\1'Run dvips', 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'PM Preview before print', ' '\1'Preview document by dvipm with @_theprinter_.cnf and VIEWOPTS:',17+64,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 300 dpi', 'cstex_printpm S lj'\1'using @lj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 600 dpi', 'cstex_printpm S ljh'\1'using @ljh.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet 300 dpi', 'cstex_printpm S dj'\1'using @dj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet 600 dpi', 'cstex_printpm S djh'\1'using @djh.cnf', 0,0
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Stylus', 'cstex_printpm S sty'\1'using @sty.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Epson FX1050', 'cstex_printpm S fx1050'\1'using @fx1050.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt1', 'cstex_printpm S myprt1'\1"using user's @myprt1.cnf", 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt2', 'cstex_printpm S myprt2'\1"using user's @myprt2.cnf", 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'FS Preview before print', ' '\1'Preview document by dviscr with @_theprinter_.cnf and VIEWOPTS:',17+64,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 300 dpi', 'cstex_printfs S lj'\1'using @lj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 600 dpi', 'cstex_printfs S ljh'\1'using @ljh.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet 300 dpi', 'cstex_printfs S dj'\1'using @dj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet 600 dpi', 'cstex_printfs S djh'\1'using @djh.cnf', 0,0
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Stylus', 'cstex_printfs S sty'\1'using @sty.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Epson FX1050', 'cstex_printfs S dot7 fx1050'\1'using fx1050.cnf @fx1050.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt1', 'cstex_printfs S myprt1'\1"using user's @myprt1.cnf", 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt2', 'cstex_printfs S myprt2'\1"using user's @myprt2.cnf", 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Print document', ' '\1'Print the document',17+64,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 300 dpi', 'cstex_print S hplj @lj'\1'dvihplj @lj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 600 dpi', 'cstex_print S hplj @ljh'\1'dvihplj @ljh.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet 300 dpi', 'cstex_print S hplj @dj'\1'dvihplj @dj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet 600 dpi', 'cstex_print S hplj @dj'\1'dvihplj @djh.cnf', 0,0
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Stylus', 'cstex_print S dot sty.dot @sty'\1'dvidot sty.dot @sty.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Epson FX1050', 'cstex_print S dot7 fx1050.dot @fx100'\1'dvidot7 fx1050.dot @fx1050.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt1', 'cstex_printmy S myprt1'\1"using user's myprt1.cmd", 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt2', 'cstex_printmy S myprt2'\1"using user's myprt2.cmd", 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Print to ~file', ' '\1'Print document to file _Master_.pri',17+64,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 300 dpi', 'cstex_printfile S hplj @lj'\1'dvihplj @lj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP LJ 600 dpi', 'cstex_printfile S hplj @ljh'\1'dvihplj @ljh.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet 300 dpi', 'cstex_printfile S hplj @dj'\1'dvihplj @dj.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'HP DeskJet 600 dpi', 'cstex_printfile S hplj @djh'\1'dvihplj @djh.cnf', 0,0
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Stylus', 'cstex_printfile S dot sty.dot @sty'\1'dvidot sty.dot @sty.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Epson FX1050', 'cstex_printfile S dot7 fx1050.dot @fx100'\1'dvidot7 fx1050.dot @fx1050.cnf', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt1', 'cstex_printmy S myprt1 %M.pri'\1"using user's myprt1.cmd", 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'myprt2', 'cstex_printmy S myprt2 %M.pri'\1"using user's myprt2.cmd", 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
COMPILE IF CSTEX_CSTEX=1
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Tie (vlnka)',  'Vlnkax S'\1'Pidn vlnek za pedloky', 0,0
COMPILE IF CSTEX_CS2CS=1
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'CStoCS',  'CStoCS S'\1'Czech encodings conversion using program cs2cs.exe', 0, 0
COMPILE ELSE
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'CStoCS',  ' '\1'Czech encodings conversion using program cstocs.exe', 17+64, 0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Kamenit to PC-Latin 2', 'CStoCS S i1 o2', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'PC-Latin2 to Kamenit', 'CStoCS S i2 o1', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'ISO8859-Latin 2 to PC-Latin2', 'CStoCS S i3 o2', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'PC-Latin2 to ISO8859-Latin 2', 'CStoCS S i2 o3', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'PC-Latin2 to TeX sequencies', 'CStoCS S i2 o0', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'TeX sequencies to PC-Latin2', 'CStoCS S i0 o2', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Strip accents from PC-Latin2', 'CStoCS S i2 a', 32768+1,0
COMPILE ENDIF
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Spell (CSTUG)', ' '\1'DOS spell-checker, only for registered CSTUG members', 17+64, 0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Czech', 'csTeXspell S C', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Slovak', 'csTeXspell S S', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~English', 'csTeXspell S A', 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline  
COMPILE ENDIF
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Other TeX programs', ' '\1'Some additional programs', 17+64, 0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~BibTeX', 'worldBibTeXx S'\1''worldBibTeX' program', 0,0 
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Make~Index', 'pm_command_os2 S 'worldindex'  %M'\1''worldindex' program (make index of course)', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Make~Index', 'DoMakeindex S'\1''worldindex' program (make index of course)', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~TeXCAD', 'start /c /fs /dos command.com /c texcad'\1'TeXCAD drawing program', 0,0 
COMPILE IF CSTEX_CSTEX
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Qfig','start /c /fs /dos command.com /c qfig'\1'Qfig drawing program',0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline  
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'csBibTeX', 'csBibTeXx S'\1''csBibTeX' program', 0,0 
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'csMakeIndex', 'pm_command_dos S 'csindex' -z latin2 %M'\1''csIndex' program (index, rejstky)', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'csMakeIndex', 'DoCsMakeindex S'\1''csIndex' program (index, rejstky)', 0,0 
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'DVI-Out cs->cm', 'pm_command_dos S dvi-out %M'\1'Convert 8bit cs-fonts to 7bit cm-fonts', 0,0
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'DVI-Out cm->cs', 'pm_command_dos S dvi-out -m %M'\1'Convert 7bit cm-fonts to 8bit cs-fonts', 32768+1,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'DVI-Out cs->cm', 'cstex_dviout2 S'\1'Convert 8bit cs-fonts to 7bit cm-fonts', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'DVI-Out cm->cs', 'cstex_dviout2 S -m'\1'Convert 7bit cm-fonts to 8bit cs-fonts', 32768+1,0
COMPILE ELSE
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Qfig','start /c /fs /dos command.com /c qfig'\1'Qfig drawing program', 32768+1,0
COMPILE ENDIF
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Te~Xclean', 'cstex_texclean S'\1'Clean all garbage files', 0,0 
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Editor', ' '\1'EPM related commands', 17+64, 0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Master', 'cstex_master S'\1''cstex_master_inf, 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Include', 'cstex_include S'\1''cstex_include_inf, 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Refresh', 'cstex_refresh S'\1''cstex_refresh_inf, 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Save ~all', 'cstex_save_all S'\1''cstex_save_all_inf, 0,0 
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Syntax highlighting', '', 32768 +17+64, 0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Auto current file', 'a_togl_hilit S', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Auto a~ll files', 'cstex_highlight_all S'\1''cstex_highlight_all_inf, 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~C/C++ current file', 'toggle_parse 1 epmkwds.c', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~TeX current file', 'toggle_parse 1 epmkwds.tex', 32768+1,0 
COMPILE IF PM_DICTIONARIES=1
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'Spell~-checker', ' '\1'Change EPM spell-checker dictionary 'DICTIONARY_FILENAME, 17+64, 0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~francais', 'pm_change_dictionary S FR'\1'', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'U~K English', 'pm_change_dictionary S UK'\1'', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~deutsch', 'pm_change_dictionary S GR'\1'', 0,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'U~S English', 'pm_change_dictionary S US'\1'', 0,0 
--  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Italiano', 'pm_change_dictionary S IT'\1'', 32768+1,0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Espagnol', 'pm_change_dictionary S SP'\1'', 32768+1,0 
COMPILE ENDIF
id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline 
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~About pmCSTeX for EPM', 'cstex_about'\1'Info about the current version of pmCSTeX', 0,0
-- id=id+1; buildmenuitem defaultmenu, cstexid, id, 'View documentation', 'cstex_viewINF'\1'View the pmCSTeX.INF hypertext documentation', 0,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, 'View documentation', ' '\1'Browse the pmCSTeX.INF or LaTeX2e.INF hypertext documentation', 17+64, 0 
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'for pmCSTeX', 'cstex_view_pmCSTeXINF'\1'View pmCSTeX.INF', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline  
COMPILE IF CSTEX_CSTEX
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'for EPMpopisJK', 'cstex_viewINF S EPMpopisJK.INF'\1'View CzEpmCs.INF', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'for CzEpmCs', 'cstex_viewINF S CzEpmCs.INF'\1'View CzEpmCs.INF', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, \0, '', 4, 0 -- hline  
COMPILE ENDIF
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'for LaTeX2e', 'cstex_viewINF S LaTeX2e.INF'\1'View LaTeX2e.INF (reminder: Ctrl/H hotkey)', 0,0
  id=id+1; buildmenuitem defaultmenu, cstexid, id, 'for TeX-math', 'cstex_viewINF S TeX-Math.INF'\1'View TeX-Math.INF', 32768+1,0
id=id+1; buildmenuitem defaultmenu, cstexid, id, '~Bug reports', 'cstex_bugs'\1'Where to send you suggestions and bug reports', 0,0
showmenu 'default' 
return

/* end of CSTeX.e */
