/*
Uprava -- P. Mikulk:        //PM   <- tohle jsou me znacky
  - zapoznamkoval jsem Beepy //PM
  - pridal jsem univerzalni konstantu czech_is nesouci informaci //PM
    o aktualnich keys (potreboval jsem to pri prepinani recke klavesnice //PM
    a nevim, jestli jde aktualni nastaveni klaves nejak ulozit //PM

This is Czech.E 1.01 as of 27 Dec 1995 13:55:12 
Copyright (C) Z. Wagner -- Ice Bear Soft

This is the E-macro file supporting Czech and Slovak keyboard in EPM. It was developed and
tested with EPM 6.03, it is not sure whether it may work with other versions. No version 
check is made.

This file is provided AS IS without any warranty expressed or implied. Use it on your own 
risk.

The file is distributed in the hope that it can be useful for you.

You are allowed to use this and accompanying files on unlimited number of your 
computers. You are allowed to distribute this file provided you do not take money fo the 
distribution except of nominal charge for hadling, diskettes, postage, etc. and it is 
distributed together with all files mentioned in CzEpmCs.inf and EngEpmCs.inf, preferably 
as a single ZIP-file. You are allowed to modify the file for your own use. You are
allowed to distribute the modified versions provided the modifications are clearly marked
and any user can obtain the original file on demand. It is strongly suggested to use
"compile if" and/or "tryinclude" directives for modifications so that the original version
could easily be restored.

There is no official support for bug fixes. The author does not guarantee that the bugs 
will ever be corrected. However, the bug reports are invited and the author will correct 
problems bothering him. You can also send your modifications, some of them could become 
"standard" if the next version will ever be released.

Remember that this is only temporary non-system solution since it is easier to develop and
the national keyboard is most important in the editor and "relatively unimportant" in 
other applications.
*/

define CZversion = "1.01"
define WANT_CS_DEFAULT=0 -- Set to 1 if you want CS keyboard as default
define WANT_NUM_UPCASE=1 -- Set to 0 if you do not like CapsLock with nums
define dead_key="`" -- the dead key
define SWAP_ZY = 0  -- swaps ZY if set to 1
define WANT_GUESS_WORD = 1 -- Set to 0 if you do not like the Guess Word function
                           -- This function is invoked by Alt/=

tryinclude 'MyCzech.E' -- for your configuration

; Returns the version number
DEFPROC CzechVersion() =
return CZversion

DEFC CzechVersion = message('Czech.E Version' CzechVersion())

DEFKEYS czech_switch -- defines switch to the Czech/Slovak key set
def a_leftbracket = SwitchToCzech()
COMPILE IF WANT_GUESS_WORD
def a_equal = GuessWord()
COMPILE ENDIF

; The following procedure switches to the Czech/Slovak key set
DEFPROC SwitchToCzech() =
universal dead_cnt
universal czech_is; czech_is=1; -- //PM
dead_cnt = 0
keys czech_keys
;Beep(880, 300)

; The following procedure switches back
DEFPROC SwitchBack() =
universal dead_cnt
universal czech_is; czech_is=2; -- //PM
dead_cnt = 0
keys czech_switch

; Initialization
DEFINIT
COMPILE IF WANT_CS_DEFAULT
universal czech_is; czech_is=1; -- //PM
SwitchToCzech()
COMPILE ELSE
universal czech_is; czech_is=2; -- //PM
SwitchBack()
COMPILE ENDIF

; Constants for numbers
define KS_DOWNTOGGLE = 2
define KS_UPTOGGLE = 4
define VK_CAPSLOCK = 14

; The definitions for the Czech/Slovak key set
DEFKEYS czech_keys
def a_rightbracket = SwitchBack()
;                     Beep(440, 450)
def '0'-'9' = CzechNum()
def space = CzechSpace()
def \33-\47, \58-\126 = CzechKeys()
def a_8 = num2cs()
def a_9 = cs2num()
COMPILE IF WANT_GUESS_WORD
def a_equal = GuessWord()
COMPILE ENDIF

; Error beep
DEFPROC ErrorBeep() =
; Beep(512,150)

const 
compile if not defined(cz_nums)
  cz_nums =   "젡",
compile endif
  real_nums = "1234567890"

; Deal with numbers on the alphanumeric keyboard
DEFPROC CzechNum()
universal dead_cnt
if dead_cnt then
dead_cnt = 0
ErrorBeep()
endif
parse value lastkey(2) with flags 3 repeat 4 scancode 5 charcode 7 vk
scan = asc(scancode)
if scan >= 2 and scan <= 11 then
  COMPILE IF WANT_NUM_UPCASE
    ch = substr(cz_nums, scan-1, 1)
    caps = getkeystate(VK_CAPSLOCK)
    if caps == KS_DOWNTOGGLE or caps == KS_UPTOGGLE then
      keyin upcase(ch)
    else
      keyin ch
    endif
  COMPILE ELSE
    keyin substr(cz_nums, scan-1, 1)
  COMPILE ENDIF
else
  keyin lastkey()
endif

; Conversion  to 8
DEFPROC cs2num() =
universal cs_dir
cs_dir = 1
call CsConvert()

; Conversion 8 to 
DEFPROC num2cs() =
universal cs_dir
cs_dir = 0
call CsConvert()

; Conversion body
DEFPROC CsConvert() =
universal cs_dir
if checkmark()==0 then
  ErrorBeep()
  sayerror 'No mark'
else
  display -1
  psave_pos(cs_pos)
  mt = marktype()
  getmark first_line, last_line, first_col, last_col, mark_fileid
  for linenum = first_line to last_line
    getline line, linenum
    len = length(line)
    if (mt=='CHAR' and linenum==first_line) or mt=='BLOCK' then
      a = first_col
    else
      a = 1
    endif
    if (mt=='CHAR' and linenum==last_line) or mt=='BLOCK' then
      z = min(last_col, len)
    else
      z = len
    endif
    stg = substr(line, a, z-a+1)
    if cs_dir then
      stg = translate(stg, real_nums, cz_nums)
    else
      stg = translate(stg, cz_nums, real_nums)
    endif
    if a==1 and z==len then
      repline = stg
    elseif a == 1 then
      repline = stg || substr(line, z+1, len-z)
    else
      repline = substr(line, 1, a-1) || stg || substr(line, z+1, len-z)
    endif
    replaceline repline, linenum
  endfor
  prestore_pos(cs_pos)
  display 1
endif

; Prints the dead key
DEFPROC CzechSpace() =
universal dead_cnt
if dead_cnt then
  for cnt = 1 to dead_cnt
    keyin dead_key
  endfor
  dead_cnt = 0
else
  keyin ' '
endif

const
compile if not defined(orig)
  orig = "AaCcDdEeIiLlNnOoRrSsTtUuYyZz<>"
compile endif
compile if not defined(dd1)
  dd1  = "Ԑ֡ꗘ썫"
compile endif
compile if not defined(dd2)
  dd2  = "Է׌盜ޅYy"
compile endif
compile if not defined(dd3)
  dd3  = "DdӉIiNnTtYyZz"
compile endif

; Other defined keys
DEFPROC CzechKeys() =
universal dead_cnt
ch = lastkey()
COMPILE IF SWAP_ZY
  ch = translate(ch, 'zZyY', 'yYzZ')
COMPILE ENDIF
if ch == dead_key then
  dead_cnt = dead_cnt + 1
  if dead_cnt == 4 then
    keyin dead_key
    dead_cnt = 0
    ErrorBeep()
  endif
else
  if dead_cnt then
    c = ch
    if dead_cnt == 1 then
      ch = translate(c, dd1, orig)
    elseif dead_cnt == 2 then
      ch = translate(c, dd2, orig)
    elseif dead_cnt == 3 then
      ch = translate(c, dd3, orig)
    else
      ErrorBeep();  sayerror 'this cannot happen'
    endif
    if c == ch then
      ErrorBeep() -- Invalid composite
    endif
    dead_cnt = 0
  endif
  keyin ch
endif

-- Guess Word
COMPILE IF WANT_GUESS_WORD
DEFPROC GuessWord() =
display -1
-- Save the cursor position
psave_pos(sv_pos)
call pbegin_word()
wb_line = .line;   wb_col = .col
call pend_word()
we_line = .line;   we_col = .col
if wb_line <> we_line or we_col < wb_col then
  ErrorBeep()
  prestore_pos(sv_pos)
  display 1 
  return
endif
call pbegin_word()
getline line, wb_line
wd = substr(line, wb_col, we_col-wb_col+1)
if strip(wd) == '' then
  ErrorBeep()
  prestore_pos(sv_pos)
  display 1 
  return
endif
getsearch sv_search
rc = 0
'L [ \t\n\.,><;:''`"\[\]\{\}\(\)!/\*\-\+^]'wd'-xre'
if rc <> 0 then
  ErrorBeep()
  setsearch sv_search
  prestore_pos(sv_pos)
  display 1 
  return
endif
ws_line = .line;   ws_col = .col+1
pend_word()
wse_col = .col
getline s_line, ws_line
wdx = substr(s_line, ws_col, wse_col-ws_col+1) 
.line = wb_line;   .col=wb_col
'C 'wd''wdx
prestore_pos(sv_pos)
.line = wb_line;   .col=wb_col
pend_word();   right
setsearch sv_search
display 1
COMPILE ENDIF
