/* ea_open.c -- this file is part of SYMLINK Library.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <share.h>
#include <errno.h>
#include <io.h>
#include "ansidecl.h"
#include "symlink/ea.h"


#define r_flags	(O_BINARY | O_RDONLY)
#define r_share (SH_DENYWR)
#define r_mode	(0)

#define w_flags	(O_BINARY | O_WRONLY | O_CREAT)
#define w_share (SH_DENYRW)
#define w_mode	(S_IREAD | S_IWRITE)

#define c_flags	(w_flags | O_TRUNC)
#define c_share w_share
#define c_mode	w_mode

#define n_flags	(w_flags | O_EXCL)
#define n_share w_share
#define n_mode	w_mode

struct _arg
  {
    int flags;
    int share;
    int mode;
  };

static const struct _arg arg[4] =
  {
    {r_flags, r_share, r_mode},
    {w_flags, w_share, w_mode},
    {c_flags, c_share, c_mode},
    {n_flags, n_share, n_mode},
  };


/* Open a file for reading or writing its extended attributes.  */

int
DEFUN (symlink_ea_open, (name, mode),
const char *name AND
int mode)
{
  if (mode < EA_OPEN_READ || mode > EA_OPEN_NEW)
    {
      errno = EINVAL;
      return (-1);
    }

  return (sopen (name, arg[mode].flags, arg[mode].share, arg[mode].mode));
}
