/*
This is a REXX batch for running TeX
Copyright (C) Z. Wagner -- Ice Bear Soft, 9 Jan 1996
-----------------------------------------------------
Usage:
------
TeXbatch format texfile [-|+]

where "format" is the name of the format and "texfile" is the name of the TeX file. The
format name is not case sensitive.

This batch calls TeXset.cmd to resolve TEXINPUT etc.

The "-" as the last parameter suppresses pause on error, '+' pauses always. If the last
option is not specified, the batch looks for the TEXPAUSE environment variable.  Its value
"NO" suppresses pause on error, all other values will pause if tex ends with nonzero
return code.
*/

'@echo off'
trace off
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

tex = 'tex386'                          /* command name */
cfg = 'TeXset.cmd'                      /* configuration batch */
texinput = '%emtexdir%\texinput'        /* base input */

parse arg format texfile option rest

if rest \= '' then do
  say 'Too many parameters'
  exit 1
end
if texfile == '' then do
  say 'Parameter(s) missing'
  exit 1
end

if option \= '-' & option \= '+'  then option = ''
pau = value('texpause',, 'OS2ENVIRONMENT')
if translate(pau) \= 'NO' then pau = 'YES'

dir = ''
xcfg = stream(cfg, 'C', 'QUERY EXISTS')
if xcfg \= '' then call stream xcfg, 'C', 'CLOSE'
else xcfg = SysSearchPath('PATH', cfg)
if xcfg == '' then dir = format

if xcfg == '' then do
  if dir == '' then 'SET TEXINPUT='texinput'!!'
  else 'SET TEXINPUT='texinput'\'dir'!!;'texinput'!!'
end
else do
  command = 'call' cfg format
  interpret command
end

if exist('prolog.cmd') then call 'prolog'

rc = 0
tex '^&'format texfile
rtn = rc
if option = '+' then 'pause'
else
if option \= '-' then do
  if (rtn \= 0) & (translate(pau) \= 'NO') then 'pause'
end
if exist('epilog.cmd') then call 'epilog'
exit rtn

exist: procedure
parse arg filename
fullname = stream(filename, 'C', 'QUERY EXISTS')
found = (fullname \= '')
if found then call stream fullname 'C', 'CLOSE'
return found
