/* TeXmain.cmd
Copyright (C) Z. Wagner -- Ice Bear Soft, 27 Dec 1995 

This batch assigns a main file name to specified TeX files. The main file may optionally 
get its format

Usage:
TeXfmt <mask> <main_file_name> [<format>]

The ".tex" extension of the main file may be omitted
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
parse arg mask main fmt rest
if (main=='') | (rest\='') then do
  say 'Usage:'
  say 'TeXfmt <mask> <main_file_name> [<format>]'
  exit 1
end

if fmt \= '' then call TeXfmt main fmt

/* Searching for files and looping for subject putting */

rc = SysfileTree(mask, 'files', 'FO')
if rc \= 0 then do
  say 'Error: cannot search files'
  exit rc
end

do i = 1 to files.0
  call putit files.i main
end

exit 0

/* This procedure puts the subject EA */

putit: procedure
parse arg fn m
rc = SysGetEA(fn, '.subject', subj)
if rc == 0 then do
  sub = substr(subj, 5)
  if sub \= '' then return
end
sub = 'MAIN=' || m
subj = 'FDFF'x || d2c(length(sub)) || '00'x || sub
rc = SysPutEA(fn, '.subject', subj)
if rc\=0 then say 'Error' rc 'when putting EA to' fn
return
