/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmdirAction
extends ProvisioningAction {
    public static final String ID = "rmdir";

    public IStatus execute(Map<String, Object> parameters) {
        String path = (String)parameters.get("path");
        if (path == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"path", (Object)ID));
        }
        IBackupStore store = (IBackupStore)parameters.get("backup");
        File dir = new File(path);
        if (!dir.isDirectory()) {
            return Util.createError(NLS.bind((String)Messages.rmdir_failed, (Object)path, (Object)ID));
        }
        if (store != null) {
            try {
                store.backupDirectory(dir);
            }
            catch (IOException e) {
                return new Status(2, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.rmdir_failed, (Object)path, (Object)ID), (Throwable)e);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            dir.delete();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        String path = (String)parameters.get("path");
        IBackupStore store = (IBackupStore)parameters.get("backup");
        if (path == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"path", (Object)ID));
        }
        if (store == null) {
            new File(path).mkdir();
        }
        return Status.OK_STATUS;
    }
}

