/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.commands.AdjustConnectionCommand;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.router.BendpointPolicyRouter;
import org.eclipse.fordiac.ide.gef.router.LineSegmentHandle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.requests.BendpointRequest;

public class MoveableRouter
extends BendpointConnectionRouter
implements BendpointPolicyRouter {
    private static final PrecisionPoint A_POINT = new PrecisionPoint();
    private static final Map<Connection, Integer> deltasX1 = new HashMap<Connection, Integer>();
    private static final Map<Connection, Integer> deltasX2 = new HashMap<Connection, Integer>();
    private static final Map<Connection, Integer> deltasY = new HashMap<Connection, Integer>();
    private final boolean invalidate = true;
    private final ArrayList<Connection> connections = new ArrayList();

    public void setDeltaX2(Connection connection, int deltaX2) {
        deltasX2.put(connection, deltaX2);
    }

    public int getDeltaX2(Connection connection) {
        if (deltasX2.containsKey(connection)) {
            return deltasX2.get(connection);
        }
        return 0;
    }

    public void setDeltaX1(Connection connection, int deltaX1) {
        deltasX1.put(connection, deltaX1);
    }

    public int getDeltaX1(Connection connection) {
        if (deltasX1.containsKey(connection)) {
            return deltasX1.get(connection);
        }
        return 0;
    }

    public void setDeltaY(Connection connection, int deltaY) {
        deltasY.put(connection, deltaY);
    }

    public int getDeltaY(Connection connection) {
        if (deltasY.containsKey(connection)) {
            return deltasY.get(connection);
        }
        return 0;
    }

    public void invalidate(Connection connection) {
        super.invalidate(connection);
        if (!this.connections.contains(connection)) {
            this.connections.add(connection);
        }
    }

    public void route(Connection conn) {
        ConnectionAnchor source;
        ConnectionAnchor dest;
        PointList points = conn.getPoints();
        points.removeAllPoints();
        if (MoveableRouter.needsSwap(conn)) {
            dest = conn.getSourceAnchor();
            source = conn.getTargetAnchor();
        } else {
            source = conn.getSourceAnchor();
            dest = conn.getTargetAnchor();
        }
        Point ref1 = dest.getReferencePoint();
        Point ref2 = source.getReferencePoint();
        Point checkYSource = dest.getLocation(ref2).getCopy();
        Point checkYDest = source.getLocation(ref1).getCopy();
        conn.translateToRelative((Translatable)checkYSource);
        conn.translateToRelative((Translatable)checkYDest);
        A_POINT.setLocation(source.getLocation(ref1));
        conn.translateToRelative((Translatable)A_POINT);
        points.addPoint((Point)A_POINT);
        Point min = dest.getLocation(ref2).getCopy();
        Point p2 = source.getLocation(ref1).getCopy();
        int x = p2.x;
        int newx = 0;
        newx = min.x - 20 > p2.x + 20 ? Math.min(min.x - 20, x + Math.max(20, this.getDeltaX1(conn))) : x + Math.max(20, this.getDeltaX1(conn));
        int deltaX = newx - p2.x;
        int relativeX = 0;
        Point p3 = dest.getLocation(ref2).getCopy();
        Point temp = source.getLocation(ref1).getCopy();
        if (p3.x - 40 <= temp.x) {
            A_POINT.setLocation(p2);
            conn.translateToRelative((Translatable)A_POINT);
            relativeX = MoveableRouter.A_POINT.x += deltaX;
            points.addPoint((Point)A_POINT);
            int dif = Math.abs(p3.y - temp.y);
            int y = 0;
            y = p3.y < temp.y ? p3.y + dif / 2 : temp.y + dif / 2;
            Point p5 = new Point(p2.x, y);
            A_POINT.setLocation(p5);
            conn.translateToRelative((Translatable)A_POINT);
            MoveableRouter.A_POINT.x = relativeX;
            MoveableRouter.A_POINT.y += this.getDeltaY(conn);
            points.addPoint((Point)A_POINT);
            x = p3.x;
            Point p4 = new Point(x, y);
            A_POINT.setLocation(p4);
            conn.translateToRelative((Translatable)A_POINT);
            MoveableRouter.A_POINT.x = Math.min(MoveableRouter.A_POINT.x + this.getDeltaX2(conn), MoveableRouter.A_POINT.x - 20);
            MoveableRouter.A_POINT.y += this.getDeltaY(conn);
            points.addPoint((Point)A_POINT);
            p3.x = x;
            A_POINT.setLocation(p3);
            conn.translateToRelative((Translatable)A_POINT);
            MoveableRouter.A_POINT.x = Math.min(MoveableRouter.A_POINT.x + this.getDeltaX2(conn), MoveableRouter.A_POINT.x - 20);
            points.addPoint((Point)A_POINT);
        } else if (checkYSource.y != checkYDest.y) {
            A_POINT.setLocation(p2);
            conn.translateToRelative((Translatable)A_POINT);
            relativeX = MoveableRouter.A_POINT.x += deltaX;
            points.addPoint((Point)A_POINT);
            A_POINT.setLocation(p3);
            conn.translateToRelative((Translatable)A_POINT);
            MoveableRouter.A_POINT.x = relativeX;
            points.addPoint((Point)A_POINT);
        }
        A_POINT.setLocation(dest.getLocation(ref2));
        conn.translateToRelative((Translatable)A_POINT);
        points.addPoint((Point)A_POINT);
        conn.setPoints(points);
    }

    private static boolean needsSwap(Connection conn) {
        if (conn.getSourceAnchor() instanceof FixedAnchor && ((FixedAnchor)conn.getSourceAnchor()).getEditPart() instanceof InterfaceEditPart) {
            InterfaceEditPart ep = (InterfaceEditPart)((FixedAnchor)conn.getSourceAnchor()).getEditPart();
            return ep.isInput();
        }
        return false;
    }

    public void remove(Connection connection) {
        super.remove(connection);
        this.connections.remove(connection);
    }

    @Override
    public EditPolicy getBendpointPolicy(final Object modelObject) {
        if (modelObject instanceof org.eclipse.fordiac.ide.model.libraryElement.Connection) {
            return new BendpointEditPolicy(){

                protected Command getMoveBendpointCommand(BendpointRequest request) {
                    return null;
                }

                protected Command getDeleteBendpointCommand(BendpointRequest request) {
                    return null;
                }

                protected Command getCreateBendpointCommand(BendpointRequest request) {
                    Point p = request.getLocation().getCopy();
                    this.getConnection().translateToAbsolute((Translatable)p);
                    return new AdjustConnectionCommand(this.getConnection(), p, request.getIndex(), (org.eclipse.fordiac.ide.model.libraryElement.Connection)modelObject);
                }

                protected void showCreateBendpointFeedback(BendpointRequest request) {
                    AdjustConnectionCommand cmd = new AdjustConnectionCommand(this.getConnection(), request.getLocation(), request.getIndex(), (org.eclipse.fordiac.ide.model.libraryElement.Connection)modelObject);
                    if (cmd.canExecute()) {
                        cmd.execute();
                    }
                }

                protected List createSelectionHandles() {
                    return this.createHandlesForAutomaticBendpoints();
                }

                private List<ConnectionHandle> createHandlesForAutomaticBendpoints() {
                    ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>();
                    AbstractConnectionEditPart connEP = (AbstractConnectionEditPart)this.getHost();
                    PointList points = this.getConnection().getPoints();
                    int i = 1;
                    while (i < points.size() - 2) {
                        list.add((ConnectionHandle)new LineSegmentHandle((ConnectionEditPart)connEP, i));
                        ++i;
                    }
                    return list;
                }
            };
        }
        return null;
    }
}

