/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

class ParameterData {
    public static final String PROPERTY = ParameterData.class.getName();
    private SingleVariableDeclaration fDeclaration;
    private int fAccessMode;
    private List<SimpleName> fReferences;
    private int fOperatorPrecedence;

    public ParameterData(SingleVariableDeclaration decl) {
        this.fDeclaration = decl;
        this.fAccessMode = 1;
        this.fReferences = new ArrayList<SimpleName>(2);
        this.fOperatorPrecedence = -1;
    }

    public String getName() {
        return this.fDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getTypeBinding() {
        return this.fDeclaration.resolveBinding().getType();
    }

    public void addReference(SimpleName node) {
        this.fReferences.add(node);
    }

    public List<SimpleName> references() {
        return this.fReferences;
    }

    public void setAccessMode(int mode) {
        this.fAccessMode = mode;
    }

    public boolean isUnused() {
        return this.fAccessMode == 1;
    }

    public boolean isFinal() {
        return Modifier.isFinal((int)this.fDeclaration.getModifiers());
    }

    public boolean isReadOnly() {
        return (this.fAccessMode & 6) != 0;
    }

    public boolean isWrite() {
        return (this.fAccessMode & 0x38) != 0;
    }

    public int getSimplifiedAccessMode() {
        if (this.isWrite()) {
            return 8;
        }
        if (this.isReadOnly()) {
            return 2;
        }
        return 1;
    }

    public int getNumberOfAccesses() {
        return this.fReferences.size();
    }

    public boolean needsEvaluation() {
        return this.fReferences.size() > 1;
    }

    public void setOperatorPrecedence(int newValue) {
        this.fOperatorPrecedence = newValue == -1 ? newValue : (this.fOperatorPrecedence == -1 ? newValue : Math.min(this.fOperatorPrecedence, newValue));
    }

    public int getOperatorPrecedence() {
        return this.fOperatorPrecedence;
    }
}

