/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;

public class TypeSetUnion
extends TypeSet {
    private TypeSet fLHS;
    private TypeSet fRHS;

    public TypeSetUnion(TypeSet lhs, TypeSet rhs) {
        super(lhs.getTypeSetEnvironment());
        this.fLHS = lhs;
        this.fRHS = rhs;
    }

    @Override
    public boolean isUniverse() {
        if (this.fLHS.isUniverse() || this.fRHS.isUniverse()) {
            return true;
        }
        if (this.fLHS.isSingleton() && this.fRHS.isSingleton()) {
            return false;
        }
        throw new IllegalStateException("unimplemented");
    }

    @Override
    public TypeSet makeClone() {
        return new TypeSetUnion(this.fLHS.makeClone(), this.fRHS.makeClone());
    }

    @Override
    public boolean isEmpty() {
        return this.fLHS.isEmpty() && this.fRHS.isEmpty();
    }

    @Override
    public boolean contains(TType t) {
        return this.fLHS.contains(t) || this.fRHS.contains(t);
    }

    @Override
    public boolean containsAll(TypeSet s) {
        return this.fLHS.containsAll(s) || this.fRHS.containsAll(s);
    }

    @Override
    public TType anyMember() {
        return this.fLHS.anyMember();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TypeSetUnion) {
            TypeSetUnion other = (TypeSetUnion)o;
            return other.fLHS.equals(this.fLHS) && other.fRHS.equals(this.fRHS);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.fLHS.hashCode() * 37 + this.fRHS.hashCode();
    }

    @Override
    public TypeSet upperBound() {
        throw new IllegalStateException("unimplemented");
    }

    @Override
    public TypeSet lowerBound() {
        throw new IllegalStateException("unimplemented");
    }

    @Override
    public Iterator<TType> iterator() {
        throw new IllegalStateException("unimplemented");
    }

    @Override
    public boolean isSingleton() {
        return this.fLHS.isSingleton() && this.fRHS.isSingleton() && this.fLHS.anyMember().equals((Object)this.fRHS.anyMember());
    }

    @Override
    public boolean hasUniqueLowerBound() {
        return false;
    }

    @Override
    public boolean hasUniqueUpperBound() {
        return false;
    }

    @Override
    public TType uniqueLowerBound() {
        return null;
    }

    @Override
    public TType uniqueUpperBound() {
        return null;
    }

    @Override
    public EnumeratedTypeSet enumerate() {
        EnumeratedTypeSet result = this.fLHS.enumerate();
        result.addAll(this.fRHS.enumerate());
        return result;
    }

    @Override
    public String toString() {
        return "<" + this.fID + ": union(" + this.fLHS + "," + this.fRHS + ")>";
    }
}

