/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.ui.util.PatternConstructor;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class QualifiedNameFinder {
    private static final GroupCategorySet QUALIFIED_NAMES = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.qualifiedNames", RefactoringCoreMessages.QualifiedNameFinder_qualifiedNames_name, RefactoringCoreMessages.QualifiedNameFinder_qualifiedNames_description));

    public static void process(QualifiedNameSearchResult result, String pattern, String newValue, String filePatterns, IProject root, IProgressMonitor monitor) {
        Assert.isNotNull((Object)pattern);
        Assert.isNotNull((Object)newValue);
        Assert.isNotNull((Object)root);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (filePatterns == null || filePatterns.length() == 0) {
            monitor.beginTask("", 1);
            monitor.worked(1);
            return;
        }
        ResultCollector collector = new ResultCollector(result, newValue);
        TextSearchEngine engine = TextSearchEngine.create();
        Pattern searchPattern = PatternConstructor.createPattern(pattern, true, false);
        engine.search(QualifiedNameFinder.createScope(filePatterns, root), (TextSearchRequestor)collector, searchPattern, monitor);
    }

    private static TextSearchScope createScope(String filePatterns, IProject root) {
        HashSet<IProject> res = new HashSet<IProject>();
        res.add(root);
        QualifiedNameFinder.addReferencingProjects(root, res);
        IResource[] resArr = res.toArray(new IResource[res.size()]);
        Pattern filePattern = QualifiedNameFinder.getFilePattern(filePatterns);
        return TextSearchScope.newSearchScope((IResource[])resArr, (Pattern)filePattern, (boolean)false);
    }

    private static Pattern getFilePattern(String filePatterns) {
        StringTokenizer tokenizer = new StringTokenizer(filePatterns, ",");
        String[] filePatternArray = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            filePatternArray[i++] = tokenizer.nextToken().trim();
        }
        return PatternConstructor.createPattern(filePatternArray, true, false);
    }

    private static void addReferencingProjects(IProject root, Set<IProject> res) {
        IProject[] projects = root.getReferencingProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (res.add(project)) {
                QualifiedNameFinder.addReferencingProjects(project, res);
            }
            ++i;
        }
    }

    private static class ResultCollector
    extends TextSearchRequestor {
        private final String fNewValue;
        private final QualifiedNameSearchResult fResult;

        public ResultCollector(QualifiedNameSearchResult result, String newValue) {
            this.fResult = result;
            this.fNewValue = newValue;
        }

        public boolean canRunInParallel() {
            return true;
        }

        public boolean acceptFile(IFile file) throws CoreException {
            IJavaElement element = JavaCore.create((IFile)file);
            if (element != null && element.exists()) {
                return false;
            }
            if (!FileBuffers.getTextFileBufferManager().isTextFileLocation(file.getFullPath(), false)) {
                return false;
            }
            IPath path = file.getProjectRelativePath();
            String segment = path.segment(0);
            return segment == null || !segment.startsWith(".refactorings") && !segment.startsWith(".deprecations");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
            char after;
            char before;
            int start = matchAccess.getMatchOffset();
            int length = matchAccess.getMatchLength();
            if (start > 0 && ((before = matchAccess.getFileContentChar(start - 1)) == '.' || Character.isJavaIdentifierPart(before))) {
                return true;
            }
            int end = start + length;
            int fileContentLength = matchAccess.getFileContentLength();
            if (end < fileContentLength && Character.isJavaIdentifierPart(after = matchAccess.getFileContentChar(end))) {
                return true;
            }
            IFile file = matchAccess.getFile();
            QualifiedNameSearchResult qualifiedNameSearchResult = this.fResult;
            synchronized (qualifiedNameSearchResult) {
                TextChange change = this.fResult.getChange(file);
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)RefactoringCoreMessages.QualifiedNameFinder_update_name, (TextEdit)new ReplaceEdit(start, length, this.fNewValue), (GroupCategorySet)QUALIFIED_NAMES);
            }
            return true;
        }
    }
}

