/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class IntroduceParameterObjectAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public IntroduceParameterObjectAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(true);
    }

    public IntroduceParameterObjectAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.IntroduceParameterObjectAction_action_text);
        this.setToolTipText(ActionMessages.IntroduceParameterObjectAction_action_tooltip);
        this.setDescription(ActionMessages.IntroduceParameterObjectAction_action_description);
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isIntroduceParameterObjectAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    @Override
    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isIntroduceParameterObjectAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            IMethod singleSelectedMethod = IntroduceParameterObjectAction.getSingleSelectedMethod(selection);
            if (!ActionUtil.isEditable(this.getShell(), (IJavaElement)singleSelectedMethod)) {
                return;
            }
            this.run(singleSelectedMethod);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.IntroduceParameterObjectAction_exceptiondialog_title, ActionMessages.IntroduceParameterObjectAction_unexpected_exception);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            this.run(this.getSingleSelectedMethod(selection));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.IntroduceParameterObjectAction_exceptiondialog_title, ActionMessages.IntroduceParameterObjectAction_unexpected_exception);
        }
    }

    @Override
    public void run(JavaTextSelection selection) {
        try {
            IJavaElement[] elements = selection.resolveElementAtOffset();
            if (elements.length != 1) {
                return;
            }
            if (!(elements[0] instanceof IMethod)) {
                return;
            }
            this.run((IMethod)elements[0]);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.IntroduceParameterObjectAction_exceptiondialog_title, ActionMessages.IntroduceParameterObjectAction_unexpected_exception);
        }
    }

    private void run(IMethod method) throws CoreException {
        if (method == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.IntroduceParameterObjectAction_exceptiondialog_title, (String)ActionMessages.IntroduceParameterObjectAction_can_not_run_refactoring_message);
        } else if (this.fEditor == null || ActionUtil.isEditable(this.fEditor)) {
            RefactoringExecutionStarter.startIntroduceParameterObject(method, this.getShell());
        }
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IMethod)) {
            return null;
        }
        return (IMethod)element;
    }

    private IMethod getSingleSelectedMethod(ITextSelection selection) throws JavaModelException {
        IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
        if (elements.length > 1) {
            return null;
        }
        if (elements.length == 1 && elements[0] instanceof IMethod) {
            return (IMethod)elements[0];
        }
        IJavaElement elementAt = SelectionConverter.getInputAsCompilationUnit(this.fEditor).getElementAt(selection.getOffset());
        if (!(elementAt instanceof IMethod)) {
            return null;
        }
        return (IMethod)elementAt;
    }
}

