/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarAntExporter;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FatJarRsrcUrlAntExporter
extends FatJarAntExporter {
    public FatJarRsrcUrlAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
        super(antScriptLocation, jarLocation, launchConfiguration);
    }

    @Override
    protected void buildANTScript(IPath antScriptLocation, String projectName, IPath absJarfile, String mainClass, FatJarAntExporter.SourceInfo[] sourceInfos) throws FileNotFoundException, IOException {
        File antScriptFile = antScriptLocation.toFile();
        this.buildANTScript(new FileOutputStream(antScriptFile), projectName, absJarfile, mainClass, sourceInfos);
        this.copyJarInJarLoader(new File(antScriptFile.getParentFile(), "jar-in-jar-loader.zip"));
    }

    private void copyJarInJarLoader(File targetFile) throws IOException {
        int cnt;
        InputStream is = JavaPlugin.getDefault().getBundle().getEntry("jar-in-jar-loader.zip").openStream();
        FileOutputStream os = new FileOutputStream(targetFile);
        byte[] buf = new byte[1024];
        while ((cnt = is.read(buf)) > 0) {
            ((OutputStream)os).write(buf, 0, cnt);
        }
        ((OutputStream)os).close();
        is.close();
    }

    protected void buildANTScript(OutputStream outputStream, String projectName, IPath absJarfile, String mainClass, FatJarAntExporter.SourceInfo[] sourceInfos) throws IOException {
        String absJarname = absJarfile.toString();
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(FatJarPackagerMessages.FatJarPackageAntScript_error_couldNotGetXmlBuilder);
        }
        Document document = docBuilder.newDocument();
        Element project = document.createElement("project");
        project.setAttribute("name", "Create Runnable Jar for Project " + projectName + " with Jar-in-Jar Loader");
        project.setAttribute("default", "create_run_jar");
        Comment comment = document.createComment("this file was created by Eclipse Runnable JAR file Export Wizard");
        project.appendChild(comment);
        comment = document.createComment("ANT 1.7 is required");
        project.appendChild(comment);
        document.appendChild(project);
        this.addBaseDirProperties(document, project);
        Element target = document.createElement("target");
        target.setAttribute("name", "create_run_jar");
        project.appendChild(target);
        Element jar = document.createElement("jar");
        jar.setAttribute("destfile", this.substituteBaseDirs(absJarname));
        target.appendChild(jar);
        Element manifest = document.createElement("manifest");
        jar.appendChild(manifest);
        Element attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Main-Class");
        attribute.setAttribute("value", "org.eclipse.jdt.internal.jarinjarloader.JarRsrcLoader");
        manifest.appendChild(attribute);
        attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Rsrc-Main-Class");
        attribute.setAttribute("value", mainClass);
        manifest.appendChild(attribute);
        attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Class-Path");
        attribute.setAttribute("value", ".");
        manifest.appendChild(attribute);
        attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Rsrc-Class-Path");
        StringBuffer rsrcClassPath = new StringBuffer();
        rsrcClassPath.append("./");
        int i = 0;
        while (i < sourceInfos.length) {
            FatJarAntExporter.SourceInfo sourceInfo = sourceInfos[i];
            if (sourceInfo.isJar) {
                rsrcClassPath.append(" ").append(new File(sourceInfo.absPath).getName());
            }
            ++i;
        }
        attribute.setAttribute("value", rsrcClassPath.toString());
        manifest.appendChild(attribute);
        Element zipfileset = document.createElement("zipfileset");
        zipfileset.setAttribute("src", "jar-in-jar-loader.zip");
        jar.appendChild(zipfileset);
        int i2 = 0;
        while (i2 < sourceInfos.length) {
            FatJarAntExporter.SourceInfo sourceInfo = sourceInfos[i2];
            if (sourceInfo.isJar) {
                File jarFile = new File(sourceInfo.absPath);
                Element fileset = document.createElement("zipfileset");
                fileset.setAttribute("dir", this.substituteBaseDirs(jarFile.getParent()));
                fileset.setAttribute("includes", jarFile.getName());
                jar.appendChild(fileset);
            } else {
                Element fileset = document.createElement("fileset");
                fileset.setAttribute("dir", this.substituteBaseDirs(sourceInfo.absPath));
                jar.appendChild(fileset);
            }
            ++i2;
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
            throw new IOException(FatJarPackagerMessages.FatJarPackageAntScript_error_couldNotTransformToXML);
        }
    }
}

