/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.corext.util.CollectionsUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CustomCodeFormatterBlock
extends Observable {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ID = "id";
    private IEclipsePreferences fPrefs;
    private String fDefaultFormatterId;
    private FormatterContribution[] fFormatters;
    private Combo fFormatterCombo;

    public CustomCodeFormatterBlock(IProject project, PreferencesAccess access) {
        IEclipsePreferences defaults;
        IScopeContext scope;
        if (project != null) {
            scope = access.getProjectScope(project);
            defaults = access.getInstanceScope().getNode("org.eclipse.jdt.core");
        } else {
            scope = access.getInstanceScope();
            defaults = access.getDefaultScope().getNode("org.eclipse.jdt.core");
        }
        this.fPrefs = scope.getNode("org.eclipse.jdt.core");
        this.fDefaultFormatterId = defaults.get("org.eclipse.jdt.core.javaFormatter", "org.eclipse.jdt.core.defaultJavaFormatter");
        this.initializeFormatters();
    }

    public void performOk() {
        if (this.fFormatterCombo == null) {
            return;
        }
        String formatterId = this.fFormatters[this.fFormatterCombo.getSelectionIndex()].fId;
        if (!formatterId.equals(this.fDefaultFormatterId)) {
            this.fPrefs.put("org.eclipse.jdt.core.javaFormatter", formatterId);
        } else {
            this.performDefaults();
        }
    }

    public void performDefaults() {
        this.fPrefs.remove("org.eclipse.jdt.core.javaFormatter");
        if (this.fFormatterCombo == null) {
            return;
        }
        int index = this.getFormatterIndex(this.fDefaultFormatterId);
        this.fFormatterCombo.select(index);
        this.handleFormatterChanged();
    }

    public void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (useProjectSpecificSettings) {
            if (this.fDefaultFormatterId != null) {
                this.fPrefs.put("org.eclipse.jdt.core.javaFormatter", this.fDefaultFormatterId);
            }
        } else {
            this.initDefault();
        }
    }

    public void createContents(Composite parent, int numColumns) {
        if (this.fFormatters.length <= 1) {
            return;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 10).numColumns(2).create());
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(FormatterMessages.CustomCodeFormatterBlock_formatter_name);
        this.fFormatterCombo = new Combo(composite, 12);
        this.fFormatterCombo.setFont(composite.getFont());
        this.fFormatterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCodeFormatterBlock.this.handleFormatterChanged();
            }
        });
        FormatterContribution[] formatterContributionArray = this.fFormatters;
        int n = this.fFormatters.length;
        int n2 = 0;
        while (n2 < n) {
            FormatterContribution formatter = formatterContributionArray[n2];
            this.fFormatterCombo.add(formatter.fName);
            ++n2;
        }
        this.initDefault();
    }

    private void initDefault() {
        if (this.fFormatterCombo == null) {
            return;
        }
        String formatterID = this.fPrefs.get("org.eclipse.jdt.core.javaFormatter", this.fDefaultFormatterId);
        this.fFormatterCombo.select(this.getFormatterIndex(formatterID));
    }

    private int getFormatterIndex(String formatterId) {
        if (formatterId != null) {
            int i = 0;
            while (i < this.fFormatters.length) {
                if (formatterId.equals(this.fFormatters[i].fId)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    private void handleFormatterChanged() {
        this.setChanged();
        String formatterId = this.getFormatterId();
        this.notifyObservers(formatterId);
    }

    public String getFormatterId() {
        if (this.fFormatterCombo == null) {
            return this.fPrefs.get("org.eclipse.jdt.core.javaFormatter", this.fDefaultFormatterId);
        }
        return this.fFormatters[this.fFormatterCombo.getSelectionIndex()].fId;
    }

    private void initializeFormatters() {
        ArrayList<FormatterContribution> formatters = new ArrayList<FormatterContribution>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", "javaFormatter");
        if (point != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = point.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] elements = ext.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String name = elements[j].getAttribute(ATTR_NAME);
                    String id = elements[j].getAttribute(ATTR_ID);
                    formatters.add(new FormatterContribution(id, name));
                    ++j;
                }
                ++n2;
            }
        }
        Collections.sort(formatters, new Comparator<FormatterContribution>(){

            @Override
            public int compare(FormatterContribution o1, FormatterContribution o2) {
                return o1.fName.compareTo(o2.fName);
            }
        });
        this.fFormatters = CollectionsUtil.toArray(formatters, FormatterContribution.class);
    }

    private static class FormatterContribution {
        public String fId;
        public String fName;

        public FormatterContribution(String id, String name) {
            this.fId = id;
            this.fName = name;
        }
    }
}

