/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.UIExtensionTracker;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.propertytypes.EventTopics;

@Component(service={IContextFunction.class})
@IContextFunction.ServiceContextKey(value=IExtensionTracker.class)
@EventTopics(value={"org/eclipse/e4/core/contexts/IEclipseContext/DISPOSE"})
public class ExtensionTrackeContextFunction
extends ContextFunction
implements EventHandler {
    @Reference
    private ILog log;
    private Map<IEclipseContext, IExtensionTracker> createdObjects = new ConcurrentHashMap<IEclipseContext, IExtensionTracker>();

    public Object compute(IEclipseContext context, String contextKey) {
        return this.createdObjects.computeIfAbsent(context, ctx -> new UIExtensionTracker(runnable -> {
            UISynchronize synchronize = (UISynchronize)ctx.get(UISynchronize.class);
            if (synchronize != null) {
                synchronize.asyncExec(runnable);
            }
        }, this.log));
    }

    @Deactivate
    void shutdown() {
        this.createdObjects.values().forEach(IExtensionTracker::close);
        this.createdObjects.clear();
    }

    public void handleEvent(Event event) {
        Object property = event.getProperty("org.eclipse.e4.core.contexts.IEclipseContext");
        if (property instanceof IEclipseContext) {
            this.createdObjects.computeIfPresent((IEclipseContext)property, (k, v) -> {
                v.close();
                return null;
            });
        }
    }
}

