/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.ArrayList;
import org.eclipse.fordiac.ide.application.commands.NewSubAppCommand;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ToggleSubAppRepresentationCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.gef.commands.Command;

public class UpdateContractCommand
extends Command {
    private ChangeCommentCommand cccmd;
    private NewSubAppCommand subappcmd;
    private ToggleSubAppRepresentationCommand toggle;
    private ChangeNameCommand cncmd;
    private final String comment;
    private final FBNetworkElement fbNetworkElement;

    public UpdateContractCommand(FBNetworkElement fbNetworkElement, String comment) {
        this.comment = comment;
        this.fbNetworkElement = fbNetworkElement;
    }

    public void execute() {
        if (this.cccmd == null) {
            SubApp subapp = this.createNewSubapp();
            StringBuilder finalcomment = new StringBuilder();
            String oldcomment = subapp.getComment();
            if (oldcomment.indexOf("ASSUMPTION") == 0) {
                finalcomment.append(oldcomment);
                finalcomment.append(System.lineSeparator());
            }
            finalcomment.append(this.comment);
            this.cccmd = new ChangeCommentCommand((INamedElement)subapp, finalcomment.toString());
            if (this.cccmd.canExecute()) {
                this.cccmd.execute();
            }
        }
    }

    public void undo() {
        this.cccmd.undo();
        if (this.toggle != null) {
            this.toggle.undo();
        }
        this.cncmd.undo();
        this.subappcmd.undo();
        super.undo();
    }

    public void redo() {
        this.subappcmd.redo();
        this.cncmd.redo();
        if (this.toggle != null) {
            this.toggle.redo();
        }
        this.cccmd.redo();
        super.redo();
    }

    private SubApp createNewSubapp() {
        if (this.fbNetworkElement.isNestedInSubApp()) {
            SubApp subapp = (SubApp)this.fbNetworkElement.eContainer().eContainer();
            if (!subapp.isUnfolded()) {
                this.toggle = new ToggleSubAppRepresentationCommand(subapp);
                if (this.toggle.canExecute()) {
                    this.toggle.execute();
                }
            }
            return subapp;
        }
        FBNetwork network = this.fbNetworkElement.getFbNetwork();
        Position pos = this.fbNetworkElement.getPosition();
        ArrayList<FBNetworkElement> list = new ArrayList<FBNetworkElement>();
        list.add(this.fbNetworkElement);
        this.subappcmd = new NewSubAppCommand(network, list, pos);
        if (this.subappcmd.canExecute()) {
            this.subappcmd.execute();
        }
        UntypedSubApp subapp = this.subappcmd.getElement();
        this.cncmd = ChangeNameCommand.forName((INamedElement)subapp, (String)NameRepository.createUniqueName((INamedElement)subapp, (String)("_CONTRACT_" + this.fbNetworkElement.getName())));
        if (this.cncmd.canExecute()) {
            this.cncmd.execute();
        }
        this.toggle = new ToggleSubAppRepresentationCommand((SubApp)subapp);
        if (this.toggle.canExecute()) {
            this.toggle.execute();
        }
        return subapp;
    }
}

