/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.data;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class ResourceDeploymentData {
    private final Resource res;
    private final List<FBDeploymentData> fbs = new ArrayList<FBDeploymentData>();
    private final List<ConnectionDeploymentData> connections = new ArrayList<ConnectionDeploymentData>();
    private final List<ParameterData> params = new ArrayList<ParameterData>();

    public Resource getRes() {
        return this.res;
    }

    public List<FBDeploymentData> getFbs() {
        return this.fbs;
    }

    public List<ConnectionDeploymentData> getConnections() {
        return this.connections;
    }

    public List<ParameterData> getParams() {
        return this.params;
    }

    public void addFbs(FBDeploymentData fb) {
        this.fbs.add(fb);
    }

    public void addConnections(ConnectionDeploymentData connection) {
        this.connections.add(connection);
    }

    public void addParameter(ParameterData param) {
        this.params.add(param);
    }

    public ResourceDeploymentData(Resource res) throws DeploymentException {
        this.res = res;
        this.addFBNetworkElements(new ArrayDeque<SubApp>(), res.getFBNetwork(), "");
    }

    private void addFBNetworkElements(Deque<SubApp> subAppHierarchy, FBNetwork fbNetwork, String prefix) throws DeploymentException {
        for (FBNetworkElement fbnElement : fbNetwork.getNetworkElements()) {
            String prefixToUse;
            String string = prefixToUse = prefix.isEmpty() ? ResourceDeploymentData.getMappedParentName(fbnElement) : prefix;
            if (fbnElement instanceof FB) {
                this.fbs.add(new FBDeploymentData(prefixToUse, fbnElement));
                continue;
            }
            if (!(fbnElement instanceof SubApp)) continue;
            SubApp subApp = (SubApp)fbnElement;
            this.addSubAppParams(subApp, subAppHierarchy, prefixToUse);
            FBNetwork subAppInternalNetwork = ResourceDeploymentData.getFBNetworkForSubApp(subApp);
            if (subAppInternalNetwork == null) continue;
            subAppHierarchy.addLast((SubApp)fbnElement);
            this.addFBNetworkElements(subAppHierarchy, subAppInternalNetwork, prefixToUse + fbnElement.getName() + ".");
            subAppHierarchy.removeLast();
        }
        Stream.concat(Stream.concat(fbNetwork.getEventConnections().stream(), fbNetwork.getDataConnections().stream()), fbNetwork.getAdapterConnections().stream()).forEach(con -> this.addConnection(subAppHierarchy, (Connection)con, prefix));
    }

    public static String getMappedParentName(FBNetworkElement fbnElement) {
        EObject eObject;
        if (fbnElement.isMapped() && (eObject = fbnElement.getOpposite().eContainer().eContainer()) instanceof INamedElement) {
            INamedElement namedEl = (INamedElement)eObject;
            return namedEl.getQualifiedName() + ".";
        }
        return "";
    }

    private void addSubAppParams(SubApp subApp, Deque<SubApp> subAppHierarchy, String prefix) throws DeploymentException {
        for (VarDeclaration dataInput : subApp.getInterface().getInputVars()) {
            Function<VarDeclaration, String> dataInputValue = DeploymentHelper.getVariableValueRetargetable(dataInput, subApp);
            if (dataInputValue == null || !ResourceDeploymentData.useSubAppInitialValue(subAppHierarchy, subApp, dataInput)) continue;
            for (ConDeploymentDest destData : this.getSubappInterfaceconnections(subAppHierarchy, prefix, (IInterfaceElement)dataInput)) {
                VarDeclaration destVar = (VarDeclaration)destData.destination;
                String destDataValue = dataInputValue.apply(destVar);
                this.params.add(new ParameterData(destDataValue, destData.prefix, destVar));
            }
        }
    }

    private static boolean useSubAppInitialValue(Deque<SubApp> subAppHierachy, SubApp subApp, VarDeclaration varDec) {
        IInterfaceElement ie = subApp.getInterfaceElement(varDec.getName());
        if (!ResourceDeploymentData.hasInputConnections(ie)) {
            return true;
        }
        IInterfaceElement source = ResourceDeploymentData.getSourcePin(ie);
        while (ResourceDeploymentData.hasInputConnections(source)) {
            if (!source.isIsInput()) {
                return false;
            }
            Optional<SubApp> sA = ResourceDeploymentData.getSubAppFromInterfacePin(subAppHierachy, source);
            if (sA.isPresent()) {
                if (source.getInputConnections().isEmpty() && source instanceof VarDeclaration) {
                    VarDeclaration varDecl = (VarDeclaration)source;
                    return !DeploymentHelper.hasTypeOrInstanceInitialValue(sA.get(), varDecl);
                }
                if (ResourceDeploymentData.isToplevelSubapp(sA.get())) break;
            }
            source = ResourceDeploymentData.getSourcePin(source);
        }
        return false;
    }

    private static Optional<SubApp> getSubAppFromInterfacePin(Deque<SubApp> subappHierachy, IInterfaceElement ie) {
        return subappHierachy.stream().filter(sub -> sub.getInterface().getInput(ie.getName()) != null).findFirst();
    }

    private static IInterfaceElement getSourcePin(IInterfaceElement pin) {
        EList conList = pin.getInputConnections();
        if (conList.isEmpty()) {
            return null;
        }
        return ((Connection)conList.getFirst()).getSource();
    }

    private static boolean isToplevelSubapp(SubApp subApp) {
        return subApp.eContainer() != null && subApp.eContainer().eContainer() != null && subApp.eContainer().eContainer() instanceof Resource;
    }

    private static boolean hasInputConnections(IInterfaceElement pin) {
        return pin != null && pin.isIsInput() && !pin.getInputConnections().isEmpty();
    }

    private static FBNetwork getFBNetworkForSubApp(SubApp subApp) {
        FBNetwork retVal = subApp.getSubAppNetwork();
        if (retVal == null) {
            if (subApp.isTyped()) {
                retVal = subApp.getType().getFBNetwork();
            } else {
                FBNetworkElement fBNetworkElement = subApp.getOpposite();
                if (fBNetworkElement instanceof SubApp) {
                    SubApp oppositeSubApp = (SubApp)fBNetworkElement;
                    retVal = oppositeSubApp.getSubAppNetwork();
                }
            }
        }
        return retVal;
    }

    private void addConnection(Deque<SubApp> subAppHierarchy, Connection con, String prefix) {
        if (con.getSourceElement() != null && !(con.getSourceElement() instanceof SubApp)) {
            String sourcePrefix = prefix.isEmpty() ? ResourceDeploymentData.getMappedParentName(con.getSourceElement()) : prefix;
            for (ConDeploymentDest destData : this.getConnectionEndPoint(subAppHierarchy, prefix, con.getDestination())) {
                this.connections.add(new ConnectionDeploymentData(sourcePrefix, con.getSource(), destData.prefix, destData.destination));
            }
        }
    }

    private List<ConDeploymentDest> getConnectionEndPoint(Deque<SubApp> subAppHierarchy, String prefix, IInterfaceElement destination) {
        String destPrefix;
        ArrayList<ConDeploymentDest> retVal = new ArrayList<ConDeploymentDest>();
        String string = destPrefix = prefix.isEmpty() ? ResourceDeploymentData.getMappedParentName(destination.getFBNetworkElement()) : prefix;
        if (destination.getFBNetworkElement() != null && !(destination.getFBNetworkElement() instanceof SubApp)) {
            retVal.add(new ConDeploymentDest(destPrefix, destination));
        } else {
            retVal.addAll(this.getSubappInterfaceconnections(subAppHierarchy, destPrefix, destination));
        }
        return retVal;
    }

    private List<ConDeploymentDest> getSubappInterfaceconnections(Deque<SubApp> subAppHierarchy, String prefix, IInterfaceElement destination) {
        ArrayList<ConDeploymentDest> retVal = new ArrayList<ConDeploymentDest>();
        if (destination.isIsInput()) {
            String newPrefix = (prefix.isEmpty() ? ResourceDeploymentData.getMappedParentName(destination.getFBNetworkElement()) : prefix) + destination.getFBNetworkElement().getName() + ".";
            subAppHierarchy.addLast((SubApp)destination.getFBNetworkElement());
            IInterfaceElement internalElement = ResourceDeploymentData.getSubAppInteralElement(destination);
            if (internalElement != null) {
                for (Connection con : internalElement.getOutputConnections()) {
                    retVal.addAll(this.getConnectionEndPoint(subAppHierarchy, newPrefix, con.getDestination()));
                }
            }
            subAppHierarchy.removeLast();
        } else {
            SubApp currentSubApp = subAppHierarchy.removeLast();
            String newPrefix = subAppHierarchy.isEmpty() ? "" : ResourceDeploymentData.removeLastEntry(prefix, currentSubApp.getName());
            IInterfaceElement internalElement = currentSubApp.getInterfaceElement(destination.getName());
            for (Connection con : internalElement.getOutputConnections()) {
                retVal.addAll(this.getConnectionEndPoint(subAppHierarchy, newPrefix, con.getDestination()));
            }
            subAppHierarchy.addLast(currentSubApp);
        }
        return retVal;
    }

    private static IInterfaceElement getSubAppInteralElement(IInterfaceElement destination) {
        SubApp subApp = (SubApp)destination.getFBNetworkElement();
        if (subApp.getSubAppNetwork() != null) {
            return destination;
        }
        InterfaceList interfaceList = null;
        if (subApp.isTyped()) {
            interfaceList = subApp.getType().getInterfaceList();
        } else {
            FBNetworkElement fBNetworkElement = subApp.getOpposite();
            if (fBNetworkElement instanceof SubApp) {
                SubApp subAppOpposite = (SubApp)fBNetworkElement;
                interfaceList = subAppOpposite.getInterface();
            }
        }
        if (interfaceList != null) {
            return interfaceList.getInterfaceElement(destination.getName());
        }
        return null;
    }

    private static String removeLastEntry(String prefix, String lastEntryName) {
        int newEnd = prefix.length() - lastEntryName.length() - 1;
        if (newEnd > 0) {
            return prefix.substring(0, newEnd);
        }
        return "";
    }

    private static class ConDeploymentDest {
        private final String prefix;
        private final IInterfaceElement destination;

        public ConDeploymentDest(String prefix, IInterfaceElement destination) {
            this.prefix = prefix;
            this.destination = destination;
        }
    }

    public static class ParameterData {
        private final String value;
        private final VarDeclaration variable;
        private final String prefix;

        public String getValue() {
            return this.value;
        }

        public VarDeclaration getVar() {
            return this.variable;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ParameterData(String value, String prefix, VarDeclaration variable) {
            this.value = value;
            this.variable = variable;
            this.prefix = prefix;
        }
    }
}

