/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.widgets.Display;

public class GraphicalViewerAnnotationModelEventDispatcher
implements GraphicalAnnotationModelListener {
    private final GraphicalViewer viewer;

    public GraphicalViewerAnnotationModelEventDispatcher(GraphicalViewer viewer) {
        Objects.requireNonNull(viewer);
        this.viewer = viewer;
    }

    @Override
    public void modelChanged(GraphicalAnnotationModelEvent event) {
        Display.getDefault().execute(() -> this.dispatch(event));
    }

    protected void dispatch(GraphicalAnnotationModelEvent event) {
        Stream.of(event.getAdded(), event.getRemoved(), event.getChanged()).flatMap(Collection::stream).map(GraphicalAnnotation::getTarget).distinct().forEachOrdered(target -> this.dispatch(target, event));
    }

    protected void dispatch(Object target, GraphicalAnnotationModelEvent event) {
        AnnotableGraphicalEditPart editPart = this.findEditPart(target);
        if (editPart != null) {
            editPart.updateAnnotations(event);
        }
    }

    protected AnnotableGraphicalEditPart findEditPart(Object target) {
        EditPart editPart;
        if (target != null && (editPart = this.viewer.getEditPartForModel(target)) instanceof AnnotableGraphicalEditPart) {
            AnnotableGraphicalEditPart editPart2 = (AnnotableGraphicalEditPart)editPart;
            return editPart2;
        }
        return null;
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }
}

