/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public abstract class TypeImporter
extends CommonElementImporter {
    protected TypeImporter(IFile file) {
        super(file);
    }

    protected TypeImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    protected TypeImporter(CommonElementImporter importer) {
        super(importer);
    }

    protected VarDeclaration parseVarDeclaration() throws TypeImportException, XMLStreamException {
        String initialValue;
        VarDeclaration v = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.readNameCommentAttributes(v);
        String typeName = this.getAttributeValue("Type");
        if (typeName == null) {
            throw new TypeImportException(Messages.Import_ERROR_InputVariableTypeNotDefined);
        }
        DataType dataType = this.addDependency(this.getDataTypeLibrary().getType(typeName));
        v.setType(dataType);
        String arraySize = this.getAttributeValue("ArraySize");
        if (arraySize != null) {
            ArraySizeHelper.setArraySize(v, arraySize);
        }
        if ((initialValue = this.getAttributeValue("InitialValue")) != null) {
            Value varInitialization = LibraryElementFactory.eINSTANCE.createValue();
            varInitialization.setValue(initialValue);
            v.setValue(varInitialization);
        }
        this.processChildren("VarDeclaration", name -> {
            if ("Attribute".equals(name)) {
                this.parseGenericAttributeNode(v);
                this.proceedToEndElementNamed("Attribute");
                return true;
            }
            return false;
        });
        this.proceedToEndElementNamed("VarDeclaration");
        return v;
    }
}

