/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.util.stream.Stream;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

final class InterfaceListAnnotations {
    public static EList<IInterfaceElement> getAllInterfaceElements(InterfaceList il) {
        BasicEList retVal = new BasicEList();
        retVal.addAll(il.getEventInputs());
        retVal.addAll(il.getInputVars());
        retVal.addAll(il.getInOutVars());
        retVal.addAll(il.getSockets());
        retVal.addAll(il.getEventOutputs());
        retVal.addAll(il.getOutputVars());
        retVal.addAll(il.getOutMappedInOutVars());
        retVal.addAll(il.getPlugs());
        retVal.addAll(il.getErrorMarker());
        return retVal;
    }

    public static Event getEvent(InterfaceList il, String name) {
        for (Event event : il.getEventInputs()) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        for (Event event : il.getEventOutputs()) {
            if (!event.getName().equals(name)) continue;
            return event;
        }
        return null;
    }

    public static VarDeclaration getVariable(InterfaceList il, String name) {
        for (VarDeclaration inVar : il.getInputVars()) {
            if (!inVar.getName().equals(name)) continue;
            return inVar;
        }
        for (VarDeclaration outVar : il.getOutputVars()) {
            if (!outVar.getName().equals(name)) continue;
            return outVar;
        }
        for (VarDeclaration inOutVar : il.getInOutVars()) {
            if (!inOutVar.getName().equals(name)) continue;
            return inOutVar;
        }
        return null;
    }

    public static IInterfaceElement getInterfaceElement(InterfaceList il, String name) {
        IInterfaceElement element = il.getEvent(name);
        if (element == null) {
            element = il.getVariable(name);
        }
        if (element == null) {
            element = il.getAdapter(name);
        }
        if (element == null) {
            element = il.getErrorMarker().stream().filter(e -> e.getName().equals(name)).findAny().orElse(null);
        }
        return element;
    }

    public static FBNetworkElement getFBNetworkElement(InterfaceList il) {
        FBNetworkElement fbnEl;
        EObject eObject = il.eContainer();
        return eObject instanceof FBNetworkElement ? (fbnEl = (FBNetworkElement)eObject) : null;
    }

    public static AdapterDeclaration getAdapter(InterfaceList il, String name) {
        for (AdapterDeclaration adapt : il.getPlugs()) {
            if (!adapt.getName().equals(name)) continue;
            return adapt;
        }
        for (AdapterDeclaration adapt : il.getSockets()) {
            if (!adapt.getName().equals(name)) continue;
            return adapt;
        }
        return null;
    }

    public static Stream<IInterfaceElement> getInputs(InterfaceList il) {
        return Stream.concat(Stream.concat(il.getEventInputs().stream(), il.getInputVars().stream()), Stream.concat(il.getInOutVars().stream(), il.getSockets().stream()));
    }

    public static Stream<IInterfaceElement> getOutputs(InterfaceList il) {
        return Stream.concat(Stream.concat(il.getEventOutputs().stream(), il.getOutputVars().stream()), Stream.concat(il.getOutMappedInOutVars().stream(), il.getPlugs().stream()));
    }

    private InterfaceListAnnotations() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

