/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.AbstractStringValueConverter;

public final class WStringValueConverter
extends AbstractStringValueConverter {
    public static final WStringValueConverter INSTANCE = new WStringValueConverter();

    private WStringValueConverter() {
    }

    @Override
    public String toValue(String string) throws IllegalArgumentException {
        if (string.length() < 1 || string.charAt(0) != '\"') {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, string));
        }
        return super.toValue(string);
    }

    @Override
    public String toValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        if (scanner.findWithinHorizon(SCANNER_WSTRING_QUOTE_PATTERN, 0) == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_IllegalStringLiteral, "<scanner>"));
        }
        return WStringValueConverter.toValue(scanner, SCANNER_WSTRING_QUOTE_PATTERN, SCANNER_WSTRING_ESCAPE_PATTERN, SCANNER_WSTRING_NON_ESCAPE_PATTERN);
    }

    @Override
    public String toString(String value) {
        return WStringValueConverter.toString(value, true);
    }
}

