/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.providers;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.DistributedSystemListener;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SystemExplorerRootContentProvider
implements ITreeContentProvider,
DistributedSystemListener {
    private Viewer viewer;

    public SystemExplorerRootContentProvider() {
        SystemManager.INSTANCE.addWorkspaceListener((DistributedSystemListener)this);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)parentElement;
            return Arrays.stream(root.getProjects()).filter(SystemExplorerRootContentProvider::projectToShow).toArray();
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object getParent(Object object) {
        if (object instanceof IResource) {
            IResource ires = (IResource)object;
            return ires.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IResource) {
            if (element instanceof IProject) {
                IProject project = (IProject)element;
                return project.isAccessible();
            }
            if (SystemManager.isSystemFile((Object)element)) {
                return true;
            }
        }
        return false;
    }

    public void distributedSystemWorkspaceChanged() {
        if (this.viewer != null && this.viewer.getControl() != null && this.viewer.getControl().getDisplay() != null) {
            this.viewer.getControl().getDisplay().asyncExec(() -> {
                if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
                    this.viewer.refresh();
                }
            });
        }
    }

    private static boolean projectToShow(IProject proj) {
        try {
            return !proj.isOpen() || proj.hasNature("org.eclipse.fordiac.ide.systemmanagement.FordiacNature") || proj.hasNature("org.robotframework.ide.eclipse.main.plugin.robotNature");
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)"Could not read project nature", (Throwable)e);
            return false;
        }
    }
}

