/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.io.ByteStreams;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.LanguageServerImpl;
import org.eclipse.xtext.ide.server.LaunchArgs;
import org.eclipse.xtext.ide.server.ServerModule;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;

public class ServerLauncher {
    public static final String LOG = "-log";
    public static final String TRACE = "-trace";
    public static final String NO_VALIDATE = "-noValidate";
    @Inject
    private LanguageServerImpl languageServer;

    public static void main(String[] args) {
        ServerLauncher.launch(ServerLauncher.class.getName(), args, new Module[]{new ServerModule()});
    }

    public static void launch(String prefix, String[] args, Module ... modules) {
        LaunchArgs launchArgs = ServerLauncher.createLaunchArgs(prefix, args);
        ServerLauncher launcher = (ServerLauncher)Guice.createInjector((Module[])modules).getInstance(ServerLauncher.class);
        launcher.start(launchArgs);
    }

    public void start(LaunchArgs args) {
        try {
            InputOutput.println((Object)"Xtext Language Server is starting.");
            Launcher launcher = Launcher.createLauncher((Object)this.languageServer, LanguageClient.class, (InputStream)args.getIn(), (OutputStream)args.getOut(), (boolean)args.isValidate(), (PrintWriter)args.getTrace());
            this.languageServer.connect((LanguageClient)launcher.getRemoteProxy());
            Future future = launcher.startListening();
            InputOutput.println((Object)"Xtext Language Server has been started.");
            while (!future.isDone()) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    public static LaunchArgs createLaunchArgs(String prefix, String[] args) {
        LaunchArgs launchArgs = new LaunchArgs();
        launchArgs.setIn(System.in);
        launchArgs.setOut(System.out);
        ServerLauncher.redirectStandardStreams(prefix, args);
        launchArgs.setTrace(ServerLauncher.getTrace(args));
        launchArgs.setValidate(ServerLauncher.shouldValidate(args));
        return launchArgs;
    }

    public static PrintWriter getTrace(String[] args) {
        if (ServerLauncher.shouldTrace(args)) {
            return ServerLauncher.createTrace();
        }
        return null;
    }

    public static PrintWriter createTrace() {
        return new PrintWriter(System.out);
    }

    public static void redirectStandardStreams(String prefix, String[] args) {
        if (ServerLauncher.shouldLogStandardStreams(args)) {
            ServerLauncher.logStandardStreams(prefix);
        } else {
            ServerLauncher.silentStandardStreams();
        }
    }

    public static boolean shouldValidate(String[] args) {
        return !ServerLauncher.testArg(args, NO_VALIDATE);
    }

    public static boolean shouldTrace(String[] args) {
        return ServerLauncher.testArg(args, TRACE);
    }

    public static boolean shouldLogStandardStreams(String[] args) {
        return ServerLauncher.testArg(args, LOG, "debug");
    }

    public static boolean testArg(String[] args, String ... values) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (ServerLauncher.testArg(arg, values)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean testArg(String arg, String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (Objects.equals(value, arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void logStandardStreams(String prefix) {
        try {
            FileOutputStream stdFileOut = new FileOutputStream(prefix + "-debug.log");
            ServerLauncher.redirectStandardStreams(stdFileOut);
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    public static void silentStandardStreams() {
        ServerLauncher.redirectStandardStreams(ServerLauncher.silentOut());
    }

    public static void redirectStandardStreams(OutputStream out) {
        ServerLauncher.redirectStandardStreams(ServerLauncher.silentIn(), out);
    }

    public static void redirectStandardStreams(InputStream in, OutputStream out) {
        System.setIn(in);
        System.setOut(new PrintStream(out));
    }

    public static OutputStream silentOut() {
        return ByteStreams.nullOutputStream();
    }

    public static InputStream silentIn() {
        return new ByteArrayInputStream(new byte[0]);
    }
}

