/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.FlattenSubAppCommand;
import org.eclipse.fordiac.ide.gef.utilities.ElementSelector;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateGroupCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class ConvertSubappToGroupCommand
extends Command
implements ScopedCommand {
    private final SubApp sourceSubapp;
    private final FBNetwork fbNetwork;
    private CreateGroupCommand createGroupCmd;
    private final CompoundCommand convertToGroupCmd = new CompoundCommand();

    public ConvertSubappToGroupCommand(SubApp source) {
        this.sourceSubapp = Objects.requireNonNull(source);
        this.fbNetwork = source.getFbNetwork();
        this.createConvertToGroupCommand();
    }

    public void execute() {
        this.convertToGroupCmd.execute();
        Group destination = this.createGroupCmd.getElement();
        destination.setWidth(this.sourceSubapp.getWidth());
        destination.setHeight(this.sourceSubapp.getHeight());
        ChangeNameCommand copyNameCmd = ChangeNameCommand.forName((INamedElement)destination, (String)this.sourceSubapp.getName());
        copyNameCmd.execute();
        this.convertToGroupCmd.add((Command)copyNameCmd);
        ChangeCommentCommand copyCommentCmd = new ChangeCommentCommand((INamedElement)destination, this.sourceSubapp.getComment());
        copyCommentCmd.execute();
        this.convertToGroupCmd.add((Command)copyCommentCmd);
        ElementSelector.selectViewObjects(Arrays.asList(destination));
    }

    private void createConvertToGroupCommand() {
        ArrayList subappContents = new ArrayList(this.sourceSubapp.getSubAppNetwork().getNetworkElements());
        this.convertToGroupCmd.add((Command)new FlattenSubAppCommand(this.sourceSubapp, false));
        Rectangle bounds = new Rectangle(this.sourceSubapp.getPosition().toScreenPoint(), new Dimension(CoordinateConverter.INSTANCE.iec61499ToScreen(this.sourceSubapp.getWidth()), CoordinateConverter.INSTANCE.iec61499ToScreen(this.sourceSubapp.getHeight())));
        this.createGroupCmd = new CreateGroupCommand(this.fbNetwork, subappContents, bounds);
        this.convertToGroupCmd.add((Command)this.createGroupCmd);
    }

    public boolean canExecute() {
        return ConvertSubappToGroupCommand.isUntypedSubapp(this.sourceSubapp) && !this.sourceSubapp.isInGroup();
    }

    private static boolean isUntypedSubapp(SubApp subapp) {
        return !subapp.isTyped() && !subapp.isContainedInTypedInstance();
    }

    public void undo() {
        this.convertToGroupCmd.undo();
        ElementSelector.selectViewObjects(Arrays.asList(this.sourceSubapp));
    }

    public void redo() {
        this.convertToGroupCmd.redo();
        ElementSelector.selectViewObjects(Arrays.asList(this.createGroupCmd.getElement()));
    }

    public Group getCreatedElement() {
        return this.createGroupCmd.getElement();
    }

    public Set<EObject> getAffectedObjects() {
        if (this.fbNetwork != null) {
            return Set.of(this.fbNetwork);
        }
        return Set.of();
    }
}

