/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.bulkeditor.editors.FilterComposite;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.AbstractLiveSearchContext;
import org.eclipse.fordiac.ide.model.search.ISearchContext;
import org.eclipse.fordiac.ide.model.search.types.IEC61499SearchFilter;
import org.eclipse.fordiac.ide.model.search.types.ISearchChildrenProvider;
import org.eclipse.fordiac.ide.model.search.types.SearchChildrenProviderHelper;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class SearchHelper {
    public static final Predicate<TypeEntry> linkedElementsFilter = entry -> {
        String[] stringArray = entry.getFile().getFullPath().segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.equals("External Libraries") || segment.equals("Standard Libraries")) {
                return false;
            }
            ++n2;
        }
        return true;
    };
    final FilterRecordClass blockTypesRecord;
    final FilterRecordClass blockInstanceRecord;
    final FilterRecordClass untypedSubappRecord;
    final FilterRecordClass dataTypesRecord;
    final FilterRecordClass attributeTypesRecord;
    final boolean ignoreLinkedLibraries;

    public SearchHelper(FilterRecordClass fbSubappTypesRecord, FilterRecordClass fbTypedSubappInstanceRecord, FilterRecordClass untypedSubappRecord, FilterRecordClass dataTypesRecord, FilterRecordClass attributeTypesRecord, boolean ignoreLinkedLibraries) {
        this.blockTypesRecord = fbSubappTypesRecord;
        this.blockInstanceRecord = fbTypedSubappInstanceRecord;
        this.untypedSubappRecord = untypedSubappRecord;
        this.dataTypesRecord = dataTypesRecord;
        this.attributeTypesRecord = attributeTypesRecord;
        this.ignoreLinkedLibraries = ignoreLinkedLibraries;
    }

    public static List<ISearchContext> createSearchContextList(IProject project, final List<URI> uriList) {
        return List.of(new AbstractLiveSearchContext(project){

            public Stream<URI> getTypes() {
                return uriList.stream();
            }

            public EObject mapTypes(URI uri) {
                TypeEntry typeEntry = Objects.requireNonNull(TypeLibraryManager.INSTANCE.getTypeEntryForURI(uri));
                return typeEntry.getType().eResource().getEObject(uri.fragment());
            }
        });
    }

    public List<ISearchContext> createSearchContextList(boolean workspace, boolean project, IProject iproject) {
        if (workspace) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            return Arrays.stream(root.getProjects()).filter(IProject::isOpen).map(this::createSearchContext).map(ISearchContext.class::cast).toList();
        }
        if (project) {
            return List.of(this.createSearchContext(iproject));
        }
        return List.of();
    }

    private ISearchContext createSearchContext(IProject project) {
        return new AbstractLiveSearchContext(project){

            public Stream<URI> getTypes() {
                Stream<Object> s = Stream.empty();
                if (SearchHelper.this.blockTypesRecord.selected) {
                    Predicate<TypeEntry> filter = entry -> SearchHelper.matchesString(entry.getFullTypeName(), SearchHelper.this.blockTypesRecord.nameFilter, SearchHelper.this.blockTypesRecord.namePattern) && SearchHelper.matchesString(entry.getTypeName(), SearchHelper.this.blockTypesRecord.typeFilter, SearchHelper.this.blockTypesRecord.typePattern) && SearchHelper.matchesString(entry.getComment(), SearchHelper.this.blockTypesRecord.commentFilter, SearchHelper.this.blockTypesRecord.commentPattern);
                    s = Stream.concat(s, Stream.concat(this.getTypelib().getFbTypes().stream().filter(filter), this.getTypelib().getSubAppTypes().stream().filter(filter)));
                }
                if (SearchHelper.this.blockInstanceRecord.selected || SearchHelper.this.untypedSubappRecord.selected) {
                    s = Stream.concat(s, this.getTypelib().getSystems().stream());
                }
                if (SearchHelper.this.dataTypesRecord.selected) {
                    s = Stream.concat(s, this.getTypelib().getDataTypeLibrary().getDerivedDataTypes().stream().filter(dtEntry -> SearchHelper.matchesString(dtEntry.getFullTypeName(), SearchHelper.this.dataTypesRecord.nameFilter, SearchHelper.this.dataTypesRecord.namePattern) && SearchHelper.matchesString(dtEntry.getTypeName(), SearchHelper.this.dataTypesRecord.typeFilter, SearchHelper.this.dataTypesRecord.typePattern) && SearchHelper.matchesString(dtEntry.getComment(), SearchHelper.this.dataTypesRecord.commentFilter, SearchHelper.this.dataTypesRecord.commentPattern)));
                }
                if (SearchHelper.this.attributeTypesRecord.selected) {
                    s = Stream.concat(s, this.getTypelib().getAttributeTypes().stream().filter(atEntry -> SearchHelper.matchesString(atEntry.getFullTypeName(), SearchHelper.this.attributeTypesRecord.nameFilter, SearchHelper.this.attributeTypesRecord.namePattern) && SearchHelper.matchesString(atEntry.getTypeName(), SearchHelper.this.attributeTypesRecord.typeFilter, SearchHelper.this.attributeTypesRecord.typePattern) && SearchHelper.matchesString(atEntry.getComment(), SearchHelper.this.attributeTypesRecord.commentFilter, SearchHelper.this.attributeTypesRecord.commentPattern)));
                }
                if (SearchHelper.this.ignoreLinkedLibraries) {
                    s = s.filter(linkedElementsFilter);
                }
                return s.map(TypeEntry::getURI).filter(Objects::nonNull);
            }

            public EObject mapTypes(URI uri) {
                TypeEntry typeEntry = Objects.requireNonNull(TypeLibraryManager.INSTANCE.getTypeEntryForURI(uri));
                return typeEntry.getType();
            }
        };
    }

    public static IEC61499SearchFilter createAttributeDeclarationSearchFilter(AttributeDeclaration attributeDeclaration) {
        return searchCandidate -> {
            Attribute attribute;
            return searchCandidate instanceof Attribute && (attribute = (Attribute)searchCandidate).getAttributeDeclaration() != null && attributeDeclaration.getTypeEntry() == attribute.getAttributeDeclaration().getTypeEntry();
        };
    }

    public static IEC61499SearchFilter createSearchFilter(final int mode, final List<FilterComposite.Filter> filters) {
        return new IEC61499SearchFilter(){
            private final Pattern namePattern;
            private final Pattern typePattern;
            private final Pattern commentPattern;
            private final Pattern valuePattern;
            {
                this.namePattern = SearchHelper.createPattern((FilterComposite.Filter)((Object)list.get(0)));
                this.typePattern = SearchHelper.createPattern((FilterComposite.Filter)((Object)list.get(1)));
                this.commentPattern = SearchHelper.createPattern((FilterComposite.Filter)((Object)list.get(2)));
                this.valuePattern = SearchHelper.createPattern((FilterComposite.Filter)((Object)list.get(3)));
            }

            public boolean apply(EObject searchCandidate) {
                if (!this.isValidCandidate(searchCandidate)) {
                    return false;
                }
                ITypedElement typedElement = (ITypedElement)searchCandidate;
                return SearchHelper.matchesString(typedElement.getName(), (FilterComposite.Filter)((Object)filters.get(0)), this.namePattern) && SearchHelper.matchesString(typedElement.getTypeName(), (FilterComposite.Filter)((Object)filters.get(1)), this.typePattern) && SearchHelper.matchesString(typedElement.getComment(), (FilterComposite.Filter)((Object)filters.get(2)), this.commentPattern) && SearchHelper.matchesString(InitialValueHelper.getInitialOrDefaultValue((Object)typedElement), (FilterComposite.Filter)((Object)filters.get(3)), this.valuePattern);
            }

            private boolean isValidCandidate(Object searchCandidate) {
                return searchCandidate instanceof VarDeclaration && mode == 0 || searchCandidate instanceof Attribute && mode == 1;
            }
        };
    }

    public ISearchChildrenProvider createChildrenSearchProvider() {
        return new ISearchChildrenProvider(){

            public boolean hasChildren(EObject obj) {
                return obj instanceof FBType || obj instanceof AutomationSystem || SearchHelper.this.untypedSubappRecord.selected && obj instanceof UntypedSubApp || SearchHelper.this.dataTypesRecord.selected && obj instanceof StructuredType || SearchHelper.this.attributeTypesRecord.selected && obj instanceof AttributeDeclaration || obj instanceof Application || SearchHelper.this.blockInstanceRecord.selected && obj instanceof FBNetworkElement || obj instanceof IInterfaceElement;
            }

            public Stream<? extends EObject> getChildren(EObject obj) {
                EObject eObject = obj;
                Objects.requireNonNull(eObject);
                EObject eObject2 = eObject;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBType.class, AutomationSystem.class, Application.class, UntypedSubApp.class, StructuredType.class, AttributeDeclaration.class, BlockFBNetworkElement.class, ConfigurableObject.class}, (Object)eObject2, 0)) {
                    case 0 -> {
                        FBType fbType = (FBType)eObject2;
                        yield SearchChildrenProviderHelper.getFBTypeChildren((FBType)fbType);
                    }
                    case 1 -> {
                        AutomationSystem system = (AutomationSystem)eObject2;
                        yield Stream.concat(system.getAttributes().stream(), system.getApplication().stream());
                    }
                    case 2 -> {
                        Application application = (Application)eObject2;
                        yield this.getApplicationChildren(application);
                    }
                    case 3 -> {
                        UntypedSubApp untypedSubapp = (UntypedSubApp)eObject2;
                        yield SearchChildrenProviderHelper.getUntypedSubappChildren((UntypedSubApp)untypedSubapp);
                    }
                    case 4 -> {
                        StructuredType structType = (StructuredType)eObject2;
                        yield Stream.concat(SearchChildrenProviderHelper.getStructChildren((StructuredType)structType), structType.getAttributes().stream());
                    }
                    case 5 -> {
                        AttributeDeclaration attrdecl = (AttributeDeclaration)eObject2;
                        yield SearchChildrenProviderHelper.getAttributeDeclChildren((AttributeDeclaration)attrdecl);
                    }
                    case 6 -> {
                        BlockFBNetworkElement elem = (BlockFBNetworkElement)eObject2;
                        yield Stream.concat(elem.getAttributes().stream(), SearchChildrenProviderHelper.getInterfaceListChildren((InterfaceList)elem.getInterface()));
                    }
                    case 7 -> {
                        ConfigurableObject configurableObject = (ConfigurableObject)eObject2;
                        yield configurableObject.getAttributes().stream();
                    }
                    default -> Stream.empty();
                };
            }

            private Stream<? extends EObject> getApplicationChildren(Application application) {
                Stream<Object> stream = Stream.empty();
                if (SearchHelper.this.untypedSubappRecord.selected) {
                    stream = application.getFBNetwork().getNetworkElements().stream().filter(fbne -> fbne instanceof UntypedSubApp && SearchHelper.matchesString(fbne.getName(), SearchHelper.this.untypedSubappRecord.nameFilter, SearchHelper.this.untypedSubappRecord.namePattern) && SearchHelper.matchesString(fbne.getTypeName(), SearchHelper.this.untypedSubappRecord.typeFilter, SearchHelper.this.untypedSubappRecord.typePattern) && SearchHelper.matchesString(fbne.getComment(), SearchHelper.this.untypedSubappRecord.commentFilter, SearchHelper.this.untypedSubappRecord.commentPattern));
                }
                if (SearchHelper.this.blockInstanceRecord.selected) {
                    stream = Stream.concat(stream, application.getFBNetwork().getNetworkElements().stream().filter(fbne -> (fbne instanceof TypedSubApp || fbne instanceof FB) && SearchHelper.matchesString(fbne.getName(), SearchHelper.this.blockInstanceRecord.nameFilter, SearchHelper.this.blockInstanceRecord.namePattern) && SearchHelper.matchesString(fbne.getTypeName(), SearchHelper.this.blockInstanceRecord.typeFilter, SearchHelper.this.blockInstanceRecord.typePattern) && SearchHelper.matchesString(fbne.getComment(), SearchHelper.this.blockInstanceRecord.commentFilter, SearchHelper.this.blockInstanceRecord.commentPattern)));
                }
                stream = Stream.concat(stream, application.getFBNetwork().getAdapterConnections().stream());
                stream = Stream.concat(stream, application.getFBNetwork().getDataConnections().stream());
                stream = Stream.concat(stream, application.getFBNetwork().getEventConnections().stream());
                return Stream.concat(stream, application.getAttributes().stream());
            }
        };
    }

    private static boolean matchesString(String toCheck, FilterComposite.Filter filter, Pattern pattern) {
        return !filter.selected.getSelection() || SearchHelper.compareStrings(filter, pattern, toCheck);
    }

    private static boolean compareStrings(FilterComposite.Filter filter, Pattern pattern, String element) {
        String search = filter.textField.getText();
        if (search == null || element == null) {
            return false;
        }
        if (!filter.caseSensitive.getSelection()) {
            element = element.toLowerCase();
            search = search.toLowerCase();
        }
        if (filter.regularExpression.getSelection() && pattern != null) {
            return pattern.matcher(element).find();
        }
        if (filter.wholeWord.getSelection()) {
            String searchString = search;
            return Arrays.stream(element.split("\\W+")).anyMatch(word -> word.equals(searchString));
        }
        if (filter.exactMatch.getSelection()) {
            return element.equals(search);
        }
        return element.contains(search);
    }

    private static Pattern createPattern(FilterComposite.Filter filter) {
        Object query = filter.textField.getText();
        if (!filter.regularExpression.getSelection()) {
            return null;
        }
        if (!filter.caseSensitive.getSelection()) {
            query = ((String)query).toLowerCase();
        }
        if (filter.exactMatch.getSelection()) {
            query = "^" + (String)query + "$";
        }
        try {
            return Pattern.compile((String)query);
        }
        catch (PatternSyntaxException exception) {
            return null;
        }
    }

    static /* synthetic */ boolean access$0(String string, FilterComposite.Filter filter, Pattern pattern) {
        return SearchHelper.matchesString(string, filter, pattern);
    }

    public static class FilterRecordClass {
        private final boolean selected;
        private final FilterComposite.Filter nameFilter;
        private final FilterComposite.Filter typeFilter;
        private final FilterComposite.Filter commentFilter;
        private final Pattern namePattern;
        private final Pattern typePattern;
        private final Pattern commentPattern;

        public FilterRecordClass(boolean selected, FilterComposite.Filter nameFilter, FilterComposite.Filter typeFilter, FilterComposite.Filter commentFilter) {
            this.selected = selected;
            this.nameFilter = nameFilter;
            this.typeFilter = typeFilter;
            this.commentFilter = commentFilter;
            this.namePattern = SearchHelper.createPattern(nameFilter);
            this.typePattern = SearchHelper.createPattern(typeFilter);
            this.commentPattern = SearchHelper.createPattern(commentFilter);
        }

        static /* synthetic */ FilterComposite.Filter access$0(FilterRecordClass filterRecordClass) {
            return filterRecordClass.nameFilter;
        }

        static /* synthetic */ Pattern access$1(FilterRecordClass filterRecordClass) {
            return filterRecordClass.namePattern;
        }

        static /* synthetic */ FilterComposite.Filter access$2(FilterRecordClass filterRecordClass) {
            return filterRecordClass.typeFilter;
        }

        static /* synthetic */ Pattern access$3(FilterRecordClass filterRecordClass) {
            return filterRecordClass.typePattern;
        }

        static /* synthetic */ FilterComposite.Filter access$4(FilterRecordClass filterRecordClass) {
            return filterRecordClass.commentFilter;
        }

        static /* synthetic */ Pattern access$5(FilterRecordClass filterRecordClass) {
            return filterRecordClass.commentPattern;
        }
    }
}

