/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugElement;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugStackFrame;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementExecutorService;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;

public class DeploymentDebugResource
extends DeploymentDebugElement
implements IThread,
IDisconnect {
    private final Resource resource;
    private final boolean allowTerminate;

    public DeploymentDebugResource(Resource resoure, DeploymentDebugDevice target, boolean allowTerminate) {
        super(target);
        this.resource = resoure;
        this.allowTerminate = allowTerminate;
        this.fireCreationEvent();
    }

    public boolean canResume() {
        return this.getDebugTarget().isAllowTerminate() && this.getDebugTarget().isAlive();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().isAllowTerminate() && this.getDebugTarget().isAlive();
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
        try {
            this.getDeviceManagementExecutorService().startResource(this.resource);
        }
        catch (DeploymentException e) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.DeploymentDebugResource_ResumeError, this.resource.getQualifiedName()), (Throwable)e));
        }
    }

    public void suspend() throws DebugException {
        try {
            this.getDeviceManagementExecutorService().stopResource(this.resource);
        }
        catch (DeploymentException e) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.DeploymentDebugResource_SuspendError, this.resource.getQualifiedName()), (Throwable)e));
        }
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
        throw DeploymentDebugResource.createUnsupportedOperationException();
    }

    public void stepOver() throws DebugException {
        throw DeploymentDebugResource.createUnsupportedOperationException();
    }

    public void stepReturn() throws DebugException {
        throw DeploymentDebugResource.createUnsupportedOperationException();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().isAlive() && this.allowTerminate;
    }

    public boolean isTerminated() {
        return false;
    }

    public void terminate() throws DebugException {
        try {
            this.getDeviceManagementExecutorService().killResource(this.resource.getName());
            this.getDeviceManagementExecutorService().deleteResource(this.resource.getName());
        }
        catch (DeploymentException e) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.DeploymentDebugResource_TerminateError, this.resource.getQualifiedName()), (Throwable)e));
        }
    }

    public boolean canDisconnect() {
        return this.getDebugTarget().canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.getDebugTarget().disconnect();
    }

    public boolean isDisconnected() {
        return this.getDebugTarget().isDisconnected();
    }

    public IStackFrame[] getStackFrames() {
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() {
        return false;
    }

    public int getPriority() {
        return 0;
    }

    public DeploymentDebugStackFrame getTopStackFrame() {
        return null;
    }

    public String getName() {
        return this.resource.getName();
    }

    public IBreakpoint[] getBreakpoints() {
        return new IBreakpoint[0];
    }

    @Override
    public DeploymentDebugDevice getDebugTarget() {
        return (DeploymentDebugDevice)super.getDebugTarget();
    }

    public IDeviceManagementExecutorService getDeviceManagementExecutorService() {
        return this.getDebugTarget().getDeviceManagementExecutorService();
    }
}

