/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

public class MarkerCreationTimeField
extends MarkerField {
    private final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);

    @Override
    public String getValue(MarkerItem item) {
        long creationTime = ((MarkerSupportItem)item).getCreationTime();
        if (creationTime < 0L) {
            return "";
        }
        return String.valueOf(creationTime);
    }

    @Override
    public int compare(MarkerItem item1, MarkerItem item2) {
        long time1 = ((MarkerSupportItem)item1).getCreationTime();
        long time2 = ((MarkerSupportItem)item2).getCreationTime();
        return Long.compare(time1, time2);
    }

    @Override
    public void update(ViewerCell cell) {
        long creationTime;
        Object element = cell.getElement();
        String timeStr = "";
        if (element instanceof MarkerEntry && (creationTime = ((MarkerEntry)element).getCreationTime()) > 0L) {
            Date date = new Date(creationTime);
            timeStr = this.dateFormat.format(date);
        }
        cell.setText(timeStr);
    }
}

