/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.collection;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.collection.AbstractCollectionService;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;

public class IntersectionService
extends AbstractCollectionService {
    public IntersectionService(Method serviceMethod, Object serviceInstance, boolean forWorkspace) {
        super(serviceMethod, serviceInstance, forWorkspace);
    }

    @Override
    public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment queryEnvironment, List<IType> argTypes) {
        IType arg2Type;
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        IType arg1Type = argTypes.get(0) instanceof ICollectionType ? ((ICollectionType)argTypes.get(0)).getCollectionType() : (argTypes.get(0) instanceof NothingType ? argTypes.get(0) : services.nothing("%s can only be called on collections, but %s was used as its receiver.", this.getName(), argTypes.get(0)));
        Set<IType> resultRawTypes = services.intersection(arg1Type, arg2Type = argTypes.get(1) instanceof ICollectionType ? ((ICollectionType)argTypes.get(1)).getCollectionType() : (argTypes.get(1) instanceof NothingType ? argTypes.get(1) : services.nothing("%s can only be called on collections, but %s was used as its argument.", this.getName(), argTypes.get(1))));
        if (resultRawTypes.isEmpty()) {
            if (arg1Type instanceof NothingType) {
                resultRawTypes.add(arg1Type);
            }
            if (arg2Type instanceof NothingType) {
                resultRawTypes.add(arg2Type);
            }
            if (resultRawTypes.isEmpty()) {
                resultRawTypes.add(services.nothing("Nothing left after intersection of %s and %s", argTypes.get(0), argTypes.get(1)));
            }
        }
        for (IType resultRawType : resultRawTypes) {
            result.add(this.createReturnCollectionWithType(queryEnvironment, resultRawType));
        }
        return result;
    }

    @Override
    public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
            for (IType type : entry.getValue()) {
                if (((ICollectionType)type).getCollectionType() instanceof NothingType) {
                    builder.append("\n ");
                    builder.append(((NothingType)((ICollectionType)type).getCollectionType()).getMessage());
                    continue;
                }
                result.add(type);
            }
        }
        if (result.isEmpty()) {
            NothingType nothing = services.nothing("Nothing left after intersection:" + builder.toString(), new Object[0]);
            result.add(this.createReturnCollectionWithType(queryEnvironment, nothing));
        }
        return result;
    }
}

