/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public final class AcceleoMarkerUtils {
    public static final String PROBLEM_MARKER_ID = "org.eclipse.acceleo.ide.ui.problem";
    public static final String WARNING_MARKER_ID = "org.eclipse.acceleo.ide.ui.warning";
    public static final String INFO_MARKER_ID = "org.eclipse.acceleo.ide.ui.info";
    public static final String OVERRIDE_MARKER_ID = "org.eclipse.acceleo.ide.ui.override";
    public static final String TASK_MARKER_ID = "org.eclipse.core.resources.taskmarker";

    private AcceleoMarkerUtils() {
    }

    public static void createMarkerOnFile(String markerId, IFile file, int line, int posBegin, int posEnd, String message) throws CoreException {
        IMarker marker = AcceleoMarkerUtils.createMarker(markerId, file, message);
        int priority = AcceleoMarkerUtils.determinePriority(markerId, message);
        if (marker == null) {
            return;
        }
        marker.setAttribute("priority", priority);
        marker.setAttribute("severity", 1);
        marker.setAttribute("lineNumber", line);
        marker.setAttribute("charStart", posBegin);
        marker.setAttribute("charEnd", posEnd);
        marker.setAttribute("message", (Object)message);
        if (PROBLEM_MARKER_ID.equals(markerId)) {
            marker.setAttribute("severity", 2);
        } else if (INFO_MARKER_ID.equals(markerId)) {
            if (message.startsWith("AcceleoParser.Info.TemplateOverride")) {
                marker.setAttribute("severity", 0);
                marker.setAttribute("message", (Object)message.substring("AcceleoParser.Info.TemplateOverride".length()));
            } else if (message.startsWith("AcceleoParserInfo.TODO")) {
                marker.setAttribute("userEditable", false);
                marker.setAttribute("message", (Object)message.substring("AcceleoParserInfo.TODO".length()));
            } else if (message.startsWith("AcceleoParserInfo.FIXME")) {
                marker.setAttribute("userEditable", false);
                marker.setAttribute("message", (Object)message.substring("AcceleoParserInfo.FIXME".length()));
            } else if (message.startsWith("AcceleoParserInfo.SERVICE_INVOCATION")) {
                AcceleoMarkerUtils.computeAccessibleService(file, message, marker);
            }
        }
    }

    private static void computeAccessibleService(IFile file, String message, IMarker marker) throws JavaModelException, CoreException {
        boolean exported = false;
        boolean found = false;
        String projectName = "";
        IProject project = file.getProject();
        AcceleoProject acceleoProject = new AcceleoProject(project);
        List<IProject> recursivelyAccessibleProjects = acceleoProject.getRecursivelyAccessibleProjects();
        for (IProject iProject : recursivelyAccessibleProjects) {
            ExportPackageDescription[] exportPackages;
            IPackageFragment[] packageFragments;
            if (!iProject.isAccessible() || !iProject.hasNature("org.eclipse.jdt.core.javanature")) continue;
            JavaProject javaProject = new JavaProject();
            javaProject.setProject(iProject);
            IType type = null;
            ArrayList<IType> types = new ArrayList<IType>();
            IPackageFragment[] iPackageFragmentArray = packageFragments = javaProject.getPackageFragments();
            int n = packageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment iPackageFragment = iPackageFragmentArray[n2];
                if (iPackageFragment.getKind() == 1) {
                    ICompilationUnit[] compilationUnits;
                    ICompilationUnit[] iCompilationUnitArray = compilationUnits = iPackageFragment.getCompilationUnits();
                    int n3 = compilationUnits.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICompilationUnit iCompilationUnit = iCompilationUnitArray[n4];
                        types.addAll(Arrays.asList(iCompilationUnit.getTypes()));
                        ++n4;
                    }
                }
                ++n2;
            }
            for (IType iType : types) {
                if (!iType.getFullyQualifiedName().equals(message.substring("AcceleoParserInfo.SERVICE_INVOCATION".length()))) continue;
                type = iType;
            }
            BundleDescription bundleDescription = null;
            if (type != null && PluginRegistry.findModel((IProject)iProject) != null) {
                found = true;
                projectName = iProject.getName();
                IPluginModelBase plugin = PluginRegistry.findModel((IProject)iProject);
                bundleDescription = plugin.getBundleDescription();
            }
            if (type == null || PluginRegistry.findModel((IProject)iProject) == null || bundleDescription == null) continue;
            ExportPackageDescription[] exportPackageDescriptionArray = exportPackages = bundleDescription.getExportPackages();
            int n5 = exportPackages.length;
            int n6 = 0;
            while (n6 < n5) {
                ExportPackageDescription exportPackageDescription = exportPackageDescriptionArray[n6];
                if (exportPackageDescription.getName().equals(type.getPackageFragment().getElementName())) {
                    exported = true;
                }
                ++n6;
            }
        }
        if (found && !exported) {
            marker.setAttribute("message", (Object)AcceleoUIMessages.getString("AcceleoMarkerUtils.JavaServiceClassNotExported", message.substring("AcceleoParserInfo.SERVICE_INVOCATION".length()), projectName));
        } else {
            marker.delete();
        }
    }

    private static IMarker createMarker(String markerId, IFile file, String message) throws CoreException {
        IMarker marker = null;
        if (PROBLEM_MARKER_ID.equals(markerId) || WARNING_MARKER_ID.equals(markerId)) {
            marker = file.createMarker(markerId);
        } else if (INFO_MARKER_ID.equals(markerId)) {
            marker = message.startsWith("AcceleoParser.Info.TemplateOverride") ? file.createMarker(OVERRIDE_MARKER_ID) : (message.startsWith("AcceleoParserInfo.TODO") ? file.createMarker(TASK_MARKER_ID) : (message.startsWith("AcceleoParserInfo.FIXME") ? file.createMarker(TASK_MARKER_ID) : file.createMarker(INFO_MARKER_ID)));
        }
        return marker;
    }

    private static int determinePriority(String markerId, String message) {
        int priority = 2;
        if (INFO_MARKER_ID.equals(markerId) && message.startsWith("AcceleoParserInfo.TODO")) {
            priority = 1;
        }
        return priority;
    }
}

