/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.module.example;

import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.wizards.module.example.IAcceleoInitializationStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.JavaServicesUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaServicesWrapperInitializationStrategy
implements IAcceleoInitializationStrategy {
    private boolean shouldGenerateDocumentation;

    @Override
    public String getDescription() {
        return AcceleoUIMessages.getString("JavaServicesWrapperStrategy.Description");
    }

    @Override
    public String getInitialFileNameFilter() {
        return "*.java";
    }

    @Override
    public boolean forceMetamodelURI() {
        return false;
    }

    @Override
    public boolean forceMetamodelType() {
        return true;
    }

    @Override
    public boolean forceHasFile() {
        return true;
    }

    @Override
    public boolean forceHasMain() {
        return true;
    }

    @Override
    public boolean forceQuery() {
        return true;
    }

    @Override
    public boolean forceTemplate() {
        return false;
    }

    @Override
    public boolean forceDocumentation() {
        return false;
    }

    @Override
    public void configure(String moduleElementKind, boolean hasFileBlock, boolean isMain, boolean generateDocumentation) {
        this.shouldGenerateDocumentation = generateDocumentation;
    }

    @Override
    public String getContent(IFile exampleFile, String moduleName, List<String> metamodelURI, String metamodelFileType) {
        String defaultEncoding;
        StringBuilder buffer = new StringBuilder("");
        try {
            defaultEncoding = exampleFile != null ? exampleFile.getCharset() : "UTF-8";
        }
        catch (CoreException coreException) {
            defaultEncoding = "UTF-8";
        }
        buffer.append("[comment encoding = ");
        buffer.append(defaultEncoding);
        buffer.append(" /]\n");
        if (this.shouldGenerateDocumentation) {
            buffer.append("[**\n * The documentation of the module.\n */]\n");
        }
        buffer.append("[module " + moduleName + "('");
        int cpt = 1;
        for (String uri : metamodelURI) {
            buffer.append(uri);
            if (cpt < metamodelURI.size()) {
                buffer.append("', '");
            }
            ++cpt;
        }
        buffer.append("')/]\n\n");
        if (exampleFile != null && exampleFile.exists()) {
            buffer.append(this.createWrapper(exampleFile));
        }
        return buffer.toString();
    }

    private String createWrapper(IFile exampleFile) {
        StringBuilder buffer = new StringBuilder();
        IJavaElement javaElement = JavaCore.create((IFile)exampleFile);
        if (javaElement instanceof ICompilationUnit) {
            IType[] types;
            ICompilationUnit classFile = (ICompilationUnit)javaElement;
            try {
                types = classFile.getTypes();
            }
            catch (JavaModelException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
                types = new IType[]{};
            }
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType iType = iTypeArray[n2];
                try {
                    IMethod[] methods;
                    IMethod[] iMethodArray = methods = iType.getMethods();
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod iMethod = iMethodArray[n4];
                        if (Flags.isPublic((int)iMethod.getFlags())) {
                            buffer.append(JavaServicesUtils.createQuery(iType, iMethod, this.shouldGenerateDocumentation));
                        }
                        ++n4;
                    }
                }
                catch (JavaModelException e) {
                    AcceleoUIActivator.log((Exception)((Object)e), true);
                }
                ++n2;
            }
        }
        return buffer.toString();
    }
}

