/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.type;

import org.eclipse.acceleo.query.type.Any;
import org.eclipse.acceleo.query.type.JavaObjectType;
import org.eclipse.acceleo.query.type.Type;
import org.eclipse.acceleo.query.type.TypeId;

public class PrimitiveType
extends Type {
    public PrimitiveType(TypeId id) {
        super(id);
        switch (id) {
            case TYPE: 
            case INTEGER: 
            case REAL: 
            case BOOLEAN: 
            case STRING: {
                return;
            }
            case JAVAOBJECT: {
                if (this instanceof JavaObjectType) {
                    return;
                }
                throw new IllegalArgumentException("The specified type id ain't no primitive type id!");
            }
        }
        throw new IllegalArgumentException("The specified type id ain't no primitive type id!");
    }

    @Override
    public Type merge(Type type) {
        switch (type.getId()) {
            case PRIMITIVE: 
            case TYPE: 
            case JAVAOBJECT: 
            case INTEGER: 
            case REAL: 
            case BOOLEAN: 
            case STRING: 
            case COMPARABLE: {
                if (type.getId() == this.getId()) {
                    return this;
                }
                return new PrimitiveType(TypeId.PRIMITIVE);
            }
        }
        return new Any();
    }
}

