/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.doc.internal;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.doc.internal.AQLHelpContentUtils;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.ComparableServices;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.services.XPathServices;

public final class DocumentationGenerator {
    private static final String UTF8 = "UTF-8";
    private static final Class<?>[] STANDARD_SERVICE_PROVIDERS = new Class[]{AnyServices.class, BooleanServices.class, CollectionServices.class, ComparableServices.class, EObjectServices.class, NumberServices.class, ResourceServices.class, StringServices.class, XPathServices.class};

    private DocumentationGenerator() {
    }

    public static void main(String[] args) {
        File pluginFolder = new File(args[0]);
        System.out.println("Prepare the generation of the documentation for " + pluginFolder.getAbsolutePath());
        File documentationFolder = new File(pluginFolder, "pages");
        File indexHtmlFile = new File(documentationFolder, "index.html");
        StringBuffer buffer = AQLHelpContentUtils.computeToc(STANDARD_SERVICE_PROVIDERS);
        try {
            File tocFile = new File(pluginFolder, "toc.xml");
            System.out.println("Writing the content of toc.xml in " + tocFile.getAbsolutePath());
            Files.write((CharSequence)buffer, (File)tocFile, (Charset)Charset.forName(UTF8));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        try {
            List<StringBuffer> sections = AQLHelpContentUtils.computeAQLOverviewSections(STANDARD_SERVICE_PROVIDERS);
            StringBuffer stringBuffer = AQLHelpContentUtils.html(AQLHelpContentUtils.head(), AQLHelpContentUtils.body(AQLHelpContentUtils.header(true), sections));
            System.out.println("Writing content of " + indexHtmlFile.getAbsolutePath());
            Files.write((CharSequence)stringBuffer, (File)indexHtmlFile, (Charset)Charset.forName(UTF8));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        Class<?>[] classArray = STANDARD_SERVICE_PROVIDERS;
        int n = STANDARD_SERVICE_PROVIDERS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> serviceProviderClass = classArray[n2];
            if (serviceProviderClass.isAnnotationPresent(ServiceProvider.class)) {
                try {
                    List<StringBuffer> sections = AQLHelpContentUtils.computeServiceSections(serviceProviderClass);
                    StringBuffer stringBuffer = AQLHelpContentUtils.html(AQLHelpContentUtils.head(), AQLHelpContentUtils.body(AQLHelpContentUtils.header(false), sections));
                    File file = new File(documentationFolder, "aql_service_" + serviceProviderClass.getSimpleName().toLowerCase() + ".html");
                    System.out.println("Writing content of " + file.getAbsolutePath());
                    Files.write((CharSequence)stringBuffer, (File)file, (Charset)Charset.forName(UTF8));
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
    }
}

