/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.SplitExpression;
import org.eclipse.acceleo.ui.interpreter.language.SubExpression;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class CompleteOCLExpressionSplittingTask
implements Callable<SplitExpression> {
    private EvaluationContext context;
    private final MetamodelManager metamodelManager;
    private final CompleteModel completeModel;

    public CompleteOCLExpressionSplittingTask(EvaluationContext context, EnvironmentFactory environmentFactory) {
        this.context = context;
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.completeModel = environmentFactory.getCompleteModel();
    }

    @Override
    public SplitExpression call() throws Exception {
        this.checkCancelled();
        CompilationResult compilationResult = this.context.getCompilationResult();
        if (compilationResult == null || compilationResult.getStatus() != null && compilationResult.getStatus().getSeverity() != 0) {
            return null;
        }
        Object expression = compilationResult.getCompiledExpression();
        SplitExpression result = expression instanceof Model ? this.splitCompleteOCLExpression((Model)expression) : null;
        return result;
    }

    private SplitExpression splitCompleteOCLExpression(Model root) {
        ArrayList<SubExpression> children = new ArrayList<SubExpression>();
        for (Package pack : root.getOwnedPackages()) {
            this.checkCancelled();
            children.add(this.splitCompleteOCLExpression(pack));
        }
        return new SplitExpression((Object)root, children, "All Expressions");
    }

    private SubExpression splitCompleteOCLExpression(Package pack) {
        SubExpression packageStep = new SubExpression((Object)pack, "Package - " + pack.getName());
        LinkedHashMap<Class, LinkedHashSet<Class>> types = new LinkedHashMap<Class, LinkedHashSet<Class>>();
        for (Class clazz : pack.getOwnedClasses()) {
            Class key = this.completeModel.getCompleteClass((Type)clazz).getPrimaryClass();
            LinkedHashSet<Class> relatedTypes = (LinkedHashSet<Class>)types.get(key);
            if (relatedTypes == null) {
                relatedTypes = new LinkedHashSet<Class>();
                types.put(key, relatedTypes);
            }
            relatedTypes.add(clazz);
        }
        this.checkCancelled();
        for (Map.Entry entry : types.entrySet()) {
            this.checkCancelled();
            packageStep.addSubStep(this.splitCompleteOCLExpression(entry));
        }
        for (Constraint constraint : pack.getOwnedConstraints()) {
            this.checkCancelled();
            packageStep.addSubStep(this.splitCompleteOCLExpression(constraint));
        }
        return packageStep;
    }

    private SubExpression splitCompleteOCLExpression(Map.Entry<Class, Set<Class>> relatedTypes) {
        SubExpression typeStep = new SubExpression((Object)relatedTypes.getKey(), "Context - " + relatedTypes.getKey());
        for (Class type : relatedTypes.getValue()) {
            this.checkCancelled();
            for (Constraint constraint : type.getOwnedInvariants()) {
                this.checkCancelled();
                typeStep.addSubStep(this.splitCompleteOCLExpression(constraint));
            }
            for (Operation operation : type.getOwnedOperations()) {
                this.checkCancelled();
                if (operation.getParameterTypes().get().length != 0) continue;
                typeStep.addSubStep(this.splitCompleteOCLExpression(operation));
            }
        }
        return typeStep;
    }

    private SubExpression splitCompleteOCLExpression(Constraint constraint) {
        SubExpression constraintSteps = new SubExpression((Object)constraint, "Constraint - " + constraint.getName());
        try {
            LanguageExpression spec = constraint.getOwnedSpecification();
            ExpressionInOCL expressionInOCL = this.metamodelManager.parseSpecification(spec);
            constraintSteps.addSubStep(this.splitExpression(expressionInOCL));
            return constraintSteps;
        }
        catch (ParserException parserException) {
            return constraintSteps;
        }
    }

    private SubExpression splitCompleteOCLExpression(Operation operation) {
        SubExpression operationSteps = new SubExpression((Object)operation, "Operation - " + operation.getName());
        try {
            LanguageExpression spec = operation.getBodyExpression();
            ExpressionInOCL expressionInOCL = this.metamodelManager.parseSpecification(spec);
            operationSteps.addSubStep(this.splitExpression(expressionInOCL));
            return operationSteps;
        }
        catch (ParserException parserException) {
            return operationSteps;
        }
    }

    private SubExpression splitExpression(ExpressionInOCL expression) {
        SplittingVisitor visitor = new SplittingVisitor(expression);
        visitor.visitExpressionInOCL(expression);
        SubExpression expressionStep = new SubExpression((Object)expression);
        for (SubExpression subStep : visitor.getSubExpressions()) {
            expressionStep.addSubStep(subStep);
        }
        return expressionStep;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }

    private static class SplittingVisitor
    extends AbstractExtendingVisitor<SubExpression, ExpressionInOCL> {
        private LinkedList<SubExpression> expressionStack = new LinkedList();

        public SplittingVisitor(ExpressionInOCL expressionInOCL) {
            super((Object)expressionInOCL);
        }

        public SubExpression visitExpressionInOCL(ExpressionInOCL object) {
            this.expressionStack.addFirst(new SubExpression((Object)object.getOwnedBody()));
            return (SubExpression)object.getOwnedBody().accept((Visitor)this);
        }

        public SubExpression visiting(Visitable visitable) {
            return null;
        }

        public SubExpression visitOperationCallExp(OperationCallExp object) {
            for (OCLExpression expression : object.getOwnedArguments()) {
                this.addAndVisitSubStep(expression);
            }
            SubExpression result = (SubExpression)super.visitOperationCallExp(object);
            return result;
        }

        public SubExpression visitLetExp(LetExp object) {
            this.addChild(new SubExpression((Object)object));
            object.getOwnedVariable().accept((Visitor)this);
            return this.addAndVisitSubStep(object.getOwnedIn());
        }

        public SubExpression visitVariable(Variable object) {
            return this.addAndVisitSubStep(object.getOwnedInit());
        }

        public SubExpression visitIfExp(IfExp object) {
            this.addChild(new SubExpression((Object)object));
            SubExpression result = (SubExpression)super.visitIfExp(object);
            this.addAndVisitSubStep(object.getOwnedCondition());
            this.addAndVisitSubStep(object.getOwnedThen());
            this.addAndVisitSubStep(object.getOwnedElse());
            return result;
        }

        public SubExpression visitVariableExp(VariableExp object) {
            this.addChild(new SubExpression((Object)object));
            return (SubExpression)super.visitVariableExp(object);
        }

        public SubExpression visitLiteralExp(LiteralExp object) {
            this.addChild(new SubExpression((Object)object));
            return (SubExpression)super.visitLiteralExp(object);
        }

        public SubExpression visitCallExp(CallExp object) {
            this.addChild(new SubExpression((Object)object));
            return this.addAndVisitSubStep(object.getOwnedSource());
        }

        public List<SubExpression> getSubExpressions() {
            return this.expressionStack.pop().getSubSteps();
        }

        private SubExpression addAndVisitSubStep(OCLExpression subStep) {
            SubExpression subExpression = new SubExpression((Object)subStep);
            this.addChild(subExpression);
            this.expressionStack.addFirst(subExpression);
            subStep.accept((Visitor)this);
            this.expressionStack.pop();
            return subExpression;
        }

        private void addChild(SubExpression subExpression) {
            SubExpression parent = this.expressionStack.peek();
            if (!parent.getExpression().equals(subExpression.getExpression())) {
                parent.addSubStep(subExpression);
            }
        }
    }
}

