/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.interpreter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.interpreter.AcceleoSourceViewer;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoParserInfo;
import org.eclipse.acceleo.parser.AcceleoParserInfos;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoParserWarning;
import org.eclipse.acceleo.parser.AcceleoParserWarnings;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.InterpreterContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.ecore.CollectionItem;
import org.eclipse.ocl.utilities.ASTNode;

public class AcceleoCompilationTask
implements Callable<CompilationResult> {
    private AcceleoSourceViewer acceleoSource;
    private final InterpreterContext context;

    public AcceleoCompilationTask(AcceleoSourceViewer acceleoSource, InterpreterContext context) {
        this.acceleoSource = acceleoSource;
        this.context = context;
    }

    private static IFile findChild(IContainer container, String fileName) {
        IFile result = null;
        try {
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length && result == null) {
                IResource child = members[i];
                if (child instanceof IContainer) {
                    result = AcceleoCompilationTask.findChild((IContainer)child, fileName);
                } else if (child instanceof IFile && child.getName().equals(fileName)) {
                    result = (IFile)child;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return result;
    }

    private static Resource getModule(IFile moduleFile, ResourceSet resourceSet) {
        IProject project;
        IFile compiledModule = null;
        if ("mtl".equals(moduleFile.getFileExtension()) && (project = moduleFile.getProject()) != null) {
            String compiledName = moduleFile.getFullPath().removeFileExtension().addFileExtension("emtl").lastSegment();
            compiledModule = AcceleoCompilationTask.findChild((IContainer)project, compiledName);
        }
        Resource module = null;
        if (compiledModule != null) {
            String path = compiledModule.getFullPath().toString();
            for (Resource resource : resourceSet.getResources()) {
                if (!resource.getURI().toString().equals(path)) continue;
                return resource;
            }
            try {
                module = ModelUtils.load((URI)URI.createPlatformResourceURI((String)path, (boolean)true), (ResourceSet)resourceSet).eResource();
            }
            catch (IOException iOException) {}
        }
        return module;
    }

    @Override
    public CompilationResult call() throws Exception {
        this.checkCancelled();
        String fullExpression = this.acceleoSource.rebuildFullExpression(this.context);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = ModelUtils.createResource((URI)URI.createURI((String)"http://acceleo.eclipse.org/default.emtl"), (ResourceSet)resourceSet);
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(new StringBuffer(fullExpression));
        ArrayList<URI> dependencies = new ArrayList<URI>();
        if (this.acceleoSource.getModuleImport() != null) {
            dependencies.addAll(this.computeImportList(this.acceleoSource.getModuleImport(), (ResourceSet)resourceSet));
        }
        AcceleoParser parser = new AcceleoParser();
        parser.parse(source, resource, dependencies);
        this.checkCancelled();
        ASTNode selectedNode = null;
        if (!resource.getContents().isEmpty()) {
            Module module = (Module)resource.getContents().get(0);
            ISelection selection = this.context.getSelection();
            if (selection instanceof ITextSelection && ((ITextSelection)selection).getLength() > 0) {
                ITextSelection textSelection = (ITextSelection)selection;
                int startOffset = textSelection.getOffset() + this.acceleoSource.getGap();
                int endOffset = startOffset + textSelection.getLength();
                if (textSelection.getText().startsWith("[")) {
                    ++startOffset;
                }
                if (textSelection.getText().endsWith("/]")) {
                    endOffset -= 2;
                }
                selectedNode = this.getChildrenCandidate((EObject)module, startOffset, endOffset);
                if (textSelection.getLength() == 0) {
                    while (selectedNode != null && !(selectedNode instanceof ModuleElement)) {
                        selectedNode = (ASTNode)selectedNode.eContainer();
                    }
                }
            }
            if (selectedNode == null && module != null && !module.getOwnedModuleElement().isEmpty()) {
                selectedNode = (ASTNode)module.getOwnedModuleElement().get(0);
            }
        }
        this.checkCancelled();
        IStatus problems = this.parseProblems(source.getProblems(), source.getWarnings(), source.getInfos());
        return new CompilationResult(selectedNode, problems);
    }

    public Set<URI> computeImportList(IFile initialImport, ResourceSet resourceSet) {
        Resource moduleImport = AcceleoCompilationTask.getModule(initialImport, resourceSet);
        if (moduleImport != null) {
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
        }
        LinkedHashSet<URI> dependencies = new LinkedHashSet<URI>();
        for (Resource res : resourceSet.getResources()) {
            dependencies.add(res.getURI());
        }
        return dependencies;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }

    private ASTNode getChildrenCandidate(EObject candidate, int posBegin, int posEnd) {
        ASTNode child = null;
        for (EObject eContent : candidate.eContents()) {
            ASTNode astNode = null;
            if (eContent instanceof ASTNode) {
                astNode = (ASTNode)eContent;
            } else if (eContent instanceof CollectionItem) {
                astNode = ((CollectionItem)eContent).getItem();
            }
            if (astNode == null) continue;
            int startPosition = astNode.getStartPosition();
            int endPosition = astNode.getEndPosition();
            if (startPosition <= -1 || endPosition <= -1 || startPosition > posBegin || endPosition < posEnd) continue;
            ASTNode childCandidate = this.getChildrenCandidate((EObject)astNode, posBegin, posEnd);
            if (childCandidate != null) {
                child = childCandidate;
                break;
            }
            child = astNode;
            break;
        }
        return child;
    }

    private IStatus parseProblems(AcceleoParserProblems errors, AcceleoParserWarnings warnings, AcceleoParserInfos infos) {
        ArrayList<Status> problems = new ArrayList<Status>();
        for (AcceleoParserProblem error : errors.getList()) {
            problems.add(new Status(4, "org.eclipse.acceleo.ide.ui", error.getMessage()));
        }
        for (AcceleoParserWarning warning : warnings.getList()) {
            problems.add(new Status(2, "org.eclipse.acceleo.ide.ui", warning.getMessage()));
        }
        for (AcceleoParserInfo info : infos.getList()) {
            problems.add(new Status(1, "org.eclipse.acceleo.ide.ui", info.getMessage()));
        }
        if (problems.isEmpty()) {
            return null;
        }
        MultiStatus status = new MultiStatus("org.eclipse.acceleo.ide.ui", 1, AcceleoUIMessages.getString("acceleo.interpreter.compilation.issue"), null);
        for (IStatus iStatus : problems) {
            status.add(iStatus);
        }
        return status;
    }
}

