/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.equinox;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.equinox.internal.AcceleoEquinoxLauncherPlugin;
import org.eclipse.acceleo.equinox.internal.AcceleoGeneratorRunner;
import org.eclipse.acceleo.equinox.internal.EMFCodeGenRunner;
import org.eclipse.acceleo.equinox.internal.LaunchConfigurationRunner;
import org.eclipse.acceleo.equinox.internal.WorkspaceHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;

public class AcceleoLauncher
implements IApplication {
    private static final String GENERATE_PREFIX = "generate:";
    private static final String LAUNCH_PREFIX = "launch:";
    private static final int DEFAULT_JOBS_TIMEOUT = 200;
    private static final Integer APPLICATION_ERROR = -1;
    private static final String EMF_CODEGEN = "org.eclipse.emf.codegen.ecore/org.eclipse.emf.codegen.ecore.generator.Generator";
    @Option(name="-models", usage="Specify the model to use as inputs of the generation. Relative paths might be used or absolute uris to target the host environment like platform:/resource/someProject/model/someModel.ecore for instance.", metaVar="INPUT", handler=StringArrayOptionHandler.class)
    private String[] models = new String[0];
    @Option(name="-actions", usage="Specify the actions to execute, for instance generate:org.generator.plugin.id/org.generator.plugin.class.name to launch a code generation.", handler=StringArrayOptionHandler.class)
    private String[] actions = new String[0];
    @Option(name="-projects-paths", usage="Specify paths to search for project and import those in the workspace.", metaVar="INPUT", handler=StringArrayOptionHandler.class)
    private String[] projectSearchPaths = new String[]{System.getProperty("user.dir")};
    @Option(name="-parameters", usage="Parameters to pass to the generators.", handler=StringArrayOptionHandler.class)
    private String[] generatorParameters = new String[0];
    @Option(name="-output", usage="Specifiy the root folder to generate to, default is the application working folder.", metaVar="OUTPUT")
    private File output = new File(System.getProperty("user.dir"));
    @Option(name="-jobs-wait-timeout", usage="Specify the duration before timeout when waiting for eclipse Jobs completion.")
    private int jobsWaitTimeout = 200;
    @Option(name="-data", usage="Specify the folder which will keep the workspace.", metaVar="FOLDER")
    private File dataFolder;
    @Option(name="-consoleLog", usage="Log messages in the console.")
    private boolean consoleLog;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        this.info("Workspace location is : " + Platform.getInstanceLocation().getURL() + " use -data to change it.");
        return new AcceleoLauncher().doMain(args);
    }

    public Object doMain(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        boolean somethingWentWrong = false;
        try {
            parser.parseArgument(args);
            this.validateArguments();
            BasicMonitor.Printing monitor = new BasicMonitor.Printing(System.out);
            AcceleoPreferences.switchForceDeactivationNotifications((boolean)true);
            WorkspaceHandler wks = new WorkspaceHandler();
            if (this.projectSearchPaths.length > 0) {
                wks.clearWorkspace((Monitor)monitor);
                String[] stringArray = this.projectSearchPaths;
                int n = this.projectSearchPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String rootFolder = stringArray[n2];
                    wks.importProjectsInWorkspace(rootFolder, (Monitor)monitor);
                    ++n2;
                }
            }
            ResourceSetImpl set = new ResourceSetImpl();
            ArrayList<URI> modelURIS = new ArrayList<URI>();
            String[] stringArray = this.models;
            int n = this.models.length;
            int n3 = 0;
            while (n3 < n) {
                String modelPath = stringArray[n3];
                URI rawURI = null;
                try {
                    rawURI = URI.createURI((String)modelPath, (boolean)true);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (rawURI != null && !rawURI.hasAbsolutePath()) {
                    rawURI = URI.createFileURI((String)modelPath);
                }
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n4 = iProjectArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IProject prj = iProjectArray[n5];
                    try {
                        prj.open(BasicMonitor.toIProgressMonitor((Monitor)monitor));
                        prj.refreshLocal(2, BasicMonitor.toIProgressMonitor((Monitor)monitor));
                    }
                    catch (CoreException e) {
                        AcceleoEquinoxLauncherPlugin.INSTANCE.log((Object)e);
                    }
                    ++n5;
                }
                int secondsWaiting = 0;
                while (!Job.getJobManager().isIdle() && secondsWaiting <= this.jobsWaitTimeout) {
                    try {
                        Job currentJob = Job.getJobManager().currentJob();
                        String jobName = "unknown";
                        ISchedulingRule currentrule = Job.getJobManager().currentRule();
                        if (currentrule != null) {
                            jobName = currentrule.toString();
                        }
                        if (currentJob != null && (jobName = currentJob.getName()) == null) {
                            jobName = currentJob.getClass().getCanonicalName();
                        }
                        this.info("Waiting for Job termination : " + jobName);
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        AcceleoEquinoxLauncherPlugin.INSTANCE.log(e);
                    }
                    ++secondsWaiting;
                }
                if (set.getURIConverter().exists(rawURI, Collections.EMPTY_MAP)) {
                    modelURIS.add(rawURI);
                } else {
                    somethingWentWrong = true;
                    if (rawURI != null) {
                        AcceleoEquinoxLauncherPlugin.INSTANCE.log(new Status(4, AcceleoEquinoxLauncherPlugin.INSTANCE.getSymbolicName(), "File " + modelPath + " does not exist or is not accessible through the URI:" + rawURI.toString()));
                    } else {
                        AcceleoEquinoxLauncherPlugin.INSTANCE.log(new Status(4, AcceleoEquinoxLauncherPlugin.INSTANCE.getSymbolicName(), "File " + modelPath + " does not exist."));
                    }
                }
                ++n3;
            }
            stringArray = this.actions;
            n = this.actions.length;
            n3 = 0;
            while (n3 < n) {
                String action = stringArray[n3];
                if (action.startsWith(GENERATE_PREFIX)) {
                    String generatorsFullName = action.substring(GENERATE_PREFIX.length());
                    if (EMF_CODEGEN.equals(generatorsFullName)) {
                        EMFCodeGenRunner eGen = new EMFCodeGenRunner();
                        try {
                            eGen.generateAll(modelURIS, (Monitor)monitor);
                        }
                        catch (CoreException e) {
                            somethingWentWrong = true;
                            AcceleoEquinoxLauncherPlugin.INSTANCE.log(new Status(4, AcceleoEquinoxLauncherPlugin.INSTANCE.getSymbolicName(), "Error launching EMF Codegen", (Throwable)e));
                        }
                    } else {
                        try {
                            new AcceleoGeneratorRunner(this.output, this.generatorParameters).launchAcceleoGenerator((Monitor)monitor, modelURIS, generatorsFullName);
                        }
                        catch (RuntimeException runtimeException) {
                            somethingWentWrong = true;
                        }
                    }
                    if (this.projectSearchPaths.length > 0) {
                        wks.clearWorkspace((Monitor)monitor);
                    }
                } else if (action.startsWith(LAUNCH_PREFIX)) {
                    String launchConfigurationPath = action.substring(LAUNCH_PREFIX.length());
                    try {
                        new LaunchConfigurationRunner().launch(launchConfigurationPath, BasicMonitor.toIProgressMonitor((Monitor)monitor));
                    }
                    catch (CoreException e) {
                        somethingWentWrong = true;
                        AcceleoEquinoxLauncherPlugin.INSTANCE.log(new Status(4, AcceleoEquinoxLauncherPlugin.INSTANCE.getSymbolicName(), "Error launching the " + launchConfigurationPath + " file.", (Throwable)e));
                    }
                }
                ++n3;
            }
        }
        catch (CmdLineException e) {
            AcceleoEquinoxLauncherPlugin.INSTANCE.log(new Status(4, AcceleoEquinoxLauncherPlugin.INSTANCE.getSymbolicName(), e.getMessage(), (Throwable)e));
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            somethingWentWrong = true;
        }
        if (somethingWentWrong) {
            return APPLICATION_ERROR;
        }
        return IApplication.EXIT_OK;
    }

    private void validateArguments() throws CmdLineException {
        boolean hasGenerator = false;
        String[] stringArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.startsWith(GENERATE_PREFIX)) {
                hasGenerator = true;
            }
            ++n2;
        }
        if (hasGenerator && (this.models == null || this.models.length == 0)) {
            throw new CmdLineException("The -models flag is required when launching a generator.");
        }
    }

    private void info(String message) {
        AcceleoEquinoxLauncherPlugin.INSTANCE.log(new Status(1, AcceleoEquinoxLauncherPlugin.INSTANCE.getSymbolicName(), message));
    }

    public void stop() {
    }
}

