/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.LSPDocumentAbstractHandler;
import org.eclipse.lsp4e.operations.rename.LSPRenameProcessor;
import org.eclipse.lsp4e.operations.rename.LSPRenameRefactoringWizard;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPRenameHandler
extends LSPDocumentAbstractHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute(ExecutionEvent event, ITextEditor textEditor) {
        ISelection iSelection;
        ISelectionProvider provider = textEditor.getSelectionProvider();
        if (provider != null && (iSelection = provider.getSelection()) instanceof ITextSelection) {
            IDocument document;
            void textSelection;
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
            if (!textSelection.isEmpty() && (document = LSPEclipseUtils.getDocument(textEditor)) != null) {
                IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
                Shell shell = part.getSite().getShell();
                LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getRenameProvider);
                if (executor.anyMatching()) {
                    int offset = textSelection.getOffset();
                    LSPRenameProcessor processor = new LSPRenameProcessor(document, offset);
                    ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
                    LSPRenameRefactoringWizard wizard = new LSPRenameRefactoringWizard((Refactoring)refactoring);
                    RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                    shell.getDisplay().asyncExec(() -> {
                        try {
                            operation.run(shell, Messages.rename_title);
                        }
                        catch (InterruptedException e1) {
                            LanguageServerPlugin.logError(e1);
                            Thread.currentThread().interrupt();
                        }
                    });
                }
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        this.setEnabled(ServerCapabilities::getRenameProvider, this::hasSelection);
    }
}

