/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.completion.proposals;

import java.util.StringJoiner;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.evaluation.TemplateService;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.query.parser.AstSerializer;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceCompletionProposal;

public class TemplateServiceCompletionProposal
implements IServiceCompletionProposal {
    private final TemplateService service;
    private final AstSerializer aqlSerializer = new AstSerializer();
    private final AcceleoAstSerializer accleeoSerializer = new AcceleoAstSerializer("");

    public TemplateServiceCompletionProposal(TemplateService templateService) {
        this.service = templateService;
    }

    public String getProposal() {
        return this.service.getName() + "()";
    }

    public int getCursorOffset() {
        int namelength = this.service.getName().length();
        if (this.service.getNumberOfParameters() == 1) {
            return namelength + 2;
        }
        return namelength + 1;
    }

    public String getDescription() {
        StringBuilder res = new StringBuilder();
        res.append(String.valueOf((Object)((Template)this.service.getOrigin()).getVisibility()) + " " + ((Template)this.service.getOrigin()).getName());
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Variable parameter : ((Template)this.service.getOrigin()).getParameters()) {
            joiner.add(this.accleeoSerializer.serialize(parameter));
        }
        res.append(joiner.toString());
        res.append(" = String");
        if (((Template)this.service.getOrigin()).getDocumentation() != null) {
            res.append("\n");
            res.append(((Template)this.service.getOrigin()).getDocumentation().getBody().getValue());
        }
        return res.toString();
    }

    public IService<?> getObject() {
        return this.service;
    }
}

