/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class AcceleoUtil {
    public static final String LANGUAGE_NAME = "org.eclipse.acceleo.aql";
    public static final String NEW_LINE_OPTION = "newLine";
    public static final String LOG_URI_OPTION = "logURI";
    private static final String SELF = "self";

    private AcceleoUtil() {
    }

    public static String getTemplateImplicitVariableName() {
        return SELF;
    }

    public static List<Template> getMainTemplates(Module module) {
        ArrayList<Template> res = new ArrayList<Template>();
        for (ModuleElement moduleElement : module.getModuleElements()) {
            if (!(moduleElement instanceof Template) || !((Template)moduleElement).isMain()) continue;
            res.add((Template)moduleElement);
        }
        return res;
    }

    public static void generate(AcceleoEvaluator evaluator, IQualifiedNameQueryEnvironment queryEnvironment, Module module, Resource model, IAcceleoGenerationStrategy generationStrategy, URI destination, URI logURI, Monitor monitor) {
        AcceleoUtil.generate(evaluator, queryEnvironment, module, Collections.singletonList(model), generationStrategy, destination, logURI, monitor);
    }

    public static void generate(AcceleoEvaluator evaluator, IQualifiedNameQueryEnvironment queryEnvironment, Module module, ResourceSet resourceSet, IAcceleoGenerationStrategy generationStrategy, URI destination, URI logURI, Monitor monitor) {
        AcceleoUtil.generate(evaluator, queryEnvironment, module, (List<Resource>)resourceSet.getResources(), generationStrategy, destination, logURI, monitor);
    }

    public static void generate(AcceleoEvaluator evaluator, IQualifiedNameQueryEnvironment queryEnvironment, Module module, List<Resource> resources, IAcceleoGenerationStrategy generationStrategy, URI destination, URI logURI, Monitor monitor) {
        HashMap<EClass, List<EObject>> valuesCache = new HashMap<EClass, List<EObject>>();
        List<Template> mainTemplates = AcceleoUtil.getMainTemplates(module);
        monitor.beginTask("Generating", mainTemplates.size() * (resources.size() + 1));
        try {
            for (Template main : mainTemplates) {
                monitor.subTask("Loading model elements for " + main.getName());
                EClassifierTypeLiteral eClassifierTypeLiteral = (EClassifierTypeLiteral)((Variable)main.getParameters().get(0)).getType().getAst();
                List<EObject> values = AcceleoUtil.getValues((TypeLiteral)eClassifierTypeLiteral, queryEnvironment, resources, valuesCache, monitor);
                monitor.subTask("Generating for " + main.getName());
                String parameterName = ((Variable)main.getParameters().get(0)).getName();
                LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
                for (EObject value : values) {
                    variables.put(parameterName, value);
                    AcceleoUtil.generate(main, variables, evaluator, queryEnvironment, generationStrategy, destination, logURI, monitor);
                    if (monitor.isCanceled()) break;
                }
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void generate(Template template, Map<String, Object> variables, AcceleoEvaluator evaluator, IQualifiedNameQueryEnvironment queryEnvironment, IAcceleoGenerationStrategy generationStrategy, URI destination, URI logURI, Monitor monitor) {
        block17: {
            generationStrategy.start(destination);
            String moduleQualifiedName = queryEnvironment.getLookupEngine().getResolver().getQualifiedName((Object)AcceleoUtil.getContainingModule(template));
            queryEnvironment.getLookupEngine().pushImportsContext(moduleQualifiedName, moduleQualifiedName);
            monitor.subTask(moduleQualifiedName);
            try {
                try {
                    evaluator.generate(template, variables, generationStrategy, destination, monitor);
                }
                catch (AcceleoEvaluationCancelledException acceleoEvaluationCancelledException) {
                    queryEnvironment.getLookupEngine().popContext(moduleQualifiedName);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                queryEnvironment.getLookupEngine().popContext(moduleQualifiedName);
                throw throwable;
            }
            queryEnvironment.getLookupEngine().popContext(moduleQualifiedName);
        }
        if (logURI != null && evaluator.getGenerationResult().getDiagnostic().getSeverity() != 0) {
            try {
                Throwable throwable = null;
                Object var10_14 = null;
                try (IAcceleoWriter logWriter = generationStrategy.createWriterForLog(logURI, StandardCharsets.UTF_8, evaluator.getNewLine());){
                    AcceleoUtil.printDiagnostic(logWriter, evaluator.getGenerationResult().getDiagnostic(), "", evaluator.getNewLine());
                    AcceleoUtil.printSummary(logWriter, evaluator.getGenerationResult(), evaluator.getNewLine());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        generationStrategy.terminate();
    }

    public static List<EObject> getValues(TypeLiteral type, IQualifiedNameQueryEnvironment queryEnvironment, List<Resource> resources, Map<EClass, List<EObject>> valuesCache, Monitor monitor) {
        List res;
        EClassifierTypeLiteral eClassifierTypeLiteral = (EClassifierTypeLiteral)type;
        Set eClassifiers = queryEnvironment.getEPackageProvider().getTypes(eClassifierTypeLiteral.getEPackageName(), eClassifierTypeLiteral.getEClassifierName());
        if (!eClassifiers.isEmpty()) {
            EObjectServices services = new EObjectServices((IReadOnlyQueryEnvironment)queryEnvironment, null, null);
            EClass parameterType = (EClass)eClassifiers.iterator().next();
            res = valuesCache.computeIfAbsent(parameterType, t -> {
                ArrayList<EObject> values = new ArrayList<EObject>();
                for (Resource model : resources) {
                    monitor.subTask("Loading model elements form " + String.valueOf(model.getURI()));
                    for (EObject root : model.getContents()) {
                        if (parameterType.isInstance((Object)root)) {
                            values.add(root);
                        }
                        values.addAll(services.eAllContents(root, t));
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                }
                return values;
            });
        } else {
            monitor.worked(resources.size());
            res = Collections.emptyList();
        }
        return res;
    }

    private static void printDiagnostic(IAcceleoWriter writer, Diagnostic diagnostic, String indentation, String newLine) {
        Object nextIndentation = indentation;
        if (diagnostic.getMessage() != null) {
            writer.append(indentation);
            switch (diagnostic.getSeverity()) {
                case 1: {
                    writer.append("INFO ");
                    break;
                }
                case 2: {
                    writer.append("WARNING ");
                    break;
                }
                case 4: {
                    writer.append("ERROR ");
                }
            }
            if (!diagnostic.getData().isEmpty() && diagnostic.getData().get(0) instanceof ASTNode) {
                writer.append(AcceleoUtil.getLocation((ASTNode)diagnostic.getData().get(0)));
            }
            writer.append(": ");
            writer.append(diagnostic.getMessage().replaceAll("\n", "\n" + (String)nextIndentation) + newLine);
            nextIndentation = (String)nextIndentation + "\t";
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            AcceleoUtil.printDiagnostic(writer, child, (String)nextIndentation, newLine);
        }
    }

    private static void printSummary(IAcceleoWriter writer, GenerationResult result, String newLine) {
        int nbErrors = 0;
        int nbWarnings = 0;
        int nbInfos = 0;
        for (Diagnostic diagnostic : result.getDiagnostic().getChildren()) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    ++nbErrors;
                    break;
                }
                case 2: {
                    ++nbWarnings;
                    break;
                }
                case 1: {
                    ++nbInfos;
                    break;
                }
            }
        }
        String message = "Files: " + result.getGeneratedFiles().size() + ", Lost Files: " + result.getLostFiles().size() + ", Errors: " + nbErrors + ", Warnings: " + nbWarnings + ", Infos: " + nbInfos + ".";
        writer.append(message + newLine);
    }

    public static String getLocation(ASTNode astNode) {
        Module module = AcceleoUtil.getContainingModule(astNode);
        return module.eResource().getURI().toString().substring("acceleoenv::".length()) + " L" + (module.getAst().getStartLine(astNode) + 1);
    }

    public static String getContent(InputStream stream, String charsetName) throws IOException {
        int len = 8192;
        StringBuilder res = new StringBuilder(8192);
        String localCharsetName = charsetName != null ? charsetName : StandardCharsets.UTF_8.name();
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(stream), localCharsetName);){
            char[] buffer = new char[8192];
            int length = input.read(buffer);
            while (length != -1) {
                res.append(buffer, 0, length);
                length = input.read(buffer);
            }
            input.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res.toString();
    }

    public static ModuleElement getContainingModuleElement(ASTNode node) {
        return (ModuleElement)AcceleoUtil.getContainer((EObject)node, n -> n instanceof ModuleElement);
    }

    public static Statement getContainingStatement(ASTNode node) {
        return (Statement)AcceleoUtil.getContainer((EObject)node, n -> n instanceof Statement);
    }

    public static Module getContainingModule(ASTNode node) {
        return (Module)AcceleoUtil.getContainer((EObject)node, n -> n instanceof Module);
    }

    private static EObject getContainer(EObject eObject, Predicate<EObject> predicate) {
        EObject res = null;
        EObject current = eObject.eContainer();
        while (current != null) {
            if (predicate.test(current)) {
                res = current;
                break;
            }
            current = current.eContainer();
        }
        return res;
    }

    public static IQualifiedNameQueryEnvironment newAcceleoQueryEnvironment(Map<String, String> options, IQualifiedNameResolver resolver, ResourceSet resourceSetForModels, boolean forWorkspace) {
        return AQLUtils.newQualifiedNameEnvironmentDefaultServices((String)LANGUAGE_NAME, options, (IQualifiedNameResolver)resolver, (ResourceSet)resourceSetForModels, (boolean)forWorkspace);
    }

    public static void registerEPackage(IQualifiedNameQueryEnvironment environment, IQualifiedNameResolver resolver, Module main) {
        for (EPackage ePkg : AcceleoUtil.getAllNeededEPackages(resolver, main)) {
            AcceleoUtil.registerEPackage(environment, ePkg);
        }
    }

    private static void registerEPackage(IQualifiedNameQueryEnvironment environment, EPackage ePackage) {
        environment.registerEPackage(ePackage);
        for (EPackage child : ePackage.getESubpackages()) {
            AcceleoUtil.registerEPackage(environment, child);
        }
    }

    public static void cleanServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels) {
        AQLUtils.cleanServices((String)LANGUAGE_NAME, (IReadOnlyQueryEnvironment)queryEnvironment, (ResourceSet)resourceSetForModels);
    }

    public static URI getlogURI(URI targetURI, String log) throws IllegalArgumentException {
        URI uri;
        URI res = log != null ? ((uri = URI.createURI((String)log)).isRelative() ? (targetURI.isRelative() ? targetURI.appendSegments(uri.segments()) : uri.resolve(targetURI)) : uri) : null;
        return res;
    }

    public static Set<Module> getAllNeededModules(IQualifiedNameResolver resolver, Module module) {
        LinkedHashSet<Module> addedModules;
        LinkedHashSet<Module> res = new LinkedHashSet<Module>();
        LinkedHashSet<Module> currentModules = new LinkedHashSet<Module>();
        res.add(module);
        currentModules.add(module);
        do {
            addedModules = new LinkedHashSet<Module>();
            for (Module currentModule : currentModules) {
                Object resolved;
                ModuleReference extds = currentModule.getExtends();
                if (extds != null && (resolved = resolver.resolve(extds.getQualifiedName())) instanceof Module && res.add(currentModule)) {
                    addedModules.add((Module)resolved);
                }
                for (Import imprt : currentModule.getImports()) {
                    Object resolved2 = resolver.resolve(imprt.getModule().getQualifiedName());
                    if (!(resolved2 instanceof Module) || !res.add((Module)resolved2)) continue;
                    addedModules.add((Module)resolved2);
                }
            }
        } while (!(currentModules = addedModules).isEmpty());
        return res;
    }

    public static Set<EPackage> getAllNeededEPackages(IQualifiedNameResolver resolver, Module module) {
        LinkedHashSet<EPackage> res = new LinkedHashSet<EPackage>();
        for (Module mod : AcceleoUtil.getAllNeededModules(resolver, module)) {
            for (Metamodel medamodel : mod.getMetamodels()) {
                res.add(medamodel.getReferencedPackage());
            }
        }
        return res;
    }
}

