/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.BlockComment;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.CommentBody;
import org.eclipse.acceleo.Documentation;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleDocumentation;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.NewLineStatement;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.parser.AstSerializer;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.EObject;

public class AcceleoAstSerializer
extends AcceleoSwitch<Object> {
    private static final String INDENTATION_SPACE = "  ";
    private static final Object DUMMY = new Object();
    private AstSerializer querySerializer = new AstSerializer();
    private String bindingSeparator;
    private StringBuilder builder;
    private String currentIndentation = "";
    private int currentBlockHeaderStartColumn;
    private final String newLine;

    public AcceleoAstSerializer(String newLine) {
        this.newLine = newLine;
    }

    public String serialize(AcceleoASTNode node) {
        this.builder = new StringBuilder();
        this.currentIndentation = "";
        this.updateCurrentBlockHeaderStartColumn();
        this.doSwitch(node);
        return this.builder.toString();
    }

    @Override
    public Object caseBinding(Binding binding) {
        String bindingName = AstBuilder.protectWithUnderscore((String)binding.getName());
        this.builder.append(bindingName);
        if (binding.getType() != null) {
            this.builder.append(" : ");
            this.builder.append(this.querySerializer.serialize(binding.getType().getAst()));
        }
        this.builder.append(" ");
        this.builder.append(this.bindingSeparator);
        this.builder.append(" ");
        this.doSwitch(binding.getInitExpression());
        return DUMMY;
    }

    @Override
    public Object caseBlock(Block block) {
        String savedIndentation = this.currentIndentation;
        try {
            int i;
            StringBuilder blockIndentation = new StringBuilder();
            if (block.isInlined()) {
                this.currentIndentation = "";
            } else {
                i = 0;
                while (i < this.currentBlockHeaderStartColumn) {
                    blockIndentation.append(" ");
                    ++i;
                }
                this.currentIndentation = block.getStatements().isEmpty() ? blockIndentation.toString() : blockIndentation.toString() + INDENTATION_SPACE;
                this.insertNewLine();
            }
            if (!block.getStatements().isEmpty()) {
                i = 0;
                while (i < block.getStatements().size() - 1) {
                    this.doSwitch((EObject)block.getStatements().get(i));
                    ++i;
                }
                this.currentIndentation = blockIndentation.toString();
                this.doSwitch((EObject)block.getStatements().get(block.getStatements().size() - 1));
            }
        }
        finally {
            this.currentIndentation = savedIndentation;
        }
        return DUMMY;
    }

    @Override
    public Object caseBlockComment(BlockComment blockComment) {
        this.builder.append("[comment]");
        this.doSwitch(blockComment.getBody());
        this.builder.append("[/comment]");
        return DUMMY;
    }

    @Override
    public Object caseComment(Comment comment) {
        this.builder.append("[comment ");
        this.doSwitch(comment.getBody());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseCommentBody(CommentBody commentBody) {
        this.builder.append(StringServices.NEW_LINE_PATTERN.matcher(commentBody.getValue()).replaceAll(this.newLine));
        return DUMMY;
    }

    @Override
    public Object caseDocumentation(Documentation documentation) {
        this.builder.append("[**");
        this.doSwitch(documentation.getBody());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseExpression(Expression expression) {
        this.builder.append(this.querySerializer.serialize(expression.getAst().getAst()));
        return DUMMY;
    }

    @Override
    public Object caseExpressionStatement(ExpressionStatement expressionStatement) {
        this.builder.append("[");
        if (expressionStatement.getExpression() != null && (expressionStatement.getExpression().getAql() instanceof Conditional || expressionStatement.getExpression().getAql() instanceof Let)) {
            this.builder.append(" ");
        }
        this.doSwitch(expressionStatement.getExpression());
        this.builder.append("/]");
        if (expressionStatement.isNewLineNeeded()) {
            this.insertNewLine();
        }
        return DUMMY;
    }

    @Override
    public Object caseFileStatement(FileStatement fileStatement) {
        this.updateCurrentBlockHeaderStartColumn();
        this.builder.append("[file ");
        this.builder.append("(");
        this.doSwitch(fileStatement.getUrl());
        this.builder.append(",");
        this.builder.append(" ");
        this.builder.append(fileStatement.getMode().getName());
        if (fileStatement.getCharset() != null) {
            this.builder.append(",");
            this.builder.append(" ");
            this.doSwitch(fileStatement.getCharset());
        }
        this.builder.append(")");
        this.builder.append("]");
        this.doSwitch(fileStatement.getBody());
        this.builder.append("[/file]");
        return DUMMY;
    }

    @Override
    public Object caseForStatement(ForStatement forStatement) {
        this.updateCurrentBlockHeaderStartColumn();
        this.builder.append("[for ");
        this.builder.append("(");
        this.bindingSeparator = "|";
        if (forStatement.getBinding() != null) {
            this.doSwitch(forStatement.getBinding());
        }
        this.builder.append(")");
        if (forStatement.getSeparator() != null) {
            this.builder.append(" ");
            this.builder.append("separator(");
            this.doSwitch(forStatement.getSeparator());
            this.builder.append(")");
        }
        this.builder.append("]");
        this.doSwitch(forStatement.getBody());
        this.builder.append("[/for]");
        return DUMMY;
    }

    @Override
    public Object caseIfStatement(IfStatement ifStatement) {
        this.updateCurrentBlockHeaderStartColumn();
        this.builder.append("[if ");
        this.builder.append("(");
        this.doSwitch(ifStatement.getCondition());
        this.builder.append(")");
        this.builder.append("]");
        if (ifStatement.getThen() != null) {
            this.doSwitch(ifStatement.getThen());
        }
        if (ifStatement.getElse() != null) {
            Block elseBlock = ifStatement.getElse();
            this.generateElse(elseBlock);
        }
        this.builder.append("[/if]");
        return DUMMY;
    }

    private void generateElse(Block block) {
        this.updateCurrentBlockHeaderStartColumn();
        if (block.getStatements().size() == 1 && block.getStatements().get(0) instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)block.getStatements().get(0);
            this.builder.append("[elseif ");
            this.builder.append("(");
            this.doSwitch(ifStatement.getCondition());
            this.builder.append(")");
            this.builder.append("]");
            this.doSwitch(ifStatement.getThen());
            if (ifStatement.getElse() != null) {
                Block elseBlock = ifStatement.getElse();
                this.generateElse(elseBlock);
            }
        } else {
            this.builder.append("[else]");
            this.doSwitch(block);
        }
    }

    @Override
    public Object caseImport(Import imp) {
        this.builder.append("[import ");
        this.doSwitch(imp.getModule());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseLetStatement(LetStatement letStatement) {
        this.updateCurrentBlockHeaderStartColumn();
        this.builder.append("[let ");
        if (!letStatement.getVariables().isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                this.bindingSeparator = "=";
                for (Binding binding : letStatement.getVariables()) {
                    this.doSwitch(binding);
                    this.builder.append(",");
                    this.builder.append(" ");
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append("]");
        this.doSwitch(letStatement.getBody());
        this.builder.append("[/let]");
        return DUMMY;
    }

    @Override
    public Object caseMetamodel(Metamodel metamodel) {
        this.builder.append("'");
        if (metamodel.getReferencedPackage() != null) {
            this.builder.append(metamodel.getReferencedPackage().getNsURI());
        }
        this.builder.append("'");
        return DUMMY;
    }

    @Override
    public Object caseModule(Module module) {
        if (module.getEncoding() != null) {
            this.builder.append("[comment ");
            this.builder.append("encoding");
            this.builder.append(" ");
            this.builder.append("=");
            this.builder.append(" ");
            this.builder.append(module.getEncoding());
            this.builder.append(" ");
            this.builder.append("/]");
            this.insertNewLine();
        }
        if (module.getDocumentation() != null) {
            this.doSwitch(module.getDocumentation());
            this.insertNewLine();
        }
        this.builder.append("[module ");
        this.builder.append(module.getName());
        this.builder.append("(");
        if (!module.getMetamodels().isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                for (Object metamodel : module.getMetamodels()) {
                    this.doSwitch((EObject)metamodel);
                    this.builder.append(",");
                    this.builder.append(" ");
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append(")");
        if (module.getExtends() != null) {
            this.builder.append(" ");
            this.builder.append("extends ");
            this.doSwitch(module.getExtends());
        }
        this.builder.append("/]");
        if (!module.getImports().isEmpty()) {
            this.insertNewLine();
            for (Import importedModule : module.getImports()) {
                this.insertNewLine();
                this.doSwitch(importedModule);
            }
        }
        List<ModuleElement> moduleElements = this.getSignificantModuleElements(module);
        int numberOfElements = moduleElements.size();
        int currentElementIndex = 0;
        if (!moduleElements.isEmpty()) {
            this.insertNewLine();
            for (ModuleElement moduleElement : moduleElements) {
                this.insertNewLine();
                this.doSwitch(moduleElement);
                if (++currentElementIndex >= numberOfElements || !(moduleElement instanceof Template) && !(moduleElement instanceof Query)) continue;
                this.insertNewLine();
            }
        }
        return DUMMY;
    }

    private List<ModuleElement> getSignificantModuleElements(Module module) {
        ArrayList<ModuleElement> res = new ArrayList<ModuleElement>();
        for (ModuleElement moduleElement : module.getModuleElements()) {
            if (moduleElement instanceof Documentation && ((Documentation)moduleElement).getDocumentedElement() != null) continue;
            res.add(moduleElement);
        }
        return res;
    }

    @Override
    public Object caseModuleDocumentation(ModuleDocumentation moduleDocumentation) {
        this.builder.append("[**");
        this.doSwitch(moduleDocumentation.getBody());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseModuleElementDocumentation(ModuleElementDocumentation moduleElementDocumentation) {
        this.builder.append("[**");
        this.doSwitch(moduleElementDocumentation.getBody());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseModuleReference(ModuleReference moduleReference) {
        this.builder.append(moduleReference.getQualifiedName());
        return DUMMY;
    }

    @Override
    public Object caseProtectedArea(ProtectedArea protectedArea) {
        this.updateCurrentBlockHeaderStartColumn();
        this.builder.append("[protected ");
        this.builder.append("(");
        this.doSwitch(protectedArea.getId());
        this.builder.append(")");
        if (protectedArea.getStartTagPrefix() != null) {
            this.builder.append(" ");
            this.builder.append("startTagPrefix(");
            this.doSwitch(protectedArea.getStartTagPrefix());
            this.builder.append(")");
        }
        if (protectedArea.getEndTagPrefix() != null) {
            this.builder.append(" ");
            this.builder.append("endTagPrefix(");
            this.doSwitch(protectedArea.getEndTagPrefix());
            this.builder.append(")");
        }
        this.builder.append("]");
        this.doSwitch(protectedArea.getBody());
        this.builder.append("[/protected]");
        return DUMMY;
    }

    @Override
    public Object caseQuery(Query query) {
        if (query.getDocumentation() != null) {
            this.doSwitch(query.getDocumentation());
            this.insertNewLine();
        }
        this.builder.append("[query ");
        this.builder.append((Object)query.getVisibility());
        this.builder.append(" ");
        this.builder.append(query.getName());
        this.builder.append("(");
        if (!query.getParameters().isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                for (Variable parameter : query.getParameters()) {
                    this.doSwitch(parameter);
                    this.builder.append(",");
                    this.builder.append(" ");
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append(")");
        this.builder.append(" ");
        if (query.getType() != null) {
            this.builder.append(":");
            this.builder.append(" ");
            this.builder.append(this.querySerializer.serialize(query.getType().getAst()));
            this.builder.append(" ");
        }
        this.builder.append("=");
        this.builder.append(" ");
        this.doSwitch(query.getBody());
        this.builder.append("/]");
        return DUMMY;
    }

    @Override
    public Object caseTemplate(Template template) {
        if (template.getDocumentation() != null) {
            this.doSwitch(template.getDocumentation());
            this.insertNewLine();
        }
        this.updateCurrentBlockHeaderStartColumn();
        this.builder.append("[template ");
        this.builder.append((Object)template.getVisibility());
        this.builder.append(" ");
        this.builder.append(template.getName());
        this.builder.append("(");
        if (!template.getParameters().isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                for (Variable parameter : template.getParameters()) {
                    this.doSwitch(parameter);
                    this.builder.append(",");
                    this.builder.append(" ");
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append(")");
        if (template.getGuard() != null) {
            this.builder.append(" ");
            this.builder.append("?");
            this.builder.append(" ");
            this.builder.append("(");
            this.doSwitch(template.getGuard());
            this.builder.append(")");
        }
        if (template.getPost() != null) {
            this.builder.append(" ");
            this.builder.append("post(");
            this.doSwitch(template.getPost());
            this.builder.append(")");
        }
        this.builder.append("]");
        this.doSwitch(template.getBody());
        this.builder.append("[/template]");
        return DUMMY;
    }

    @Override
    public Object caseTextStatement(TextStatement textStatement) {
        this.builder.append(StringServices.NEW_LINE_PATTERN.matcher(textStatement.getValue()).replaceAll(this.newLine));
        if (textStatement.isNewLineNeeded()) {
            this.insertNewLine();
        }
        return DUMMY;
    }

    @Override
    public Object caseVariable(Variable variable) {
        String variableName = AstBuilder.protectWithUnderscore((String)variable.getName());
        this.builder.append(variableName);
        this.builder.append(" ");
        this.builder.append(":");
        this.builder.append(" ");
        this.builder.append(this.querySerializer.serialize(variable.getType().getAst()));
        return DUMMY;
    }

    @Override
    public Object caseNewLineStatement(NewLineStatement newLineStatement) {
        int lastIndexOfNewLine = this.builder.lastIndexOf(this.newLine);
        if (!newLineStatement.isIndentationNeeded()) {
            if (this.builder.substring(lastIndexOfNewLine).trim().isEmpty()) {
                this.builder.setLength(lastIndexOfNewLine + this.newLine.length());
            } else {
                this.builder.append(this.newLine);
            }
        }
        this.insertNewLine();
        return DUMMY;
    }

    private void insertNewLine() {
        this.builder.append(this.newLine);
        this.builder.append(this.currentIndentation);
    }

    private void updateCurrentBlockHeaderStartColumn() {
        int lastNewLineIndex = this.builder.lastIndexOf(this.newLine);
        this.currentBlockHeaderStartColumn = lastNewLineIndex <= 0 ? this.builder.length() : this.builder.length() - (lastNewLineIndex + this.newLine.length());
    }
}

