/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.jdt.runtime.impl.namespace;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.ide.jdt.Activator;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.EclipseQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;

public class EclipseJDTQualifiedNameResolver
extends ClassLoaderQualifiedNameResolver {
    private final IJavaProject project;
    private final boolean forWorkspace;
    private final java.net.URI[] dependencyProjectEntries;

    public EclipseJDTQualifiedNameResolver(ClassLoader classLoader, IProject project, String qualifierSeparator, boolean forWorkspace, List<String> dependencyProjectEntries) {
        super(EclipseJDTQualifiedNameResolver.createProjectClassLoader(classLoader, project, forWorkspace, dependencyProjectEntries), qualifierSeparator);
        this.project = JavaCore.create((IProject)project);
        this.forWorkspace = forWorkspace;
        ArrayList<java.net.URI> uriList = new ArrayList<java.net.URI>();
        for (String entry : dependencyProjectEntries) {
            Path path = new Path(entry);
            java.net.URI uri = path.toFile().toURI();
            uriList.add(uri);
        }
        this.dependencyProjectEntries = uriList.toArray(new java.net.URI[uriList.size()]);
    }

    protected static ClassLoader createProjectClassLoader(ClassLoader classLoader, IProject project, boolean forWorspace, List<String> dependencyProjectEntries) {
        ClassLoader res;
        block9: {
            if (project.exists() && project.isOpen()) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject != null && javaProject.exists()) {
                    try {
                        ArrayList<Bundle> dependencyBundlesList = new ArrayList<Bundle>();
                        String[] classPathEntries = EclipseJDTQualifiedNameResolver.getClassPathes(javaProject, forWorspace, dependencyProjectEntries, dependencyBundlesList);
                        ArrayList<URL> urlList = new ArrayList<URL>();
                        String[] stringArray = classPathEntries;
                        int n = classPathEntries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String entry = stringArray[n2];
                            Path path = new Path(entry);
                            URL url = path.toFile().toURI().toURL();
                            urlList.add(url);
                            ++n2;
                        }
                        URL[] urls = urlList.toArray(new URL[urlList.size()]);
                        if (forWorspace) {
                            res = new URLClassLoader(urls, classLoader);
                            break block9;
                        }
                        Bundle[] dependencyBundles = dependencyBundlesList.toArray(new Bundle[dependencyBundlesList.size()]);
                        res = new BundleDelegatingClassLoader(urls, classLoader, dependencyBundles);
                    }
                    catch (CoreException e) {
                        Activator.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.jdt", "can't load from workspace.", (Throwable)e));
                        res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
                    }
                    catch (MalformedURLException e) {
                        Activator.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.jdt", "can't load from workspace.", (Throwable)e));
                        res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
                    }
                } else {
                    res = EclipseQualifiedNameResolver.createProjectClassLoader((ClassLoader)classLoader, (IProject)project);
                }
            } else {
                res = classLoader;
            }
        }
        return res;
    }

    private static String[] getClassPathes(IJavaProject javaProject, boolean forWorkspace, List<String> dependencyProjectEntries, List<Bundle> dependencyBundlesList) throws CoreException {
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
        ArrayList<String> resolved = new ArrayList<String>(unresolved.length);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry entry = unresolved[i];
            if (entry.getClasspathProperty() == 3) {
                IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (IJavaProject)javaProject);
                int j = 0;
                while (j < entries.length) {
                    String location = entries[j].getLocation();
                    if (location != null) {
                        if (forWorkspace) {
                            if (EclipseJDTQualifiedNameResolver.isDependencyProjectEntry(javaProject, entries[j])) {
                                dependencyProjectEntries.add(location);
                            }
                            resolved.add(location);
                        } else {
                            Bundle bundle = EclipseJDTQualifiedNameResolver.getBundle(location);
                            if (bundle != null) {
                                dependencyBundlesList.add(bundle);
                            } else {
                                resolved.add(location);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    private static Bundle getBundle(String location) {
        String symbolicName = EclipseJDTQualifiedNameResolver.getBundleSymbolicName(location);
        Bundle res = symbolicName != null ? Platform.getBundle((String)symbolicName) : null;
        return res;
    }

    private static String getBundleSymbolicName(String location) {
        String[] segments = location.replace("\\", "/").split("/");
        String lastSegment = segments[segments.length - 1];
        String res = lastSegment.split("_")[0];
        return res;
    }

    private static boolean isDependencyProjectEntry(IJavaProject javaProject, IRuntimeClasspathEntry entry) {
        IResource entryResource;
        boolean res = entry.getType() == 1 && javaProject.getProject() != entry.getResource() ? true : (entryResource = entry.getResource()) != null && entryResource.exists() && entryResource.getProject() != null && !entryResource.getProject().equals((Object)javaProject.getProject());
        return res;
    }

    protected Object load(String qualifiedName) {
        Object res;
        if (!this.forWorkspace || !this.isInDependencyProject(super.getURI(qualifiedName))) {
            res = super.load(qualifiedName);
        } else {
            res = null;
            this.dummyRegistration(qualifiedName);
        }
        return res;
    }

    private boolean isInDependencyProject(java.net.URI uri) {
        boolean res = false;
        if (uri != null) {
            java.net.URI[] uRIArray = this.dependencyProjectEntries;
            int n = this.dependencyProjectEntries.length;
            int n2 = 0;
            while (n2 < n) {
                java.net.URI entryURI = uRIArray[n2];
                if (!entryURI.relativize(uri).equals(uri)) {
                    res = true;
                    break;
                }
                ++n2;
            }
        }
        return res;
    }

    public java.net.URI getSourceURI(String qualifiedName) {
        java.net.URI res;
        block5: {
            if (this.project != null) {
                try {
                    java.net.URI foundURI = this.getSourceURI(this.project, qualifiedName);
                    if (foundURI != null) {
                        res = foundURI;
                        break block5;
                    }
                    res = super.getSourceURI(qualifiedName);
                }
                catch (JavaModelException e) {
                    res = super.getSourceURI(qualifiedName);
                }
            } else {
                res = super.getSourceURI(qualifiedName);
            }
        }
        return res;
    }

    private java.net.URI getSourceURI(IJavaProject javaProject, String qualifiedName) throws JavaModelException {
        java.net.URI res = null;
        IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        block0: while (n2 < n) {
            IProject childProject;
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                String srcFolder = entry.getPath().toString();
                List relativePathes = this.getPossibleResourceNames(qualifiedName);
                for (String relativePath : relativePathes) {
                    java.net.URI uri = workspaceRoot.getFile((IPath)new Path(srcFolder + "/" + relativePath)).getLocationURI();
                    File file = new File(uri);
                    if (!file.isFile() || !file.exists()) continue;
                    res = java.net.URI.create(URI.createFileURI((String)file.getAbsolutePath()).toString());
                    break block0;
                }
            } else if (entry.getEntryKind() == 2 && (childProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())) != null) {
                IJavaProject childJavaProject = JavaCore.create((IProject)childProject);
                res = this.getSourceURI(childJavaProject, qualifiedName);
            }
            ++n2;
        }
        return res;
    }

    public java.net.URI getBinaryURI(java.net.URI sourceURI) {
        java.net.URI res;
        block5: {
            if (this.project != null) {
                try {
                    java.net.URI foundURI = this.getBinaryURI(this.project, sourceURI);
                    if (foundURI != null) {
                        res = foundURI;
                        break block5;
                    }
                    res = super.getBinaryURI(sourceURI);
                }
                catch (JavaModelException e) {
                    res = super.getBinaryURI(sourceURI);
                }
            } else {
                res = super.getBinaryURI(sourceURI);
            }
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private java.net.URI getBinaryURI(IJavaProject javaProject, java.net.URI sourceURI) throws JavaModelException {
        IWorkspaceRoot workspaceRoot = javaProject.getProject().getWorkspace().getRoot();
        IFile sourceFile = workspaceRoot.getFileForLocation((IPath)new Path(sourceURI.getPath()));
        IClasspathEntry entry = this.getContainingEntry(javaProject, sourceFile);
        if (entry == null) return null;
        if (entry.getContentKind() == 2) {
            return sourceURI;
        }
        if (entry.getContentKind() != 1) throw new IllegalStateException("unknown classpath entry content kind.");
        IPath relativePath = sourceFile.getFullPath().makeRelativeTo(entry.getPath());
        IPath binaryPath = javaProject.getOutputLocation().append(relativePath);
        IFile binaryFile = workspaceRoot.getFile(binaryPath);
        if (!binaryFile.exists()) return null;
        return binaryFile.getLocationURI();
    }

    private IClasspathEntry getContainingEntry(IJavaProject javaProject, IFile sourceFile) throws JavaModelException {
        IClasspathEntry res;
        IClasspathEntry foundEntry = javaProject.findContainingClasspathEntry((IResource)sourceFile);
        if (foundEntry != null) {
            res = foundEntry;
        } else {
            IClasspathEntry fallbackFound = null;
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getPath().isPrefixOf(sourceFile.getFullPath())) {
                    fallbackFound = entry;
                    break;
                }
                ++n2;
            }
            res = fallbackFound;
        }
        return res;
    }

    protected IJavaProject getProject() {
        return this.project;
    }

    private static final class BundleDelegatingClassLoader
    extends URLClassLoader {
        private final Bundle[] dependencyBundles;

        private BundleDelegatingClassLoader(URL[] urls, ClassLoader parent, Bundle[] dependencyBundles) {
            super(urls, parent);
            this.dependencyBundles = dependencyBundles;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Bundle[] bundleArray = this.dependencyBundles;
            int n = this.dependencyBundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                try {
                    Class cls = bundle.loadClass(name);
                    if (cls != null) {
                        return cls;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++n2;
            }
            return super.findClass(name);
        }
    }
}

