/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.internal;

import org.eclipse.acceleo.aql.profiler.internal.IStack;

public class ArrayStack<T>
implements IStack<T> {
    private final T[] array;
    private int top;

    public ArrayStack(int size) {
        this.array = new Object[size];
    }

    @Override
    public void push(T elem) {
        try {
            this.array[this.top++] = elem;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("No space left in stack.");
        }
    }

    @Override
    public T peek() {
        try {
            return this.array[this.top - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("Stack is empty.");
        }
    }

    @Override
    public T pop() {
        T res = null;
        try {
            res = this.array[--this.top];
            this.array[this.top] = null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException("Stack is empty.");
        }
        return res;
    }

    @Override
    public void clear() {
        while (this.top > 0) {
            this.array[--this.top] = null;
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder(this.array.length * 10);
        int i = this.top - 1;
        while (i >= 0) {
            res.append(this.array[i].toString());
            if (i != 0) {
                res.append("\n");
            }
            --i;
        }
        return res.toString();
    }

    @Override
    public int size() {
        return this.top;
    }

    @Override
    public T get(int index) {
        if (index < this.top) {
            return this.array[index];
        }
        throw new IllegalStateException("Too few elements in the stack.");
    }

    public boolean contains(T elem) {
        boolean res = false;
        int i = this.top - 1;
        while (i >= 0) {
            if (this.array[i].equals(elem)) {
                res = true;
                break;
            }
            --i;
        }
        return res;
    }
}

