/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.SWTBotTests.dotnetnew;

import org.eclipse.acute.SWTBotTests.dotnetnew.AbstractNewWizardTest;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestProjectCreation
extends AbstractNewWizardTest {
    private IProject newProject;

    @Override
    @After
    public void tearDown() throws CoreException {
        if (this.newProject != null) {
            this.newProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        super.tearDown();
    }

    @Test
    public void testPreSets() {
        SWTBotShell shell = this.openWizard();
        this.newProject = this.checkProjectCreate(shell, null);
    }

    @Test
    public void testNewLocation() throws CoreException {
        IFolder folder = this.project.getFolder("TestFolder");
        folder.create(false, false, null);
        SWTBotShell shell = this.openWizard();
        bot.text(0).setText(folder.getLocation().toString());
        Assert.assertTrue((String)"Updating directory did not set Project name", (boolean)bot.text(1).getText().equals(folder.getLocation().lastSegment()));
        this.newProject = this.checkProjectCreate(shell, null);
    }

    @Test
    public void testNewName() {
        SWTBotShell shell = this.openWizard();
        bot.toggleButton(0).click();
        bot.textWithLabel("Project name").setText("NewProject" + System.currentTimeMillis());
        this.newProject = this.checkProjectCreate(shell, null);
    }

    @Test
    public void testAddToWorkingSet() {
        SWTBotShell shell = this.openWizard();
        int numOfWSMade = 3;
        if (!bot.checkBox(0).isChecked()) {
            bot.checkBox(0).click();
        }
        bot.button("Select...").click();
        SWTBotShell selectWorkingSetShell = bot.shell("Select Working Sets");
        int i = 0;
        while (i < numOfWSMade) {
            selectWorkingSetShell.activate();
            bot.button("New...").click();
            bot.shell("New Working Set").activate();
            bot.textWithLabel("Working set name:").setText("testWS" + i);
            bot.button("Finish").click();
            ++i;
        }
        selectWorkingSetShell.activate();
        bot.button("OK").click();
        IWorkingSet[] allWorkingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        IWorkingSet[] testWorkingSets = new IWorkingSet[3];
        IWorkingSet[] iWorkingSetArray = allWorkingSets;
        int n = allWorkingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet iWorkingSet = iWorkingSetArray[n2];
            if (iWorkingSet.getName().matches("testWS\\d")) {
                testWorkingSets[numOfWSMade - 1] = iWorkingSet;
                --numOfWSMade;
            }
            ++n2;
        }
        bot.shell("New .NET Core Project").activate();
        this.newProject = this.checkProjectCreate(shell, testWorkingSets);
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray2 = testWorkingSets;
        int n3 = testWorkingSets.length;
        n = 0;
        while (n < n3) {
            IWorkingSet iWorkingSet = iWorkingSetArray2[n];
            manager.removeWorkingSet(iWorkingSet);
            ++n;
        }
    }
}

