/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.SWTBotTests.dotnetnew;

import org.eclipse.acute.SWTBotTests.dotnetnew.AbstractNewWizardTest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToggleButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.Assert;
import org.junit.Test;

public class TestWizardUI
extends AbstractNewWizardTest {
    @Test
    public void testSelectedFolderPresetDirectory() {
        SWTBotView view = bot.viewByTitle("Project Explorer");
        SWTBotTree tree = new SWTBot(view.getWidget()).tree(0);
        SWTBotTreeItem item = tree.getTreeItem(this.project.getName());
        item.select();
        this.openWizard();
        Assert.assertEquals((String)"Selected container was not used for pre-set project name", (Object)this.project.getName(), (Object)bot.textWithLabel("Project name").getText());
        Assert.assertEquals((String)"Selected container was not used for pre-set project location", (Object)this.project.getLocation().toString(), (Object)bot.textWithLabel("Location").getText());
        bot.button("Cancel").click();
    }

    @Test
    public void testRelinkingSetsName() {
        this.openWizard();
        SWTBotText nameText = bot.textWithLabel("Project name");
        SWTBotToggleButton linkButton = bot.toggleButton(0);
        linkButton.click();
        Assert.assertTrue((String)"Name field did not enable after unlinking", (boolean)nameText.isEnabled());
        nameText.setText("DifferentProjectName");
        bot.textWithLabel("Location").setText("/new/directory/with/expectedProjectName");
        linkButton.click();
        Assert.assertFalse((String)"Name field did not disable after linking", (boolean)nameText.isEnabled());
        Assert.assertEquals((String)"Name field did not update content after linking", (Object)"expectedProjectName", (Object)nameText.getText());
        bot.button("Cancel").click();
    }

    @Test
    public void testPresetFolderNameCreation() throws CoreException {
        SWTBotShell shell = this.openWizard();
        String firstPresetName = bot.textWithLabel("Project name").getText();
        IProject newProject = this.checkProjectCreate(shell, null);
        bot.closeAllEditors();
        shell = this.openWizard();
        String secondPresetName = bot.textWithLabel("Project name").getText();
        Assert.assertNotEquals((String)"Pre-set project name is not unique from currently created project", (Object)firstPresetName, (Object)secondPresetName);
        bot.button("Cancel").click();
        newProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }
}

