/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.shapes;

import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.ParaxialBoundingBoxImpl;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.shapes.Shape;
import org.eclipse.draw3d.util.Draw3DCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PositionableShape
implements Shape {
    private static final Logger log = Logger.getLogger(PositionableShape.class.getName());
    private IPosition3D m_position3D;

    public PositionableShape(IPosition3D i_position3D) {
        this.m_position3D = i_position3D;
    }

    protected abstract float doGetDistance(IVector3f var1, IVector3f var2, Map<Object, Object> var3);

    protected abstract void doRender(RenderContext var1);

    @Override
    public float getDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        float distance;
        float newLength;
        Vector3f newDirection;
        Vector3f newOrigin;
        block7: {
            block6: {
                if (this.m_position3D == null || this.m_position3D.getTransformationMatrix().equals(IMatrix4f.IDENTITY)) {
                    return this.doGetDistance(i_rayOrigin, i_rayDirection, i_context);
                }
                newOrigin = Draw3DCache.getVector3f();
                newDirection = Draw3DCache.getVector3f();
                try {
                    newOrigin.set(i_rayOrigin);
                    newDirection.set(i_rayDirection);
                    if (this.m_position3D.transformRay(newOrigin, newDirection)) break block6;
                }
                catch (Throwable throwable) {
                    Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin, newDirection});
                    throw throwable;
                }
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin, newDirection});
                return Float.NaN;
            }
            newLength = newDirection.length();
            if (newLength != 1.0f) {
                newDirection.scale(1.0f / newLength);
            }
            if (!Float.isNaN(distance = this.doGetDistance((IVector3f)newOrigin, (IVector3f)newDirection, i_context))) break block7;
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin, newDirection});
            return Float.NaN;
        }
        float f = distance / newLength;
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{newOrigin, newDirection});
        return f;
    }

    @Override
    public float getDistanceMeasure(RenderContext i_renderContext) {
        float f;
        Vector3f viewPoint = Draw3DCache.getVector3f();
        Vector3f diff = Draw3DCache.getVector3f();
        try {
            i_renderContext.getScene().getCamera().getPosition(viewPoint);
            Math3D.sub((IVector3f)this.m_position3D.getCenter3D(), (IVector3f)viewPoint, (Vector3f)diff);
            f = diff.lengthSquared();
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{viewPoint, diff});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{viewPoint, diff});
        return f;
    }

    @Override
    public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
        ParaxialBoundingBox paraxialBoundingBox;
        ParaxialBoundingBox result = o_result;
        if (result == null) {
            result = new ParaxialBoundingBoxImpl();
        }
        Vector3f location = Math3DCache.getVector3f();
        Vector3f size = Math3DCache.getVector3f();
        try {
            Math3D.getCuboidParaxialBoundingBox((IPosition3D)this.m_position3D, (Vector3f)location, (Vector3f)size);
            result.setLocation((IVector3f)location);
            result.setSize((IVector3f)size);
            paraxialBoundingBox = result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
            throw throwable;
        }
        Math3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
        return paraxialBoundingBox;
    }

    public IPosition3D getPosition3D() {
        return this.m_position3D;
    }

    @Override
    public void render(RenderContext i_renderContext) {
        if (i_renderContext.getScene().isDebug()) {
            this.doRender(i_renderContext);
        }
        if (this.m_position3D == null) {
            this.doRender(i_renderContext);
        } else {
            Graphics3D g3d = i_renderContext.getGraphics3D();
            boolean useModelMatrix = this.m_position3D != null && !IMatrix4f.IDENTITY.equals(this.m_position3D.getTransformationMatrix());
            g3d.glMatrixMode(5888);
            if (useModelMatrix) {
                g3d.glPushMatrix();
            }
            try {
                if (useModelMatrix) {
                    g3d.setPosition(this.m_position3D);
                }
                this.doRender(i_renderContext);
            }
            finally {
                if (useModelMatrix) {
                    g3d.glPopMatrix();
                }
            }
        }
    }
}

