/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.data;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.ascape.util.data.DataGroup;
import org.ascape.util.data.DataPoint;
import org.ascape.util.data.DataSeries;
import org.ascape.util.data.DataSeriesStore;
import org.ascape.util.data.StatCollectorCSA;
import org.ascape.util.data.StatCollectorCSAMM;
import org.ascape.util.data.StatCollectorCSAMMVar;

public class StatCollector
implements Comparable,
DataPoint,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int count;
    protected String name = "Unnamed";
    protected boolean autoCollect = true;
    private DataSeries[] dataSeries;
    public static final int SET_BY_DATAGROUP = 0;
    public static final int COLLECTING = 1;
    public static final int NOT_COLLECTING = 2;
    private int collectingLongitudinalDataMode = 0;
    private DataGroup dataGroup;
    protected static String[] allMeasureNames = new String[]{"Count", "Minimum", "Maximum", "Variance", "Standard Deviation", "Sum", "Average"};
    protected static String[] allMeasureNamesShort = new String[]{"Count", "Min", "Max", "Var", "StD", "Sum", "Avg"};

    public StatCollector() {
    }

    public StatCollector(String name, boolean autoCollect) {
        this.name = name;
        this.autoCollect = autoCollect;
    }

    public StatCollector(String name) {
        this(name, true);
    }

    public void clear() {
        this.count = 0;
    }

    public void addValueFor(Object object) {
        this.addValue(this.getValue(object));
    }

    public void addValue(double value) {
        ++this.count;
    }

    public double getValue(Object object) {
        return 0.0;
    }

    public double calculateValue() {
        return 0.0;
    }

    public boolean isCalculated() {
        return false;
    }

    public boolean isPhase2() {
        return false;
    }

    public boolean isAutoCollect() {
        return this.autoCollect && !this.isCalculated();
    }

    public void setAutoCollect(boolean autoCollect) {
        this.autoCollect = autoCollect;
    }

    public boolean isCollectingLongitudinalData() {
        if (this.collectingLongitudinalDataMode == 2) {
            return false;
        }
        if (this.collectingLongitudinalDataMode == 0) {
            return this.dataGroup.isCollectingLongitudinalData();
        }
        return true;
    }

    public void setCollectingLongitudinalDataMode(int mode) {
        this.collectingLongitudinalDataMode = mode;
    }

    public int getCollectingLongitudinalDataMode() {
        return this.collectingLongitudinalDataMode;
    }

    public int getCount() {
        return this.count;
    }

    public static String[] getAllMeasureNames() {
        return allMeasureNames;
    }

    public static String[] getAllMeasureNamesShort() {
        return allMeasureNamesShort;
    }

    public DataSeries[] getAllDataSeries() {
        if (this.dataSeries == null) {
            this.createDataSeries(this.isCollectingLongitudinalData());
        }
        return this.dataSeries;
    }

    public DataSeries getDataSeries(String measureName) {
        if (measureName.equals("Total")) {
            measureName = "Sum";
            System.out.print("Warning, using \"Total " + this + "\" to reference statisitic.");
            System.out.print("Usage is deprecated, use \"Sum " + this + "\" instead.");
        }
        int i = 0;
        while (i < this.dataSeries.length) {
            if (this.dataSeries[i].getMeasureName().equals(measureName)) {
                return this.dataSeries[i];
            }
            ++i;
        }
        throw new RuntimeException("Data series " + measureName + " of " + this + " doesn't exist.");
    }

    public void calculateCollection(Collection collection) {
        this.clear();
        this.calculateIterator(collection.iterator());
    }

    public void calculateIterator(Iterator iter) {
        this.clear();
        while (iter.hasNext()) {
            this.addValueFor(iter.next());
        }
    }

    public synchronized void createDataSeries(boolean collectingLongitudinalData) {
        ArrayList<DataSeries> tempSeries = new ArrayList<DataSeries>();
        if (this instanceof StatCollector) {
            DataSeries countSeries = collectingLongitudinalData ? new DataSeriesStore(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollector)this.point).getCount();
                }

                public String getMeasureName() {
                    return "Count";
                }
            } : new DataSeries(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollector)this.point).getCount();
                }

                public String getMeasureName() {
                    return "Count";
                }
            };
            countSeries.setDataPoint(this);
            tempSeries.add(countSeries);
        } else {
            tempSeries.add(null);
        }
        if (this instanceof StatCollectorCSAMM) {
            DataSeries minSeries = collectingLongitudinalData ? new DataSeriesStore(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSAMM)this.point).getMin();
                }

                public String getMeasureName() {
                    return "Minimum";
                }
            } : new DataSeries(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSAMM)this.point).getMin();
                }

                public String getMeasureName() {
                    return "Minimum";
                }
            };
            minSeries.setDataPoint(this);
            tempSeries.add(minSeries);
        } else {
            tempSeries.add(null);
        }
        if (this instanceof StatCollectorCSAMM) {
            DataSeries maxSeries = collectingLongitudinalData ? new DataSeriesStore(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSAMM)this.point).getMax();
                }

                public String getMeasureName() {
                    return "Maximum";
                }
            } : new DataSeries(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSAMM)this.point).getMax();
                }

                public String getMeasureName() {
                    return "Maximum";
                }
            };
            maxSeries.setDataPoint(this);
            tempSeries.add(maxSeries);
        } else {
            tempSeries.add(null);
        }
        if (this instanceof StatCollectorCSAMMVar) {
            DataSeries varianceSeries = collectingLongitudinalData ? new DataSeriesStore(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSAMMVar)this.point).getVar();
                }

                public String getMeasureName() {
                    return "Variance";
                }
            } : new DataSeries(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSAMMVar)this.point).getVar();
                }

                public String getMeasureName() {
                    return "Variance";
                }
            };
            varianceSeries.setDataPoint(this);
            tempSeries.add(varianceSeries);
        } else {
            tempSeries.add(null);
        }
        if (this instanceof StatCollectorCSAMMVar) {
            DataSeries stdevSeries = collectingLongitudinalData ? new DataSeriesStore(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSAMMVar)this.point).getStDev();
                }

                public String getMeasureName() {
                    return "Standard Deviation";
                }
            } : new DataSeries(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSAMMVar)this.point).getStDev();
                }

                public String getMeasureName() {
                    return "Standard Deviation";
                }
            };
            stdevSeries.setDataPoint(this);
            tempSeries.add(stdevSeries);
        } else {
            tempSeries.add(null);
        }
        if (this instanceof StatCollectorCSA) {
            DataSeries sumSeries = collectingLongitudinalData ? new DataSeriesStore(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSA)this.point).getSum();
                }

                public String getMeasureName() {
                    return "Sum";
                }
            } : new DataSeries(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSA)this.point).getSum();
                }

                public String getMeasureName() {
                    return "Sum";
                }
            };
            sumSeries.setDataPoint(this);
            tempSeries.add(sumSeries);
        } else {
            tempSeries.add(null);
        }
        if (this instanceof StatCollectorCSA) {
            DataSeries avgSeries = collectingLongitudinalData ? new DataSeriesStore(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSA)this.point).getAvg();
                }

                public String getMeasureName() {
                    return "Average";
                }
            } : new DataSeries(){
                private static final long serialVersionUID = 1L;

                public double getValue() {
                    return ((StatCollectorCSA)this.point).getAvg();
                }

                public String getMeasureName() {
                    return "Average";
                }
            };
            avgSeries.setDataPoint(this);
            tempSeries.add(avgSeries);
        } else {
            tempSeries.add(null);
        }
        this.dataSeries = collectingLongitudinalData ? new DataSeriesStore[tempSeries.size()] : new DataSeries[tempSeries.size()];
        this.dataSeries = tempSeries.toArray(new DataSeries[tempSeries.size()]);
    }

    public void setDataGroup(DataGroup dataGroup) {
        this.dataGroup = dataGroup;
    }

    public DataGroup getDataGroup() {
        return this.dataGroup;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " StatCollector";
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((StatCollector)o).getName());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.dataSeries != null && this.dataSeries[0] != null && this.dataSeries[0] instanceof DataSeriesStore) {
            this.clear();
            int i = 0;
            while (i < this.dataSeries.length) {
                DataSeries ds = this.dataSeries[i];
                if (ds != null) {
                    ds.clear();
                }
                ++i;
            }
        }
        out.defaultWriteObject();
    }
}

