/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class Math3DBase {
    public static boolean equals(float left, float right, float epsilon) {
        return Math.abs(left - right) <= epsilon;
    }

    public static boolean equals(float[] afleft, float[] afright, float epsilon) {
        if (afleft.length != afright.length) {
            return false;
        }
        int i = 0;
        while (i < afleft.length) {
            if (Math.abs(afleft[i] - afright[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void getCuboidParaxialBoundingBox(IPosition3D i_position, Vector3f o_location, Vector3f o_size) {
        if (i_position == null) {
            throw new NullPointerException("i_position must not be null");
        }
        if (o_location == null) {
            throw new NullPointerException("o_location must not be null");
        }
        if (o_size == null) {
            throw new NullPointerException("o_size must not be null");
        }
        Position3D absolute = Math3DCache.getPosition3D();
        Vector3f end = Math3DCache.getVector3f();
        Vector3f p = Math3DCache.getVector3f();
        try {
            i_position.getAbsolute(absolute);
            if (IVector3f.NULLVEC3f.equals(absolute.getRotation3D())) {
                o_location.set(absolute.getLocation3D());
                o_size.set(absolute.getSize3D());
            } else {
                IMatrix4f matrix = absolute.getTransformationMatrix();
                p.set(0.0f, 0.0f, 0.0f);
                p.transform(matrix);
                o_location.set(p);
                end.set(p);
                p.set(0.0f, 0.0f, 0.0f);
                p.transform(matrix);
                Math3D.min(o_location, p, o_location);
                Math3D.max(end, p, end);
                p.set(0.0f, 0.0f, 1.0f);
                p.transform(matrix);
                Math3D.min(o_location, p, o_location);
                Math3D.max(end, p, end);
                p.set(0.0f, 1.0f, 0.0f);
                p.transform(matrix);
                Math3D.min(o_location, p, o_location);
                Math3D.max(end, p, end);
                p.set(0.0f, 1.0f, 1.0f);
                p.transform(matrix);
                Math3D.min(o_location, p, o_location);
                Math3D.max(end, p, end);
                p.set(1.0f, 0.0f, 0.0f);
                p.transform(matrix);
                Math3D.min(o_location, p, o_location);
                Math3D.max(end, p, end);
                p.set(1.0f, 0.0f, 1.0f);
                p.transform(matrix);
                Math3D.min(o_location, p, o_location);
                Math3D.max(end, p, end);
                p.set(1.0f, 1.0f, 0.0f);
                p.transform(matrix);
                Math3D.min(o_location, p, o_location);
                Math3D.max(end, p, end);
                p.set(1.0f, 1.0f, 1.0f);
                p.transform(matrix);
                Math3D.min(o_location, p, o_location);
                Math3D.max(end, p, end);
                Math3D.sub(end, o_location, o_size);
            }
        }
        catch (Throwable throwable) {
            Math3DCache.returnPosition3D(absolute);
            Math3DCache.returnVector3f(end, p);
            throw throwable;
        }
        Math3DCache.returnPosition3D(absolute);
        Math3DCache.returnVector3f(end, p);
    }

    public static Vector3f getRayPoint(IVector3f i_rayOrigin, IVector3f i_rayDirection, float i_distance, Vector3f o_result) {
        if (i_rayOrigin == null) {
            throw new NullPointerException("i_rayOrigin must not be null");
        }
        if (i_rayDirection == null) {
            throw new NullPointerException("i_rayDirection must not be null");
        }
        if (Float.isNaN(i_distance)) {
            return null;
        }
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        if (i_distance == 0.0f) {
            result.set(i_rayOrigin);
        } else {
            result.set(i_rayDirection);
            result.scale(i_distance);
            Math3D.add(i_rayOrigin, result, result);
        }
        return result;
    }

    public static Side getSideOfPoint(IVector3f i_planePoint, IVector3f i_planeNormal, IVector3f i_point) {
        Vector3f tmp;
        block8: {
            float cos;
            block7: {
                Side side;
                if (i_planePoint == null) {
                    throw new NullPointerException("i_planePoint must not be null");
                }
                if (i_planeNormal == null) {
                    throw new NullPointerException("i_planeNormal must not be null");
                }
                if (i_point == null) {
                    throw new NullPointerException("i_point must not be null");
                }
                if (i_planePoint.equals(i_point)) {
                    return null;
                }
                tmp = Math3DCache.getVector3f();
                try {
                    Math3D.sub(i_point, i_planePoint, tmp);
                    cos = Math3D.dot(i_planeNormal, tmp);
                    if (!(cos > 0.0f)) break block7;
                    side = Side.FRONT;
                }
                catch (Throwable throwable) {
                    Math3DCache.returnVector3f(tmp);
                    throw throwable;
                }
                Math3DCache.returnVector3f(tmp);
                return side;
            }
            if (!(cos < 0.0f)) break block8;
            Side side = Side.BACK;
            Math3DCache.returnVector3f(tmp);
            return side;
        }
        Math3DCache.returnVector3f(tmp);
        return null;
    }

    public static boolean in(float i_boundary1, float i_boundary2, float i_value) {
        float max;
        float min;
        if (Float.isNaN(i_boundary1) || Float.isNaN(i_boundary2)) {
            throw new IllegalArgumentException("boundaries must be numbers");
        }
        if (Float.isNaN(i_value)) {
            return false;
        }
        if (i_boundary1 < i_boundary2) {
            min = i_boundary1;
            max = i_boundary2;
        } else {
            min = i_boundary2;
            max = i_boundary1;
        }
        return i_value >= min && i_value <= max;
    }

    public static Vector3f lineIntersectsPlane(IVector3f i_linePoint1, IVector3f i_linePoint2, IVector3f i_planePoint, IVector3f i_planeNormal, Vector3f o_result) {
        float denominator;
        float numerator;
        Vector3f tmp;
        Vector3f result;
        block8: {
            if (i_linePoint1 == null) {
                throw new NullPointerException("i_linePoint1 must not be null");
            }
            if (i_linePoint2 == null) {
                throw new NullPointerException("i_linePoint2 must not be null");
            }
            if (i_planePoint == null) {
                throw new NullPointerException("i_planePoint must not be null");
            }
            if (i_planeNormal == null) {
                throw new NullPointerException("i_planeNormal must not be null");
            }
            result = o_result;
            if (result == null) {
                result = new Vector3fImpl();
            }
            tmp = Math3DCache.getVector3f();
            try {
                Math3D.sub(i_linePoint2, i_linePoint1, tmp);
                float d = Math3D.dot(i_planePoint, i_planeNormal);
                numerator = d - i_planeNormal.getX() * i_linePoint1.getX() - i_planeNormal.getY() * i_linePoint1.getY() - i_planeNormal.getZ() * i_linePoint1.getZ();
                denominator = i_planeNormal.getX() * tmp.getX() + i_planeNormal.getY() * tmp.getY() + i_planeNormal.getZ() * tmp.getZ();
                if (denominator != 0.0f) break block8;
            }
            catch (Throwable throwable) {
                Math3DCache.returnVector3f(tmp);
                throw throwable;
            }
            Math3DCache.returnVector3f(tmp);
            return null;
        }
        float t = numerator / denominator;
        tmp.scale(t);
        Math3D.add(i_linePoint1, tmp, result);
        Vector3f vector3f = result;
        Math3DCache.returnVector3f(tmp);
        return vector3f;
    }

    public static float maxDistance(float i_distance1, float i_distance2) {
        if (Float.isNaN(i_distance1)) {
            return i_distance2;
        }
        if (Float.isNaN(i_distance2)) {
            return i_distance1;
        }
        return Math.max(i_distance1, i_distance2);
    }

    public static float maxDistance(float[] i_distances) {
        if (i_distances == null) {
            return Float.NaN;
        }
        if (i_distances.length == 1) {
            return i_distances[0];
        }
        float d = Math3DBase.maxDistance(i_distances[0], i_distances[1]);
        int i = 2;
        while (i < i_distances.length) {
            d = Math3DBase.maxDistance(d, i_distances[i]);
            ++i;
        }
        return d;
    }

    public static float minDistance(float i_distance1, float i_distance2) {
        if (Float.isNaN(i_distance1)) {
            return i_distance2;
        }
        if (Float.isNaN(i_distance2)) {
            return i_distance1;
        }
        return Math.min(i_distance1, i_distance2);
    }

    public static float minDistance(float[] i_distances) {
        if (i_distances == null) {
            return Float.NaN;
        }
        if (i_distances.length == 1) {
            return i_distances[0];
        }
        float d = Math3DBase.minDistance(i_distances[0], i_distances[1]);
        int i = 2;
        while (i < i_distances.length) {
            d = Math3DBase.minDistance(d, i_distances[i]);
            ++i;
        }
        return d;
    }

    public static float rayIntersectsPlane(IVector3f i_rayOrigin, IVector3f i_rayDirection, IVector3f i_planePoint, IVector3f i_planeNormal) {
        float denominator = Math3D.dot(i_rayDirection, i_planeNormal);
        return Math3DBase.rayIntersectsPlane(i_rayOrigin, i_rayDirection, i_planePoint, i_planeNormal, denominator);
    }

    private static float rayIntersectsPlane(IVector3f i_rayOrigin, IVector3f i_rayDirection, IVector3f i_planePoint, IVector3f i_planeNormal, float i_denominator) {
        if (i_denominator == 0.0f) {
            return Float.NaN;
        }
        float d = Math3D.dot(i_planePoint, i_planeNormal);
        float numerator = d - Math3D.dot(i_rayOrigin, i_planeNormal);
        float t = numerator / i_denominator;
        if (t < 0.0f) {
            return Float.NaN;
        }
        return t;
    }

    public static Vector3f rayIntersectsPlane(IVector3f i_rayOrigin, IVector3f i_rayDirection, IVector3f i_planePoint, IVector3f i_planeNormal, Vector3f io_result) {
        float distance = Math3DBase.rayIntersectsPlane(i_rayOrigin, i_rayDirection, i_planePoint, i_planeNormal);
        return Math3DBase.getRayPoint(i_rayOrigin, i_rayDirection, distance, io_result);
    }

    public static float rayIntersectsPolygon(IVector3f i_rayOrigin, IVector3f i_rayDirection, IVector3f[] i_polygon, IVector3f i_normal, Vector3f o_intersection) {
        float f;
        block21: {
            float distance;
            Vector3f intersection;
            block19: {
                block20: {
                    float cos;
                    block17: {
                        block18: {
                            if (i_rayOrigin == null) {
                                throw new NullPointerException("i_rayOrigin must not be null");
                            }
                            if (i_rayDirection == null) {
                                throw new NullPointerException("i_rayDirection must not be null");
                            }
                            if (i_polygon == null) {
                                throw new NullPointerException("i_polygon must not be null");
                            }
                            if (i_normal == null) {
                                throw new NullPointerException("i_normal must not be null");
                            }
                            if (i_polygon.length < 3) {
                                throw new IllegalArgumentException("a polygon must have at least three vertices");
                            }
                            intersection = o_intersection;
                            if (intersection == null) {
                                intersection = Math3DCache.getVector3f();
                            }
                            cos = Math3D.dot(i_rayDirection, i_normal);
                            if (!(cos >= 0.0f)) break block17;
                            if (o_intersection != null) break block18;
                            Math3DCache.returnVector3f(intersection);
                        }
                        return Float.NaN;
                    }
                    try {
                        distance = Math3DBase.rayIntersectsPlane(i_rayOrigin, i_rayDirection, i_polygon[0], i_normal, cos);
                        Math3DBase.getRayPoint(i_rayOrigin, i_rayDirection, distance, intersection);
                        ProjectionPlane projectionPlane = ProjectionPlane.getPlane(i_normal);
                        float ix = projectionPlane.getX(intersection);
                        float iy = projectionPlane.getY(intersection);
                        int c = 0;
                        IVector3f p0 = i_polygon[i_polygon.length - 1];
                        int i = 0;
                        while (i < i_polygon.length) {
                            IVector3f p1 = i_polygon[i];
                            float x0 = projectionPlane.getX(p0) - ix;
                            float y0 = projectionPlane.getY(p0) - iy;
                            float x1 = projectionPlane.getX(p1) - ix;
                            float y1 = projectionPlane.getY(p1) - iy;
                            if (x0 == 0.0f && y0 == 0.0f || x1 == 0.0f && y1 == 0.0f) {
                                c = 1;
                                break;
                            }
                            if (y0 > 0.0f && y1 <= 0.0f || y0 <= 0.0f && y1 > 0.0f) {
                                float x;
                                if (x0 > 0.0f && x1 > 0.0f) {
                                    ++c;
                                } else if ((x0 > 0.0f && x1 <= 0.0f || x0 <= 0.0f && x1 > 0.0f) && (x = -y0 * (x1 - x0) / (y1 - y0) + x0) >= 0.0f) {
                                    ++c;
                                }
                            }
                            p0 = p1;
                            ++i;
                        }
                        if (c % 2 != 0) break block19;
                        if (o_intersection != null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (o_intersection == null) {
                            Math3DCache.returnVector3f(intersection);
                        }
                        throw throwable;
                    }
                    Math3DCache.returnVector3f(intersection);
                }
                return Float.NaN;
            }
            f = distance;
            if (o_intersection != null) break block21;
            Math3DCache.returnVector3f(intersection);
        }
        return f;
    }

    public static float rayIntersectsPolygon(IVector3f i_rayOrigin, IVector3f i_rayDirection, IVector3f[] i_polygon, Vector3f o_intersection) {
        float f;
        if (i_polygon == null) {
            throw new NullPointerException("i_polygon must not be null");
        }
        if (i_polygon.length < 3) {
            throw new IllegalArgumentException("a polygon must have at least three vertices");
        }
        Vector3f a = Math3DCache.getVector3f();
        Vector3f b = Math3DCache.getVector3f();
        Vector3f normal = Math3DCache.getVector3f();
        try {
            Math3D.sub(i_polygon[1], i_polygon[0], b);
            Math3D.sub(i_polygon[i_polygon.length - 1], i_polygon[0], b);
            Math3D.cross(a, b, normal);
            Math3D.normalise(normal, normal);
            f = Math3DBase.rayIntersectsPolygon(i_rayOrigin, i_rayDirection, i_polygon, normal, o_intersection);
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(a, b, normal);
            throw throwable;
        }
        Math3DCache.returnVector3f(a, b, normal);
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector3f segmentIntersectsPlane(IVector3f i_segmentPoint1, IVector3f i_segmentPoint2, IVector3f i_planePoint, IVector3f i_planeNormal, Vector3f o_result) {
        Vector3f vector3f;
        if (i_segmentPoint1 == null) {
            throw new NullPointerException("i_segmentPoint1 must not be null");
        }
        if (i_segmentPoint2 == null) {
            throw new NullPointerException("i_segmentPoint2 must not be null");
        }
        Vector3f dir = Math3DCache.getVector3f();
        try {
            Math3D.sub(i_segmentPoint2, i_segmentPoint1, dir);
            float max = dir.length();
            Math3D.normalise(dir, dir);
            float t = Math3DBase.rayIntersectsPlane(i_segmentPoint1, dir, i_planePoint, i_planeNormal);
            if (Float.isNaN(t) || t > max) {
                Math3DCache.returnVector3f(dir);
                return null;
            }
            Vector3f result = o_result;
            if (result == null) {
                result = new Vector3fImpl();
            }
            result.set(dir);
            result.scale(t);
            Math3D.add(i_segmentPoint1, result, result);
            vector3f = result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(dir);
            throw throwable;
        }
        Math3DCache.returnVector3f(dir);
        return vector3f;
    }

    public static float[] solveQuadraticEquation(float A, float B, float C, float[] o_result) {
        float[] result = o_result;
        if (result == null) {
            result = new float[2];
        } else if (result.length < 2) {
            throw new IllegalArgumentException("result array is too small");
        }
        float p = B / A;
        float q = C / A;
        float p2 = p / 2.0f;
        float r = p2 * p2 - q;
        if (r < 0.0f) {
            result[0] = Float.NaN;
            result[1] = Float.NaN;
        } else if (r == 0.0f) {
            result[0] = -p2;
            result[1] = Float.NaN;
        } else {
            float s = (float)Math.sqrt(r);
            result[0] = -p2 + s;
            result[1] = -p2 - s;
        }
        return result;
    }

    public static float[] solveQuadraticEquation(float B, float C, float[] o_result) {
        return Math3DBase.solveQuadraticEquation(1.0f, B, C, o_result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProjectionPlane {
        XY,
        XZ,
        ZY;


        public static ProjectionPlane getPlane(IVector3f i_normal) {
            float max;
            float xy = Math.abs(Math3D.dot(XY.getNormal(), i_normal));
            float xz = Math.abs(Math3D.dot(XZ.getNormal(), i_normal));
            float zy = Math.abs(Math3D.dot(ZY.getNormal(), i_normal));
            ProjectionPlane plane = null;
            if (xy > xz) {
                plane = XY;
                max = xy;
            } else {
                plane = XZ;
                max = xz;
            }
            if (zy > max) {
                plane = ZY;
            }
            return plane;
        }

        public IVector3f getNormal() {
            switch (this) {
                case XY: {
                    return IVector3f.Z_AXIS;
                }
                case XZ: {
                    return IVector3f.Y_AXIS;
                }
            }
            return IVector3f.X_AXIS;
        }

        public float getX(IVector3f i_vector) {
            switch (this) {
                case XY: {
                    return i_vector.getX();
                }
                case XZ: {
                    return i_vector.getX();
                }
            }
            return i_vector.getZ();
        }

        public float getY(IVector3f i_vector) {
            switch (this) {
                case XY: {
                    return i_vector.getY();
                }
                case XZ: {
                    return i_vector.getZ();
                }
            }
            return i_vector.getY();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        BACK,
        FRONT;

    }
}

