/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.offscreen;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBufferConfig;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBuffers;
import org.eclipse.draw3d.util.Draw3DCache;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;

public class LwjglOffscreenBuffersFbo
implements Graphics3DOffscreenBuffers {
    private static final Logger log = Logger.getLogger(LwjglOffscreenBuffersFbo.class.getName());
    private Graphics3DOffscreenBufferConfig m_bufferConfig;
    private int m_glColorBuffer;
    private int m_glDepthBuffer;
    private int m_glFrameBuffer;
    private int m_height;
    private boolean m_initBuffers;
    private int m_width;

    public LwjglOffscreenBuffersFbo(int i_height, int i_width, Graphics3DOffscreenBufferConfig i_bufferConfig) {
        this.m_height = i_height;
        this.m_width = i_width;
        this.m_bufferConfig = i_bufferConfig;
    }

    private void createFbo() {
        IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
        try {
            EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)buffer);
            this.m_glFrameBuffer = buffer.get(0);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
    }

    private void createRenderBuffers() {
        Graphics3DOffscreenBufferConfig bufferConfig = this.m_bufferConfig;
        int numBuffers = 0;
        if (bufferConfig.isEnabled(16384)) {
            ++numBuffers;
        }
        if (bufferConfig.isEnabled(256)) {
            ++numBuffers;
        }
        if (numBuffers == 0) {
            return;
        }
        IntBuffer buffer = Draw3DCache.getIntBuffer((int)(numBuffers - 1));
        try {
            EXTFramebufferObject.glGenRenderbuffersEXT((IntBuffer)buffer);
            int width = this.m_width;
            int height = this.m_height;
            if (bufferConfig.isEnabled(16384)) {
                this.m_glColorBuffer = buffer.get(0);
                EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.m_glColorBuffer);
                int format = bufferConfig.getColorPixelFormat();
                EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)format, (int)width, (int)height);
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36064, (int)36161, (int)this.m_glColorBuffer);
            }
            if (bufferConfig.isEnabled(256)) {
                this.m_glDepthBuffer = buffer.get(numBuffers - 1);
                EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.m_glDepthBuffer);
                EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6402, (int)width, (int)height);
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)this.m_glDepthBuffer);
            }
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
    }

    private void deleteFbo() {
        if (EXTFramebufferObject.glIsFramebufferEXT((int)this.m_glFrameBuffer)) {
            IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
            try {
                buffer.rewind();
                buffer.put(this.m_glFrameBuffer);
                EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)buffer);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
        }
    }

    private void deleteRenderBuffers() {
        int numBuffers = 0;
        if (EXTFramebufferObject.glIsRenderbufferEXT((int)this.m_glColorBuffer)) {
            ++numBuffers;
        }
        if (EXTFramebufferObject.glIsRenderbufferEXT((int)this.m_glColorBuffer)) {
            ++numBuffers;
        }
        if (numBuffers == 0) {
            return;
        }
        IntBuffer buffer = Draw3DCache.getIntBuffer((int)numBuffers);
        try {
            buffer.rewind();
            if (EXTFramebufferObject.glIsRenderbufferEXT((int)this.m_glColorBuffer)) {
                buffer.put(this.m_glColorBuffer);
            }
            if (EXTFramebufferObject.glIsRenderbufferEXT((int)this.m_glDepthBuffer)) {
                buffer.put(this.m_glDepthBuffer);
            }
            EXTFramebufferObject.glDeleteRenderbuffersEXT((IntBuffer)buffer);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
    }

    public void dispose() {
        this.deleteRenderBuffers();
        this.deleteFbo();
    }

    private String getStatus(int i_status) {
        switch (i_status) {
            case 36053: {
                return "GL_FRAMEBUFFER_COMPLETE_EXT";
            }
            case 36054: {
                return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT";
            }
            case 36055: {
                return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT";
            }
            case 36058: {
                return "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT";
            }
            case 36059: {
                return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT";
            }
            case 36060: {
                return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT";
            }
        }
        return "unknown status code " + i_status;
    }

    public void init() {
        this.createFbo();
    }

    public void initBuffers() {
        this.m_initBuffers = true;
    }

    public boolean isBackBuffer() {
        return false;
    }

    public void postRender(ByteBuffer i_colorBuffer, FloatBuffer i_depthBuffer) {
        int width = this.m_width;
        int height = this.m_height;
        Graphics3DOffscreenBufferConfig bufferConfig = this.m_bufferConfig;
        if (bufferConfig.isEnabled(16384)) {
            int format = bufferConfig.getColorPixelFormat();
            int type = bufferConfig.getColorDataType();
            i_colorBuffer.rewind();
            GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)i_colorBuffer);
        }
        if (bufferConfig.isEnabled(256)) {
            int type = bufferConfig.getDepthDataType();
            i_depthBuffer.rewind();
            GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6402, (int)type, (FloatBuffer)i_depthBuffer);
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
    }

    public void preRender() {
        if (this.m_initBuffers) {
            this.deleteRenderBuffers();
            this.deleteFbo();
            this.createFbo();
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.m_glFrameBuffer);
            this.createRenderBuffers();
            int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
            if (status != 36053) {
                throw new RuntimeException(this.getStatus(status));
            }
            this.m_initBuffers = false;
        } else {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.m_glFrameBuffer);
        }
    }

    public void setBufferConfig(Graphics3DOffscreenBufferConfig i_bufferConfig) {
        this.m_bufferConfig = i_bufferConfig;
    }

    public void setHeight(int i_height) {
        this.m_height = i_height;
    }

    public void setWidth(int i_width) {
        this.m_width = i_width;
    }
}

